"""
@version: Toolkit V200R006C00
@time: 2019/10/25
@file: check_item_software_disk_enclosure_number.py
@function:
@modify:
"""
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
max_disk_device_type_dict = \
    {60: ['2800 V5', '5500 V5', '5600 V5', '5800 V5', '5500F V5',
          '5600F V5', '5800F V5'],
     30: ['6800 V5', '18500 V5', '18800 V5', '6800F V5', '18500F V5',
          '18800F V5']}
error_dae = {"DAE999", "999"}


def execute(cli):
    all_cli_ret = ''
    # 获取设备版本和热补丁
    cli_ret, sys_version_list, hotpatch_version_list = \
        common.parse_upgradePackage(cli, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret[1])
    if cli_ret[0] is not True:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, cli_ret[2]
    hot_patch_flag, hot_patch, hotpatch_error = common.getHotPatchVersion(
        hotpatch_version_list, LANG)
    if not hot_patch_flag:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, hotpatch_error
    product_version_flag, product_version, product_version_error \
        = common.getCurrentVersion(sys_version_list, LANG)
    if not product_version_flag:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, product_version_error
    # 获取设备型号
    sys_flag, product_model, sys_cli_ret, error_msg = cliUtil. \
        getProductModelWithCliRet(cli, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, sys_cli_ret)
    if sys_flag is not True:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, error_msg
    # 融合存储V5 V5R7C50之下的版本才进行检查
    if 'DORADO' in product_model.upper():
        return True, all_cli_ret, ''
    if not product_version.upper().startswith(
            'V500R') or product_version.upper() >= 'V500R007C50':
        return True, all_cli_ret, ''
    # 获取当前版本设备最大支持硬盘框数，如果为0表示不需要检查
    max_num = get_device_max_disk_enclosure_num(product_model)
    if max_num == 0:
        return True, all_cli_ret, ''
    cmd = 'show enclosure'
    flag, cli_ret, error = cliUtil.excuteCmdInCliMode(cli, cmd,
                                                      True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
    if flag is not True:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, error
    # 获取硬盘框ID
    dict_list = cliUtil.getHorizontalCliRet(cli_ret)
    engine_enclosure_dict, error_enclosure_list \
        = analysis_engine_enclosure(dict_list)
    check_flag, check_error = check_max_num(engine_enclosure_dict,
                                            error_enclosure_list,
                                            max_num)
    return check_flag, all_cli_ret, check_error


def get_device_max_disk_enclosure_num(product_model):
    """
    获取该系统版本硬盘框最大数量限制，如果版本不需要检查，返回0
    :param product_model:
    :return:
    """
    max_num = 0
    for key in max_disk_device_type_dict.keys():
        device_type = max_disk_device_type_dict[key]
        if product_model in device_type:
            max_num = key
            break
    return max_num


def analysis_engine_enclosure(dict_list):
    """
    解析硬盘框回显，获取每个控制框下硬盘框集合dict
    获取ID后检查是否已DAE开头，如果是，尝试获取第四位作为控制框ID
    如果发现失效硬盘，需特殊记录，每个引擎都要计算
    :param dict_list:
    :return:
    """
    engine_enclosure_dict = {}
    error_enclosure_list = []
    for disk in dict_list:
        disk_id = disk.get("ID", "")
        if disk_id.upper() in error_dae:
            error_enclosure_list.append(disk_id)
            continue
        if disk_id.upper().startswith('DAE') and len(disk_id) > 3:
            disk_list = []
            engine_id = disk_id[3:4]
            if engine_id in engine_enclosure_dict.keys():
                disk_list = engine_enclosure_dict[engine_id]
            disk_list.append(disk_id)
            engine_enclosure_dict[engine_id] = disk_list
    return engine_enclosure_dict, error_enclosure_list


def check_max_num(engine_enclosure_dict, error_enclosure_list, max_num):
    """
    每个控制框下是否超过最大数量限制检查，每个引擎下需要额外计算错误硬盘框数量
    :param error_enclosure_list:
    :param engine_enclosure_dict:
    :param max_num:
    :return:
    """
    flag = True
    error = ''
    if not bool(engine_enclosure_dict):
        return flag, error
    for engine_enclosure in engine_enclosure_dict:
        engine_and_error_length = len(
            engine_enclosure_dict[engine_enclosure]) + len(
            error_enclosure_list)
        if engine_and_error_length >= max_num:
            flag = False
            if bool(error_enclosure_list):
                error = common.\
                    joinLines(error,
                              common.
                              getMsg(
                                  LANG,
                                  'disk.enclosure.number.'
                                  'with.errordisk.error',
                                  (engine_enclosure,
                                   engine_and_error_length,
                                   len(error_enclosure_list))))
            else:
                error = common.joinLines(
                    error,
                    common.getMsg(LANG, 'disk.enclosure.number.error', (
                        engine_enclosure,
                        engine_and_error_length)))
    return flag, error
