# -*- coding: UTF-8 -*-

from com.huawei.ism.tool.obase.exception import ToolException

import cliUtil
import common
import traceback
import config
from common import UnCheckException
from common import AsynProgress
import re
PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''
NO_CHECK_ERRMSG = ''

def execute(cli):
    """
步骤1 以admin用户登录设备。
步骤2 执行change user_mode current_mode user_mode=developer进入developer视图。
步骤3 执行minisystem进入minisystem视图。
步骤4 执行showsysstatus命令，获取节点id。
步骤5 执行showdiskinfo命令，获取所有硬盘的SN和槽位号。
步骤6 若软件版本为V300R002C10SPC100之前的版本（包括TV2和18000V1），minisystem视图下执行sshtoremote x(x = 节点id % 引擎下节点数量) 命令，实现同引擎内控制器间跳转登录；若软件版本为V300R002C10SPC100及其之后的版本，minisystem视图下执行sshtoremoteExt x(x = 节点id % 引擎下节点数量) 命令，实现同引擎内控制器间跳转登录。
步骤7 登录当前引擎内所有控制器执行步骤2至步骤5。
步骤8 连接集群中所有引擎执行步骤1至步骤7。

1、步骤4中若查询到控制器为单控场景，则巡检“通过”；
2、步骤7中当同引擎下的所有控制器节点都已查询完毕。根据硬盘SN比较记录的硬盘槽位号，若同一硬盘的槽位号在所有归属控制器上都相同，则巡检“通过”；否则巡检“不通过”。
解析规则：
（1）工具逐行读取showdiskinfo回显，发现”DISK(x, y)”则记录y为该硬盘的槽位号。
（2）继续读取，发现”sn”关键字，则记录紧接着的”,”前的字符串。
（3）继续读取，发现”DISK(x, y)”则表示为其它盘的信息，记录解析规则（1）,（2）中的硬盘sn及其对应的槽位号，DISK(x, y)中y表示硬盘槽位号。X为框号不需要检查。
（4）因盘故障，单链路或者其它原因导致的硬盘sn无法获取情况对该硬盘的检查均直接通过。
"""
    global ALL_CLI_RET
    notPassErrMsg = ''
    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start_thread()
    try:
        
        flag, cliRet = common.isSigleModelWithCliRet(cli, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag is True:
            return True, ALL_CLI_RET, ''

        isRisk, no_support_msg = isRiskProductVersion(cli)
        if not isRisk:
            return cliUtil.RESULT_NOSUPPORT, no_support_msg, ''

        # 获取每个引擎下的IP。
        flag, errMsg, ipListDict = getContrIpListOfEngine(ALL_CLI_RET, LANG)
        LOGGER.logInfo("ipListDict:[%s]" % ipListDict)
        if flag != True:
            raise UnCheckException(errMsg, ALL_CLI_RET)

        # 检查所有框下的控制器。
        diskMapEngineDict = checkAllEnclosure(cli, ipListDict)
        LOGGER.logInfo("all diskMapEngineDict:[%s]" % diskMapEngineDict)
        for engined in diskMapEngineDict:
            diskMapDict = diskMapEngineDict.get(engined, {})
            for nodeId in diskMapDict:
                for nodeIdb in diskMapDict:
                    if nodeId == nodeIdb:
                        continue
    
                    diskSnDict = diskMapDict[nodeId]
                    diskSnDictb = diskMapDict[nodeIdb]
                    for sn in diskSnDict:
                        if sn not in diskSnDictb:
                            continue
    
                        if diskSnDict.get(sn, '') != diskSnDictb.get(sn, ''):
                            LOGGER.logInfo(
                                "nodeId:[%s] and nodeId[%s] disk slot is not the same,sn[%s], slot a[%s], slotb[%s]" % (
                                    nodeId, nodeIdb, sn, diskSnDict.get(sn, ''), diskSnDictb.get(sn, '')))
                            notPassErrMsg += common.getMsg(LANG, "software.disk.slot.consistency.not.pass", (
                                nodeId, nodeIdb, sn, nodeId, diskSnDict.get(sn, ''), nodeIdb, diskSnDictb.get(sn, '')))

        
        if notPassErrMsg:
            return False, ALL_CLI_RET, notPassErrMsg + NO_CHECK_ERRMSG
        
        if NO_CHECK_ERRMSG:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, NO_CHECK_ERRMSG
        
        return (True, ALL_CLI_RET, "")

    except UnCheckException, unCheckException:
        LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)

    except (ToolException, Exception) as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))

    finally:
        # 退出到cli模式
        myPthread.setStopFlag(True)
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def checkAllEnclosure(cli, ipListDict):
    """
    检查当前框下的控制器信息：
    1.SVP 获取IP依次检查每个框。
    2.非SVP，则使用当前连接检查当前已连接的框，然后获取IP建立其他框的连接，再检查每个框。
    :param cli:
    :return:
    """
    global CURRENT_PROGRESS, ALL_CLI_RET
    disk_map_dict = {}
    current_ctrl_ip = PY_JAVA_ENV.get("devInfo").getIp()
    # 设置默认值为0号引擎，下面根据实际值更新
    current_engine = u'0'
    for engine_id in ipListDict:
        ip_list = ipListDict[engine_id]
        if current_ctrl_ip in ip_list:
            current_engine = engine_id
            LOGGER.logInfo("check currentIp is in ipList: True")
            break

    if common.is18000(PY_JAVA_ENV, cli):
        # 依次检查所有引擎
        flag, msg, tmp_cli, conn_ip = common.getConnectionByContrIpWithConnIp(
            PY_JAVA_ENV, cli, ipListDict, current_engine, LOGGER, LANG)
        if flag is not True:
            raise UnCheckException(msg, ALL_CLI_RET)

        if not tmp_cli:
            # 连接控制器失败。
            raise UnCheckException(msg, ALL_CLI_RET)

        try:
            # 检查当前引擎下的全部控制器
            disk_dict_temp = getEngineDiskInfo(tmp_cli)
            disk_map_dict[current_engine] = disk_dict_temp
            ipListDict.pop(current_engine)
            info_tuple = common.getEngineCtrlNodeInfo(tmp_cli, LOGGER, LANG)

            # 检查其他引擎
            for engine_id in ipListDict:
                flag, ret, msg, conn, exits = common.enginesJump(tmp_cli,
                                                                 engine_id,
                                                                 info_tuple[5],
                                                                 info_tuple[3],
                                                                 info_tuple[6],
                                                                 PY_JAVA_ENV,
                                                                 LOGGER,
                                                                 LANG,
                                                                 info_tuple[4])
                ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
                if flag is not True:
                    raise UnCheckException(msg, ALL_CLI_RET)

                disk_dict_temp = getEngineDiskInfo(conn)
                LOGGER.logInfo('diskMap in engine:%s is:%s' % (
                    engine_id, disk_dict_temp))
                disk_map_dict[engine_id] = disk_dict_temp

                common.enginesBack(conn, PY_JAVA_ENV, LOGGER, LANG, exits)
                LOGGER.logInfo("exit heart beat success.")
        except UnCheckException, unCheckException:
            raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
        finally:
            if current_ctrl_ip != conn_ip:
                common.closeSSH(tmp_cli)

        return disk_map_dict
    else:
        if current_engine in ipListDict:
            # 当前引擎使用默认cli连接查询。
            ipListDict.pop(current_engine)

            # 检查当前引擎下的全部控制器
            disk_dict_temp = getEngineDiskInfo(cli)
            disk_map_dict[current_engine] = disk_dict_temp

        # 检查其他引擎，如果没有其他引擎就直接返回检查结果。
        if not ipListDict:
            return disk_map_dict

        # 继续检查其他引擎，先建CLI连接，再心跳检查该引擎下的全部控制器。
        for engineId in ipListDict:
            info_tuple = common.getEngineCtrlNodeInfo(cli, LOGGER, LANG)
            flag, ret, msg, new_cli, exits = common.enginesJump(cli,
                                                                engineId,
                                                                info_tuple[5],
                                                                info_tuple[3],
                                                                info_tuple[6],
                                                                PY_JAVA_ENV,
                                                                LOGGER,
                                                                LANG,
                                                                info_tuple[4])

            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
            if flag is not True:
                raise UnCheckException(msg, ALL_CLI_RET)

            try:
                disk_dict_temp = getEngineDiskInfo(new_cli)
                disk_map_dict[engineId] = disk_dict_temp
            except UnCheckException, unCheckException:
                raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
            finally:
                common.enginesBack(new_cli, PY_JAVA_ENV, LOGGER, LANG, exits)
                LOGGER.logInfo("exit heart beat success.")

        return disk_map_dict


def getEngineDiskInfo(cli):
    """
    检查当前连接引擎是否存在成员盘数量问题。
    :param cli:
    """
    global ALL_CLI_RET, NO_CHECK_ERRMSG
    diskMapInfoDict = {}
    # 获取当前节点diskMap
    currentCtrlNodeId, currentEngineOtherCtrlIdList = getCurrentEngineCtrlNodeInfo(cli)
    LOGGER.logInfo("currentCtrlNodeId:%s, currentEngineOtherCtrlIdList:%s" % (currentCtrlNodeId,
                                                                              currentEngineOtherCtrlIdList))

    diskMap = getDiskSoltInfo(cli)
    diskMapInfoDict[currentCtrlNodeId] = diskMap

    # 获取当前引擎其他节点的diskMap
    for nodeId in currentEngineOtherCtrlIdList:
        flag, cliRet, _ = common.heartBeatToOtherCtrl(cli, nodeId, 
                                                           PY_JAVA_ENV, LOGGER, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag != True:
            NO_CHECK_ERRMSG += common.getMsg(LANG, "heart.beat.to.node.failed", nodeId)
            continue
        
        diskMap = getDiskSoltInfo(cli)
        diskMapInfoDict[nodeId] = diskMap
        cliUtil.exitHeartbeatCli(cli, LANG)

    return diskMapInfoDict


def getDiskSoltInfo(cli):
    """
    在当前节点获取硬盘详细信息
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    
    diskMap = {}
    cmd = "showdiskinfo"
    flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, ALL_CLI_RET)

    idx = cliRet.find('All scsi luns')
    if -1 != idx:
        miniRet = cliRet[:idx]

    lines = miniRet.splitlines()

    isParsingStart = False
    for line in lines:
        try:
            if not line.strip() or not isParsingStart:
                sn, sloat = '', ''
    
            if line.strip().startswith('id '):
                isParsingStart = True
    
            if isParsingStart and line.strip().startswith('DISK'):
                res = re.match(r"DISK\((\d+), (\d+)\)", line, re.I)
                if res:
                    sloat = res.group(2)
    
            if isParsingStart and line.strip().startswith('vendor') and "sn " in line:
                res = re.search("sn (\S+),", line)
                if res:
                    sn = res.group(1)
    
            if isParsingStart and sloat and sn:
                diskMap[sn] = sloat
                isParsingStart = False
                sn, sloat = '', ''
        except Exception, e:
            LOGGER.logInfo('get disk info except:%s' % str(e))
            LOGGER.logError(str(traceback.format_exc()))
            
    LOGGER.logInfo('diskMap is:%s' % diskMap)
    return diskMap


def getConnectionByContrIp(PY_JAVA_ENV, ip):
    """
    建立到阵列控制器的SSH连接，只有登录控制器的连接才能进入debug，minisystem模式
    :param PY_JAVA_ENV:
    :param ip:
    :return cliConnection:返回连接
    """
    # 连接进度条总数5
    cilConnection = common.getCilConnectionByIp(ip, PY_JAVA_ENV, LOGGER)
    if cilConnection:
        LOGGER.logInfo('Success to connect to controller(IP:%s)' % ip)
        return (True, cilConnection)
    else:
        LOGGER.logInfo('Failed to connect to controller(IP:%s)' % ip)
        return (False, None)


def getContrIpListOfEngine(ALL_CLI_RET, lang):
    """
    获取引擎对应下的控制器IP
    :param cli:
    :param lang:
    :return ipListDict: 引擎和引擎下控制器的IP。
    """
    ipListDict = {}
    beginIndex = ALL_CLI_RET.find("Software Version")
    endIndex = ALL_CLI_RET.find("HotPatch Version")
    infoDictList = cliUtil.getHorizontalCliRet(ALL_CLI_RET[beginIndex: endIndex])

    for infoDict in infoDictList:
        ip = infoDict.get("IP", "")
        contrName = infoDict.get("Name", "")
        if ip != "" and ip != "--" and contrName != "":
            engine = contrName[:1]
            ipList = ipListDict.get(engine, [])
            ipList.append(ip)
            ipListDict.update({engine: ipList})

    # 控制器未配置管理IP，无法连接控制器。请参考预警公告手动检查。
    if len(ipListDict) == 0:
        errMsg = common.getMsg(LANG, "contr.not.config.ip")
        return (False, errMsg, ipListDict)

    return (True, '', ipListDict)


def getCurrentEngineCtrlNodeInfo(cli):
    """
    @summary: 获取除当前节点外的引擎其他健康节点信息，当前节点信息。
    @param cli: cli连接
    @return: (currentCtrlNodeId, currentEngineCtrlIdList)
        currentNodeId: 当前节点ID
        currentEngineOtherCtrlIdList: 除当前节点外的引擎其他健康节点信息
    """
    global ALL_CLI_RET
    cmd = 'showsysstatus'
    # 当前节点
    currentCtrlNodeId = None
    currentEngine = None
    engineCtrlNodeMappingDict = {}

    flag, cliRet, errMsg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        LOGGER.logInfo("get node info Failed. errMsg: %s" % errMsg)
        raise UnCheckException(errMsg, ALL_CLI_RET)

    ctrlInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)

    for ctrlInfo in ctrlInfoDictList:
        if ctrlInfo.get("local node id", "") != "":
            currentCtrlNodeId = ctrlInfo.get("local node id", "")
            break

    for engineInfo in engineInfoDictList:
        engine = engineInfo.get("engine", "")
        if engine == "":
            continue

        ctrlNodeId = engineInfo.get("id", "")
        if ctrlNodeId == "":
            continue

        tmpList = engineCtrlNodeMappingDict.get(engine, [])
        tmpList.append(ctrlNodeId)
        engineCtrlNodeMappingDict[engine] = tmpList

        if ctrlNodeId == currentCtrlNodeId:
            currentEngine = engine

    # 当前引擎包含的控制器节点
    currentEngineOtherCtrlIdList = engineCtrlNodeMappingDict.get(currentEngine, [])
    currentEngineOtherCtrlIdList.remove(currentCtrlNodeId)
    return (currentCtrlNodeId, currentEngineOtherCtrlIdList)


def isRiskProductVersion(cli):
    """
    判断是否是风险型号
    :param cli:
    :return: True, 有风险
              False, 无风险
    """
    global ALL_CLI_RET
    # 获取软件型号
    flag, productVersion, _, cliRet, errMsg = common.getProductVersionAndHotPatchVersion(cli, LOGGER, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    LOGGER.logInfo("productVersion is :%s" % productVersion)
    if flag != True:
        LOGGER.logInfo("Failed to get productVersion errMsg:%s" % errMsg)
        raise UnCheckException(errMsg, ALL_CLI_RET)

    productModel = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
    if productModel in config.DORADO_DEVS_V3:
        return is_risk_version(productModel, productVersion,
                               config.RISK_SLOT_A_B_CONTROLLER_DORADO)
    else:
        return is_risk_version(productModel, productVersion,
                               config.RISK_SLOT_A_B_CONTROLLER_V3)


def is_risk_version(product_model, product_version, risk_version):
    """
    根据设备的版本型号，判断设备是否是风险版本，并返回对应信息
    :param product_model: 设备版本
    :param product_version: 设备型号
    :param risk_version: 风险型号
    :return:
    """
    if product_version in risk_version:
        return True, ""
    else:
        return False, common.version_no_support_msg(
            product_model, product_version,
            "", risk_version, LANG)
