# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        DeviceManager软件包检查: 
                    以查询到后端并发数则正常，否则属于不正常状态。
    '''
    
    PRODUCT_MODEL_LIST = ["6800 V3","18500 V3","18800 V3","6800F V3","18500F V3","18800F V3"]
    PRODUCT_VERSION_LIST = ["V300R006C00SPC100"]
    PATCH_VERSION = "V300R006C00SPH102"
    EXP_CFG = [2, 6] #6U 2 controllers and 6 controllers
    
    flag = True
    cliRet = ""
    errMsg = ""
    
    try:
            
        productModel = str(common.getProductModeFromContext(py_java_env))
        if productModel not in PRODUCT_MODEL_LIST:
            LOGGER.logInfo("The product model[%s] is not involed." %productModel)
            return (cliUtil.RESULT_NOSUPPORT, "","")
        
        ctrlRet = cliUtil.getControllerIdList(cli, LANG)
        if ctrlRet[0] != True:
            # 修改备注：getControllerIdList返回False是未检查
            if not ctrlRet[0]:
                return cliUtil.RESULT_NOCHECK, ctrlRet[1], ctrlRet[2]
            return ctrlRet
        
        curCtrlNum = len(ctrlRet[1])
        if curCtrlNum not in EXP_CFG:
            LOGGER.logInfo("expand config[curCtrlNum:%s] is not involed." %(curCtrlNum))
            return (cliUtil.RESULT_NOSUPPORT, "","")            
        
        ret, softwareVersionList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
        cliRet = ret[1]
        if not ret[0]:
            LOGGER.logInfo("get product version failed.")
            return (cliUtil.RESULT_NOCHECK, cliRet, ret[2])
        
        productVerRet = common.getCurrentVersion(softwareVersionList, LANG)
        if not productVerRet[0]:
            LOGGER.logInfo("get current version failed.")
            return (cliUtil.RESULT_NOCHECK, cliRet, ret[2])
        
        productVer = productVerRet[1]
        if productVer not in PRODUCT_VERSION_LIST:
            return (cliUtil.RESULT_NOSUPPORT, cliRet,"")
        
        patchRet = common.getHotPatchVersion(hotPatchVersionList, LANG)
        if not patchRet[0]:
            LOGGER.logInfo("get patch version failed.")
            return (cliUtil.RESULT_NOCHECK, cliRet, patchRet[2])
        
        patchVer = patchRet[1].upper()
        if patchVer == "--" or  patchVer < PATCH_VERSION:
            LOGGER.logNoPass("patch[%s] is too old."%patchVer)
            errMsg = common.getMsg(LANG, "dm.patch.too.old",patchVer)
            return (False, cliRet, errMsg)            

        LOGGER.logPass() 
        return (flag, cliRet, errMsg)    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
