# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
            文件系统快照检查
    '''
    cliRet = ""
    errMsg = ""
    finalFlag = True
    
    try:
        #1.获取文件系统ID列表
        retFlag, cliRet, errInfo, fsIdDictList = getFsID(cli)
        if retFlag != True:
            # 修改备注：getFsID返回False是未检查
            if not retFlag:
                return cliUtil.RESULT_NOCHECK, cliRet, errInfo
            return retFlag, cliRet, errInfo
        
        #2.遍历所有文件系统ID，查看是否存在快照
        cliInfo, notHaveSnapshotFsIds, failedFsIds = checkFsSnapshot(cli, fsIdDictList)
        cliRet += cliInfo
       
        #处理查看是否存在快照时出错的文件系统ID,置结果为未检查
        if failedFsIds:
            finalFlag = cliUtil.RESULT_NOCHECK
            errMsg += common.getMsg(LANG, "cannot.get.fs.Snapshot", ", ".join(failedFsIds))
        
        #3.不存在快照的文件系统，需要检查其快照预留百分比
        cliInfo, snapshotReserveNotZero, notGetSnapshotReserve = checkSnapshotReserve(cli, notHaveSnapshotFsIds)
        cliRet += cliInfo
    
        #将无法获取预留百分比的fsID做提示，并将结果置未检查
        if notGetSnapshotReserve:
            finalFlag = cliUtil.RESULT_NOCHECK 
            errMsg += common.getMsg(LANG, "cannot.get.fs.Snapshot.Reserve", ", ".join(notGetSnapshotReserve))
        
        #所有预留百分比不为0的文件系统提示
        for fsId in snapshotReserveNotZero:
            finalFlag = cliUtil.RESULT_WARNING
            snapshotReserve = snapshotReserveNotZero.get(fsId)
            errMsg += common.getMsg(LANG, "fs.Snapshot.Reserve.is", (fsId, snapshotReserve))

        if finalFlag == cliUtil.RESULT_WARNING:
            return cliUtil.RESULT_WARNING, cliRet, errMsg + common.getMsg(LANG, "fs.snap.warning.sugg")

        return (finalFlag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    
def getFsID(cli):
    '''
    @summary: 获取文件系统ID
    '''
    cliInfoDictList = []
    cmd = "show file_system general |filterColumn include columnList=ID"
    
    checkFlag, cliRet, errInfo = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    #命令不支持时，报不涉及
    if not cliUtil.hasCliExecPrivilege(cliRet):
        return (cliUtil.RESULT_NOSUPPORT, cliRet, "", cliInfoDictList)
    
    #其他失败场景
    if checkFlag != True:
        return (checkFlag, cliRet, errInfo, cliInfoDictList) 
    
    #命令执行成功，但是没有信息
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, errInfo, cliInfoDictList)
    
    #解析回显
    cliInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
    if not cliInfoDictList:
        return (False, cliRet, common.getMsg(LANG, "cannot.get.filesystem.info"), cliInfoDictList)
    
    return (True, cliRet, errInfo, cliInfoDictList)
    

def checkFsSnapshot(cli, fsIdDictList):
    '''
    @summary: 遍历所有文件系统，查看是否存在快照，返回不存在快照的文件系统ID
    '''
    notHaveSnapshotFsIds = []
    failedFsIds = []
    cmd = "show fs_snapshot general file_system_id=%s"
    cliRet = ""
    
    for fsIdDict in fsIdDictList:
        fsId = fsIdDict.get("ID")
        cmdFormat = cmd % fsId
        checkFlag, cliInfo, errInfo = cliUtil.excuteCmdInCliMode(cli, cmdFormat, True, LANG)
        
        #没有license时，也要查看预留百分比是否为0
        if cliUtil.isNoneLicense(cliInfo):
            cliRet += "\n" + cliInfo
            notHaveSnapshotFsIds.append(fsId)
            continue
        
        #命令执行失败
        if checkFlag != True:
            cliRet += "\n" + cliInfo
            failedFsIds.append(fsId)
            continue
        
        #不存在快照
        if cliUtil.queryResultWithNoRecord(cliInfo):
            cliRet += "\n" + cliInfo
            notHaveSnapshotFsIds.append(fsId)
            
    return (cliRet, notHaveSnapshotFsIds, failedFsIds)


def checkSnapshotReserve(cli, notHaveSnapshotFsIds):
    '''
    @summary: 检查文件系统的快照预留百分比是否为0
    '''  
    cmd = "show file_system general file_system_id=%s"
    cliRet = ""
    
    snapshotReserveField = "Snapshot Reserve(%)"
    snapshotReserveRe = r"^0$"
    keywodsDict = {snapshotReserveField:snapshotReserveRe}
    
    snapshotReserveNotZero = {}
    notGetSnapshotReserve = []
    
    for fsId in notHaveSnapshotFsIds:
        cmdFormat = cmd % fsId
        checkFlag, cliInfo, errInfo, actualValueDictList = common.checkKeywords(cli, cmdFormat, LANG, keywodsDict)
        cliRet += '\n' + cliInfo
        
        #预留百分比不是0，或字段不存在
        for keywordsDict in actualValueDictList:
            SnapshotReserve = keywordsDict.get(snapshotReserveField)
            #key不存在,则所有的fs都没有这个字段
            if SnapshotReserve == None:
                notGetSnapshotReserve.append(fsId)  
                return (cliRet, snapshotReserveNotZero, notGetSnapshotReserve)
            #值未匹配上，结果为建议优化
            else:
                snapshotReserveNotZero[fsId] = SnapshotReserve
                 
        #检查过程出错
        if checkFlag != True and not actualValueDictList:
            notGetSnapshotReserve.append(fsId)
            
    return (cliRet, snapshotReserveNotZero, notGetSnapshotReserve)   
    
    
    