# -*- coding: UTF-8 -*-
import cliUtil
import common
import common_cache
from cbb.frame.cli import cli_with_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


def execute(cli):
    """
    Namespace状态检查: 如果不存在相应的记录表示正常，否则属于不正常状态。
    """
    check_flag = True
    check_err_msg = ""
    all_ret_list = []
    try:
        common.refreshProcess(PY_JAVA_ENV, 30, LOGGER)
        LOGGER.logInfo("use cli cmd get lun.")
        flag, cli_ret, msg = get_lun_by_cli(cli)
        if flag is not True:
            return flag, cli_ret, msg

        lun_dict_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
        all_ret_list.append(cli_ret)

        check_flag, check_err_msg = check_namespace_status(check_err_msg, check_flag, lun_dict_list)
        common.refreshProcess(PY_JAVA_ENV, 95, LOGGER)
        if check_flag:
            LOGGER.logPass()
        ret = common_cache.save_cli_ret_to_file(all_ret_list, "software_lun", PY_JAVA_ENV, LOGGER)
        return check_flag, ret, check_err_msg
    except Exception as exception:
        ret = common_cache.save_cli_ret_to_file(all_ret_list, "software_lun", PY_JAVA_ENV, LOGGER)
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, ret, common.getMsg(LANG, "query.result.abnormal")
    finally:
        common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)


def check_namespace_status(check_err_msg, check_flag, lun_dict_list):
    """
    检查如果存在Health Status不为Normal或
    Running Status为Running Success\Running Normal\Online的Namespave表示状态正常，否则属于不正常状态

    @param check_err_msg:错误提示
    @param check_flag:检查结果
    @param lun_dict_list: namespace的记录。
    @return: 结果，错误提示
    """
    normal_running_status = ['Running Success', 'Running Normal', 'Online']
    for lun_info in lun_dict_list:
        running_status = lun_info.get('Running Status')
        health_status = lun_info.get('Health Status')
        if health_status != 'Normal' or running_status not in normal_running_status:
            check_flag = False
            lun_id = lun_info.get("ID")
            check_err_msg += common.getMsg(LANG, "namespace.status.abnormal", lun_id)
    return check_flag, check_err_msg


def get_lun_by_cli(cli):
    cmd = "show namespace general"
    flag, cli_ret, err_msg = cli_with_cache.execute_cmd_in_cli_mode_with_cache(PY_JAVA_ENV, cli, cmd, LOGGER)
    LOGGER.logInfo("result is {},{},{}".format(flag, cli_ret, err_msg))
    if flag is not True:
        if "TOOLKIT_SEND_CMD_TIME_OUT" in cli_ret:
            LOGGER.logInfo("reconnect!!!")
            cli.reConnect()
        LOGGER.logSysAbnormal()
        return flag, cli_ret, err_msg
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, cli_ret, err_msg

    common.refreshProcess(PY_JAVA_ENV, 70, LOGGER)
    return True, cli_ret, err_msg
