# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import config
from common import AsynProgress
from com.huawei.ism.tool.obase.exception import ToolException
from common import UnCheckException

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ""


def execute(cli):
    '''

    '''
    global ALL_CLI_RET
    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start_thread()
    connCli = ""
    try:
        if not is_fs_exist(cli):
            return True, ALL_CLI_RET, ''

        # 检查设备型号
        flag, productModel, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg)
        if productModel not in config.CHECK_NFSV4_STATE_ID_PRODUCT_MODEL_LIST:
            return (True, ALL_CLI_RET, "")

        #获取控制器内存大小
        flag, cacheCapacity, errMsg = getCacheCapacity(cli)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg)
        #如果是2200V3且内存为8.000GB检查通过。
        if productModel == "2200 V3" and cacheCapacity == "8.000GB":
            return (True, ALL_CLI_RET, "")

        # 查询产品版本和补丁版本号
        flag, cliRet, errMsg, softwareVersion, hotPatchVersion = common.getVersion(cli, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))
        LOGGER.logInfo("softwareVersion is: %s, hotPatchVersion:%s" % (softwareVersion, hotPatchVersion))
        if softwareVersion not in config.CHECK_NFSV4_STATE_ID_VERSION_HOTPATCH_DICT:
            return (True, ALL_CLI_RET, "")
        # 如果安装了补丁则检查通过
        needHotPatchVersion = config.CHECK_NFSV4_STATE_ID_VERSION_HOTPATCH_DICT.get(softwareVersion, "")
        if needHotPatchVersion != "" and hotPatchVersion != "--" and hotPatchVersion >= needHotPatchVersion:
            return (True, ALL_CLI_RET, "")

        # 检查admin下NFSV4是否开启
        checkFlag, checkResult, errMsg = checkNFSV4ServiceIsOn(cli)
        if checkFlag != True:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg)
        if checkResult == True:
            if needHotPatchVersion:
                return (False, ALL_CLI_RET,
                        common.getMsg(LANG, "check.nfsv4.state.id.nopass.need.install.patch", needHotPatchVersion))
            else:
                return (False, ALL_CLI_RET, common.getMsg(LANG, "check.nfsv4.state.id.nopass"))

        if softwareVersion < "V300R006C00":
            return (True, ALL_CLI_RET, "")

        flag, vstoreIdList, errMsg = getVstoreIds(cli)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))
        for vstoreId in vstoreIdList:
            enterVstoreModeCliRet = ""
            (checkFlag, checkResult, errMsg), afterCheckCliRet = checkNFSV4ServiceIsOnInVstoreMode(cli, LOGGER, LANG,
                                                                                                   enterVstoreModeCliRet,
                                                                                                   vstoreId)
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, afterCheckCliRet)
            if checkFlag != True:
                return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg)
            if checkResult == True:
                if needHotPatchVersion:
                    return (False, ALL_CLI_RET,
                            common.getMsg(LANG, "check.nfsv4.state.id.nopass.need.install.patch", needHotPatchVersion))
                else:
                    return (False, ALL_CLI_RET, common.getMsg(LANG, "check.nfsv4.state.id.nopass"))
        return (True, ALL_CLI_RET, "")
    except UnCheckException, unCheckException:
        LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, unCheckException.errorMsg)
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def is_fs_exist(cli):
    """
    是否存在文件系统
    :param cli: ssh链接
    :return: True: 存在文件系统，False：不存在
    """
    global ALL_CLI_RET
    cmd = "show file_system general"
    flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
    if flag is not True:
        if not cliUtil.hasCliExecPrivilege(ret):
            return False
        raise UnCheckException(msg, ret)

    if cliUtil.queryResultWithNoRecord(ret):
        return False

    return len(cliUtil.getHorizontalNostandardCliRet(ret)) > 0


def getCacheCapacity(cli):
    '''
    获取控制器内存大小
    :param cli:
    :return:
    '''
    global ALL_CLI_RET
    cacheCapacity = ""
    cmd = "show controller general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return (False, cacheCapacity, errMsg)
    controllerInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    if len(controllerInfoDictList) == 0:
        return (False, cacheCapacity, common.getMsg(LANG, "get.cache.capacity.failed"))
    controllerInfoDict = controllerInfoDictList[0]
    cacheCapacity = controllerInfoDict.get("Cache Capacity")
    return (True, cacheCapacity, "")

def checkNFSV4ServiceIsOn(cli):
    '''
    检查NFSV4是否开启
    :param cli:
    :return:
    '''
    checkResult = False
    global ALL_CLI_RET
    cmd = "show service nfs"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return (flag, checkResult, errMsg)
    nfsInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
    for nfsInfoDict in nfsInfoDictList:
        if not nfsInfoDict.get("Support V4 Enabled"):
            return (False, checkResult, common.getMsg(LANG, "query.result.abnormal"))

        if nfsInfoDict.get("Support V4 Enabled") == "On":
            checkResult = True
    return (True, checkResult, "")


def getVstoreIds(cli):
    '''
    获取租户ID列表
    :return:
    '''
    global ALL_CLI_RET
    vstoreIdList = []
    cmd = "show vstore |filterColumn include columnList=ID"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return (flag, vstoreIdList, errMsg)
    vstoreIdInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
    for vstoreIdInfoDict in vstoreIdInfoDictList:
        vstoreId = vstoreIdInfoDict.get("ID", "")
        if vstoreId != "":
            vstoreIdList.append(vstoreId)
    return (True, vstoreIdList, "")


@common.checkInVstoreModeWrap
def checkNFSV4ServiceIsOnInVstoreMode(cli, LOGGER, LANG, enterVstoreModeCliRet, vstoreId, *args,
                                      **kargs):
    '''
    检查NFSV4是否开启
    :param cli:
    :return:
    '''
    checkResult = False
    global ALL_CLI_RET
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, enterVstoreModeCliRet)
    cmd = "show service nfs"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return (flag, checkResult, errMsg)
    nfsInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
    for nfsInfoDict in nfsInfoDictList:
        if nfsInfoDict.get("Support V4 Enabled") == "On":
            checkResult = True
    return (True, checkResult, "")
