# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        OS分区偏移错误检查
                1、如果产品型号为S2600T或者S5500T且软件版本为V200R002C30SPC200且补丁未安装或补丁版本小于V200R002C30SPH202检查结果为不通过，否则检查结果为通过。
                2、如果产品型号不为S2600T和S5500T则检查结果为不涉及。
                3、命令执行失败，检查结果为不通过。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    checkProductModel = ["S2600T","S5500T"]
    try:
        #查询产品型号
        result, productModel, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
        if not result or len(productModel) == 0:
            LOGGER.logSysAbnormal()
            return (flag, cliRet, errMsg)

        #如果产品型号不为S2600T或者S5500T则检查结果为不涉及
        if productModel not in checkProductModel:
            flag = cliUtil.RESULT_NOSUPPORT
            return (flag, cliRet, "")

        #获取版本号和补丁版本号，并判断是否为风险版本
        resultList, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        cliRet += resultList[1]
        if resultList[0] != True:
            return (cliUtil.RESULT_NOCHECK, cliRet, resultList[2])
    
        result, currentVersion, errInfo = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            errMsg += errInfo
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：getCurrentVersion返回False是未检查

        result, hotPatchVersion, errInfo = common.getHotPatchVersion(hotPatchVersionDictList, LANG)
        if not result:
            errMsg += errInfo
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：getHotPatchVersion返回False是未检查

        
        #1、如果产品型号为S2600T或者S5500T且软件版本为V200R002C30SPC200且补丁未安装或补丁版本小于V200R002C30SPH202检查结果为不通过，否则检查结果为通过。
        if "V200R002C30SPC200" == currentVersion and (hotPatchVersion == "--" or hotPatchVersion < "V200R002C30SPH202"):
            flag = False
            errMsg = common.getMsg(LANG, "os_partition_offset_error") 
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
