# -*- coding: UTF-8 -*-

import traceback

import common
import cliUtil
from common_utils import (
    check_in_vstore_mode_wrap,
    get_err_msg,
)
from common import UnCheckException

from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache

PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)


def execute(cli):
    """
    租户Pair检查
    :param cli:
    :return:
    """
    item_check = ItemCheck(cli)
    flag, msg = item_check.execute_check()
    return flag, "\n".join(item_check.all_cli_ret), msg


class ItemCheck:
    """
    租户Pair检查
    """

    def __init__(self, cli):
        self.cli = cli
        self.all_cli_ret = list()
        self.err_msg_list = list()
        self.pair_id_list = list()
        self.v_store_id_list = list()
        self.pair_v_store_dict = dict()
        self.error_id_list = list()

    def execute_check(self):
        try:
            error_status_pair_list = self.query_rep_v_store_pair_id()
            if error_status_pair_list:
                return False, get_err_msg(
                    LANG, "vstore.pair.health.status.abnormal",
                    ",".join(error_status_pair_list)
                )

            if not self.pair_id_list:
                return True, ""

            self.query_rep_v_store_id()

            if not self.v_store_id_list:
                return True, ""

            param_dict = {}
            param_dict["cli"] = self.cli
            param_dict["logger"] = LOGGER
            param_dict["lang"] = LANG
            param_dict["cli_ret_all"] = self.all_cli_ret
            for vstore_id in self.v_store_id_list:
                param_dict["vstore_id"] = vstore_id
                self.enter_vstore_check_content_number(param_dict)

            if self.error_id_list:
                self.err_msg_list.append(
                    get_err_msg(
                        LANG, "rep.vstore.pair.not.equal",
                        ", ".join(self.error_id_list)
                    )
                )

            return len(self.err_msg_list) == 0, "".join(self.err_msg_list)

        except UnCheckException as e:
            LOGGER.logError(str(e))
            return cliUtil.RESULT_NOCHECK, e.errorMsg
        except Exception:
            LOGGER.logError(traceback.format_exc())
            err_msg = "query.result.abnormal"
            return cliUtil.RESULT_NOCHECK, common.getMsg(LANG, err_msg)

    def query_rep_v_store_pair_id(self):
        """
        1 双活仲裁服务器链路状态为Link Up；
        :return:
        """
        error_status_pair_list = []
        cmd = "show vstore_pair general"
        flag, ret, msg = execute_cmd_in_cli_mode_with_cache(
            PY_JAVA_ENV, self.cli, cmd, LOGGER
        )
        self.all_cli_ret.append(ret)

        if not cliUtil.hasCliExecPrivilege(ret):
            return error_status_pair_list

        if flag is not True:
            raise UnCheckException(msg, ret)

        res_list = cliUtil.getHorizontalCliRet(ret)

        if res_list:
            if "Rep Type" in res_list[0]:
                error_status_pair_list = self.check_pair_info(res_list)
                return error_status_pair_list

        for res_info in res_list:
            pair_id = res_info.get("ID")
            self.pair_id_list.append(pair_id)
            if res_info.get("Health Status") != "Normal":
                error_status_pair_list.append(pair_id)
        return error_status_pair_list

    def check_pair_info(self, res_list):
        error_status_pair_list = []
        for pair_info in res_list:
            error_status_pair = self.check_pair_health(pair_info)
            if len(error_status_pair) != 0:
                error_status_pair_list.append(error_status_pair)
        return error_status_pair_list

    def check_pair_health(self, pair_info):
        error_status_pair = ""
        if pair_info.get("Rep Type") != "hyper_metro":
            return error_status_pair
        pair_id = pair_info.get("ID")
        self.pair_id_list.append(pair_id)
        if pair_info.get("Health Status") != "Normal":
            error_status_pair = pair_id
        return error_status_pair

    def query_rep_v_store_id(self):
        """
        1 双活仲裁服务器链路状态为Link Up；
        :return:
        """
        for pair_id in self.pair_id_list:
            cmd = (
                "show vstore_pair general pair_id={}|filterColumn "
                "include columnList=Local\sVstore\sID".format(pair_id)
            )
            flag, ret, msg = execute_cmd_in_cli_mode_with_cache(
                PY_JAVA_ENV, self.cli, cmd, LOGGER
            )
            self.all_cli_ret.append(ret)
            if flag is not True:
                raise UnCheckException(msg, ret)

            res_list = cliUtil.getVerticalCliRet(ret)
            for res_info in res_list:
                store_id = res_info.get("Local Vstore ID")
                self.pair_v_store_dict[pair_id] = store_id
                self.v_store_id_list.append(store_id)

    @check_in_vstore_mode_wrap
    def enter_vstore_check_content_number(self, param_dict, *args, **kargs):
        """
        进入租户视图，获取租户下文件系统数量，获取租户下双活pair数量，比较两者数量
        :param param_dict:
        :param args:
        :param kargs:
        :return:
        """
        vstore_id = param_dict.get("vstore_id")

        cmd = "show file_system general |filterRow column=Description predict=not " \
              "predict2=equal_to value=Created\sfrom\sKubernetes\sCSI |filterRow column=Clone predict=equal_to " \
              "value=No logicOp=and column=Audit\sLog\sFS predict=equal_to value=No"
        flag, ret, msg = cliUtil.excuteCmdInCliMode(self.cli, cmd, True, LANG)
        self.all_cli_ret.append(ret)
        if flag is not True:
            raise UnCheckException(msg, ret)
        vstore_fs_number = len(cliUtil.getHorizontalNostandardCliRet(ret))

        cmd = "show hyper_metro_pair general |filterRow column=Type predict=equal_to value=FS"
        flag, ret, msg = cliUtil.excuteCmdInCliMode(self.cli, cmd, True, LANG)
        self.all_cli_ret.append(ret)
        if flag is not True:
            raise UnCheckException(msg, ret)
        vstore_fs_pair_number = len(cliUtil.getHorizontalNostandardCliRet(ret))

        if vstore_fs_number != vstore_fs_pair_number:
            self.error_id_list.append(vstore_id)
