# -*- coding: UTF-8 -*-

import cliUtil
import common
import config_1

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
MIN_CTRL_NUM = 4

CTRL_BOM_LIST = [
    "02352KRU",
    "02352KRQ",
    "02352KUE",
    "02352KRW",
    "02351XQC",
    "02351XQD",
    "02352KRR",
    "02352KRP",
    "02351NYG",
    "02351PDT",
    "02351LVD",
    "02351LWG",
    "02351XBG",
]


def execute(cli):
    """ check space task(TRT9, Parana, Brazil)
    :param cli:
    :return:
    """
    all_cli_ret = ""
    try:

        # 只做显示使用
        cmd = "show system general"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True,
                                                            LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        flag, product_mode, msg = cliUtil.getProductModel(cli, LANG)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, all_cli_ret, msg

        if product_mode not in config_1.SPACE_TASK_RISK_PRODUCT_MODE:
            return cliUtil.RESULT_NOSUPPORT, all_cli_ret, ""

        # 检查版本
        cli_ret, sys_ver, patch_ver = \
            common.getHotPatchVersionAndCurrentVersion(cli, LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if not (sys_ver and patch_ver):
            err_msg = common.getMsg(LANG, "cannot.get.product.version.info")
            return cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg

        flag, sug_patch = check_version(sys_ver, patch_ver,
                                        config_1.SPACE_TASK_RISK_VERSION)
        if flag:
            return cliUtil.RESULT_NOSUPPORT, all_cli_ret, ""

        # 检查控制器
        cmd = "show controller general"
        flag, cli_ret, err_msg = \
            cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        all_cli_ret = common.joinLines(all_cli_ret, cli_ret)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg

        ctrl_list = cliUtil.getVerticalCliRetFilterElabel(cli_ret)
        exp_ctrl_num = get_exp_num()
        ctrl_num = len(ctrl_list) + exp_ctrl_num
        LOGGER.logInfo("controller number:%s" % ctrl_num)
        if ctrl_num < MIN_CTRL_NUM:
            return True, all_cli_ret, ""

        # 检查BOM
        if not check_bom(ctrl_list):
            if sug_patch:
                msg = common.getMsg(LANG,
                                    "check.expand.hot.patch.not.pass",
                                    (sug_patch, patch_ver))
            else:
                msg = common.getMsg(LANG, "space.task.version.not.match",
                                    sys_ver)
            return False, all_cli_ret, msg
        return True, all_cli_ret, ""

    except Exception as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, all_cli_ret,\
            common.getMsg(LANG, "query.result.abnormal")


def get_exp_num():
    if py_java_env.get("expInfo"):
        return int(py_java_env.get("expInfo").getExpCtrlsNum())
    return 0


def check_version(sys_ver, patch_ver, version_dict):
    """
    :param lang:
    :param sys_ver:
    :param patch_ver:
    :param version_dict: 版本要求字典，格式如下：
        {"VxxRxxCxx": {"start_version": "xx",
                        "white_version_list": ["xx_1",
                                              "xx_2",
                                              "xx_3",]},
        }
    :return: 检查结果，推荐补丁版本，无推荐版本返回空
    """

    if sys_ver not in version_dict:
        return True, ""

    patch_info = version_dict.get(sys_ver)
    white_patch = patch_info.get("white_version_list", [])
    if white_patch and patch_ver in white_patch:
        return True, ""

    start_version = patch_info.get("start_version", "")
    if not start_version:
        return False, ""

    if patch_ver == "--" or patch_ver < start_version:
        return False, start_version
    return True, ""


def check_bom(ctrl_list):
    for ctrl in ctrl_list:
        bom = ctrl.get("Item")
        if bom.upper() in CTRL_BOM_LIST:
            return False
    return True
