# -*- coding: UTF-8 -*-
import common
import java.lang.System as javaSystem
import os
from config import MODEL_VER_PATCH_LIST
from defusedxml import ElementTree as ET
import cliUtil
def execute(cli):
    '''
            系统版本补丁推荐检查
    1、如果产品型号或者系统软件版本不在检查范围内，或者系统已安装推荐产品版本+热补丁，则检查通过。
    2、如果系统当前版本低于推荐版本则检查结果为建议优化。

    '''
    try:
        cliRet = ""
        flag = True
        LANG = common.getLang(py_java_env)
        LOGGER = common.getLogger(PY_LOGGER, __file__)
        #获取设备型号
        isQryOk, deviceType, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
        if not isQryOk:
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        
        #获取设备当前产品版本和补丁信息
        checkRet, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
        cliRet += checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (cliUtil.RESULT_NOCHECK, cliRet ,checkRet[2])
        
        result, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, cliRet ,errMsg)
        
        result, curHotPatchVer, errMsg = common.getCurrentVersion(hotPatchVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, cliRet ,errMsg)
        
        #判断当前设备是否为风险版本
        flag, errMsg= checkRiskVersion(deviceType,currentVersion,curHotPatchVer,LANG,LOGGER)
        if flag != True:
            return (flag, cliRet ,errMsg)
            
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))

def checkRiskVersion(deviceType,sysSpcVer,curHotPatchVer,LANG,LOGGER):
    '''
    @summary: 检查当前设备是否为风险版本
    @param deviceType: 设备型号
    @param sysVerRet: 产品版本
    @param curHotPatchVer: 当前热补丁版本
    @param needHotPatchVer: 目标热补丁版本
    @param logger: 日志对象
    @param lang: 语言
    @return:
        flag:
            True: 非风险版本
            False: 风险版本
    '''
    flag = True
    errMsg = ""
    needSystemVersion = ""
    needPatchVersion = ""
    hotPatchVersionDictList = []
    hotPatchNotExists = ["","--"]
    DictList = []
    
    if javaSystem.getenv("patchSavePath") != None and \
            os.path.exists(javaSystem.getenv("patchSavePath") + os.sep + "productHotPatch.xml"):
        LOGGER.logInfo("exist productHotPatch.xml")
        
        hotPatchVersionFilePath = javaSystem.getenv("patchSavePath") + os.sep + "productHotPatch.xml"
        hotPatchVersionDictList = parseXMLFile(hotPatchVersionFilePath,LOGGER)
        LOGGER.logInfo("hotPatchVersionDictList = %s" % hotPatchVersionDictList)
        
    if hotPatchVersionDictList:
        DictList = hotPatchVersionDictList
    else:
        DictList = MODEL_VER_PATCH_LIST
    LOGGER.logInfo("DictList = %s" % DictList) 
       
    for infoDict in DictList:
        deviceTypeList = infoDict.get("model","")
        needSystemVersion = infoDict.get("productVersion","")
        needPatchVersion = infoDict.get("patchVersion","")
        
        if deviceType in deviceTypeList and sysSpcVer <= needSystemVersion and \
        (curHotPatchVer < needPatchVersion or curHotPatchVer in hotPatchNotExists):
            flag = cliUtil.RESULT_WARNING
            #在版本适应，热补丁小于推荐型号           			
            if sysSpcVer == needSystemVersion:
                if needPatchVersion == "--":
                    flag = True
                else:
                    errMsg = common.getMsg(LANG, "unInstall.patch", (deviceType, sysSpcVer, needPatchVersion))
            else:
                #版本型号小于推荐型号，且存在推荐热补丁                
                if needPatchVersion and needPatchVersion != "--":
                    errMsg = common.getMsg(LANG, "system.version.low", (deviceType, sysSpcVer, needSystemVersion, needPatchVersion))
                #版本型号小于推荐型号，无推荐热补丁                
                else:
                    errMsg = common.getMsg(LANG, "only.system.version.low", (deviceType, sysSpcVer, needSystemVersion))
            break
        
    return (flag, errMsg)

def parseXMLFile(filePath,LOGGER):
    '''
    @summary: 解析xml的指定节点信息
    @param element: xml的一个节点
    @return: 解析后的xml节点信息（一个嵌套的字典列表)
    '''
    try:              
        hotPatchVersionDictList =[]
        xmlElementTree = ET.parse(filePath)
        rootElement = xmlElementTree.getroot()
        element = rootElement.getiterator(tag="systemVersion")
        
        for child in element:
            #解析设备型号
            productModelList = child.getiterator(tag="productModel")[0].text.strip().split(",")
            #解析产品版本
            productVersion = child.getiterator(tag="productVersion")[0].text.strip()
            #解析补丁版本
            patchVersion = child.getiterator(tag="patchVersion")[0].text.strip()
            productPatchVersionDict = {"model":productModelList,"productVersion":productVersion,"patchVersion":patchVersion}
            
            hotPatchVersionDictList.append(productPatchVersionDict)       
                
        return hotPatchVersionDictList
    except Exception, exception:
        LOGGER.logException(exception)
        return []