﻿#coding: UTF-8

import traceback
import os
import codecs
import shutil
import cliUtil
import time
list_cli_cmd = ["show system general|filterColumn exclude columnList=Product\sModel",
                "show system general",
                "show upgrade package"]

list_cli_cmd_eService = [
                "show share nfs",
                "show share cifs share_id=[show share cifs?Share ID]",
                "show share_permission ftp",
                "show share_permission nfs share_id=(show share nfs?Share ID)",
                "show share_permission cifs share_id=(show share cifs?Share ID)",
                "show snapshot general |filterColumn include columnList=ID,Name,Source\sLUN\sID,Health\sStatus,Running\sStatus,Time\sStamp,Parent\sID,Capacity,Subscribed\sCapacity,Usage\sType,Cascaded\sLevel",
                "show fs_snapshot general file_system_id=[show file_system general?ID]",
                ]

list_cli_cmd_omm = [
                "show user",
                "show safe_strategy",
                "show devicemanager tls_versions",
                "show ntp status",
                "show certificate general",
                "show notification email",
                "show snmp version",
                "show system server_port server_name=SSH"
]

def collectCliCmd(devObj, fileBaseDir):
    """
    # 函数名称: collectCliCmd
    # 功能说明: 获取CLI命令信息
    # 其 他   :  无
    """

    logger = devObj.get("logger")
    try:
        #收集Cli命令
        ssh = devObj.get("ssh")
        cliCmdFile = os.path.join(fileBaseDir, "clicmd.txt")
        cli_ret_list = []
        for cmd in list_cli_cmd:
            cli_ret_list.append(ssh.execCmdNoLogTimout(cmd, 10*60))
        
        #将收集到的命令回文写入文件
        localFile = codecs.open(cliCmdFile, "a", "utf-8")
        try:
            localFile.write("\n".join(cli_ret_list))
        except:
            logger.error("Failed to write file:" + str(traceback.format_exc()))
            return False
        finally:
            localFile.close()
        return True
    except:
        logger.error("Failed to collect commands:" + str(traceback.format_exc()))
        return False


def logCollectAdditionalInfoFailed(logger, file_name):
    logger.error("Collect " + file_name + " failed.")
    
def logCollectAdditionalInfoPartFailed(logger, file_name):
    logger.error("Collect " + file_name + " part failed.")
    
def logCollectAdditionalInfoSuccess(logger, file_name):
    logger.info("Collect " + file_name + " success.")
    
def joinLines(originLines, postLines):
    """
    @summary: 将postLines追加originLines后
    """
    if not (originLines or postLines):
        return ""
    
    if not originLines:
        return postLines
    
    if not postLines:
        return originLines
    
    return "\n".join([originLines, postLines])

def collectCliCmd4eService(dev_obj, file_basedir):
    """
    # 收集完config限制CLI命令收集时间，已和LMT/eservice对齐，
    # 时间2019.12.27
    # 函数名称: 为eService收集cli回显/ 为OMM安全配置搜集cli回显。
    # 功能说明: 获取CLI命令信息
    # 其 他   :  无
    """
    aflag = collectAdditionalInfo(dev_obj, file_basedir, "Additional-Info.txt", list_cli_cmd_eService)
    sflag = collectAdditionalInfo(dev_obj, file_basedir, "SafeConfig-Info.txt", list_cli_cmd_omm)
    return aflag or sflag


def collectAdditionalInfo(dev_obj, file_basedir, file_name, list_cmds):
    time_out = False
    collect_limit_time = 600
    current_time = time.time()
    logger = dev_obj.get("logger")
    try:
        cli_ret_list = []
        ssh = dev_obj.get("ssh")
        cli_cmd_file = os.path.join(file_basedir, file_name)
        for cmd in list_cmds:
            # 如果当前时间大于等于限制时间则返回。
            if time.time() - current_time >= collect_limit_time:
                time_out = True
                break

            one_cli_ret_list = getCliRet(ssh, cmd, current_time, collect_limit_time)
            if not one_cli_ret_list:
                logCollectAdditionalInfoPartFailed(logger, file_name)
                logger.error("Command execution result is empty:%s" % cmd)
                continue
            # 过滤不支持的命令
            appendCliResult(one_cli_ret_list, cli_ret_list, logger, cli_cmd_file)

        if not cli_ret_list:
            logCollectAdditionalInfoFailed(logger, file_name)
            return time_out
        
        if writeFile(cli_cmd_file, "\n".join(cli_ret_list), logger):
            logCollectAdditionalInfoSuccess(logger, file_name)
        else:
            logCollectAdditionalInfoFailed(logger, file_name)
        return time_out
    except:
        logCollectAdditionalInfoFailed(logger, file_name)
        logger.error(str(traceback.format_exc()))
        return time_out


def appendCliResult(one_cli_ret_list, cli_ret_list, logger, cli_cmd_file):
    for ret in one_cli_ret_list:
        if cli_res_is_support(ret):
            cli_ret_list.append(ret)
        else:
            logger.info('Remove not support cli ret:\n{}\nFILE PATH:{}'.format(ret, cli_cmd_file))

    
def writeFile(cliInfoFileName, cliRet, logger):
    """
    # 函数名称: 将cli回显写入文件。
    # 功能说明: 获取CLI命令信息
    # 其 他   :  无
    """
    cliInfoFile = None
    try:
        cliInfoFile = codecs.open(cliInfoFileName, "a", "utf-8")
        cliInfoFile.write(cliRet)
        cliInfoFile.flush()
        return True
    except:
        logger.error("Failed to write file:" + str(traceback.format_exc()))
        return False
    finally:
        if cliInfoFile!= None:
            cliInfoFile.close()
        return True


def getCliRet(ssh, cmd, current_time, collect_limit_time):
    """
    # 函数名称: 获取cli回显。
    # 功能说明: 获取CLI命令信息
    # 其 他   :  无
    "show snapshot general snapshot_id=(show snapshot general?ID)",
    """
    cli_ret_list = []
    timeout = 60*5
    if "=[" in cmd:
        index0 = cmd.find("[")
        index1 = cmd.find("?")
        dependCmd = cmd[index0+1:index1]
        dependCmdCliRet = ssh.execCmdNoLogTimout(dependCmd, timeout)
        cli_ret_list.append(dependCmdCliRet)
        baseCmd = cmd[:index0]
        index2 = cmd.find("]")
        param = cmd[index1+1:index2]
        dependInfoDictList = cliUtil.getHorizontalNostandardCliRet(dependCmdCliRet)
        for dependInfoDic in dependInfoDictList:
            if time.time() - current_time >= collect_limit_time:
                return cli_ret_list
            paramValue = dependInfoDic.get(param, "")
            detailsCmd = baseCmd + paramValue
            detailsCmdCliRet = ssh.execCmdNoLogTimout(detailsCmd, timeout)
            cli_ret_list.append(detailsCmdCliRet)

    elif "=(" in cmd:
        index0 = cmd.find("(")
        index1 = cmd.find("?")
        dependCmd = cmd[index0 + 1:index1]
        dependCmdCliRet = ssh.execCmdNoLogTimout(dependCmd, timeout)
        cli_ret_list.append(dependCmdCliRet)
        baseCmd = cmd[:index0]
        index2 = cmd.find(")")
        param = cmd[index1+1:index2]
        dependInfoDictList = cliUtil.getHorizontalNostandardCliRet(dependCmdCliRet)
        for dependInfoDic in dependInfoDictList:
            if time.time() - current_time >= collect_limit_time:
                return cli_ret_list
            paramValue = dependInfoDic.get(param, "")
            detailsCmd = baseCmd + paramValue
            detailsCmdCliRet = ssh.execCmdNoLogTimout(detailsCmd, timeout)
            cli_ret_list.append(detailsCmdCliRet)
    else:
        cliRet = ssh.execCmdNoLogTimout(cmd, timeout)
        cli_ret_list.append(cliRet)

    return cli_ret_list


def cli_res_is_support(cli_res):
    """
    判断是否支持的命令回文
    :param cli_res: 回文返回
    :return: True:支持的命令
            False:不支持的命令
    """
    # 检查第2行是否有不支持的标志符
    check_line_num = 2
    line_sep_n = "\n"
    not_support_sign = "^"
    split_list = cli_res.split(line_sep_n, check_line_num)
    if len(split_list) > check_line_num:
        return not (split_list[check_line_num - 1].strip() ==
                    not_support_sign)

    return True
