#!/usr/bin/python
# -*- coding: UTF-8 -*-

from memory_inspect.address_decodes import connect
from memory_inspect.address_decodes import memoryConfig
from memory_inspect.address_decodes import forwardTadOperation
from memory_inspect.address_decodes import forwardRirOperation
from memory_inspect.utils.six_about import to_hex_str, to_int

INTERLEAVE_MODE_VAL_TUPLE = (6, 8, 12, 30)

# 配置信息 1.  Write Route Table CSRs for Socket 0 and Socket 1
Ringid = {0: 0, 1: 1, 2: 0, 3: 1, 4: 0, 5: 1}
Chnlid = {0: 0, 1: 0, 2: 1, 3: 1, 4: 2, 5: 2}

NOT_A_DRAM_RESULT = "Result error:  Enter the Syatem Address Not a Dram"


# V5设备  page_mode = "Open"
# 输入的系统地址 addr 类型为整形变量


def SAD_Base_2_16G_1P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        # 已知
        Socket_Id = 0
        address_mod = ''
        # 待求取
        base = ''
        # 待求取
        logChId = 0
        # 待求取
        MC_Id = 0
        # 待求取
        Channel_Id = 0
        # 待求取
        interleaveListIndex = 0

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 8, 8, 8, 8, 8, 8, 8]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_1P where SAD_NO = '2_16G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x0087fffffff:
                result = "The System Address Out of Range"
                return result

        # 根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        db_data = connect.select(
            "select _MOD3, _MOD3_MODE, _MOD3_AsMod2, _INTERLEAVE_MODE from PURPLE_SAD_1P where SAD_NO "
            "like '%%2_16G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        mod3, mod3_mode, mod3_as_mod2, interleave_mode = (int(''.join(i)) for i in db_data)

        # 根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        Target_Id = InterleaveList_0[interleaveListIndex]
        # -----------------------------------------------------------------------------------------------------------------------

        if mod3 == 1:
            if mod3_as_mod2 == 0:  # 2
                ch_mod = 3  # 3 chway mode
            else:
                ch_mod = 2  # 2 chway mode

            if mod3_mode == 0:
                address_mod = (addr >> 6) % ch_mod
            if mod3_mode == 1:
                address_mod = (addr >> 8) % ch_mod
            if mod3_mode == 2:
                address_mod = (addr >> 12) % ch_mod

            if mod3_as_mod2 == 0:  # 3 chway
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x6)
            if mod3_as_mod2 == 1:  # 2 chway, ch 0,1
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x2)
            if mod3_as_mod2 == 2:  # 2 chway, ch 1,2
                logChId = (Target_Id & 0x1) | (((address_mod ^ 0x1) << 1) & 0x2) | ((address_mod << 2) & 0x4)
            if mod3_as_mod2 == 3:  # 2 chway, ch 0, 2
                logChId = (Target_Id & 0x1) | ((address_mod << 2) & 0x4)
        else:
            logChId = Target_Id & 0x7

        # -----------------------------------------------------------------------------------------------------------------------
        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        # 返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_2_16G_1P(addr, socket_id, mc_id, page_mode,
                                                           numa_mode)  # 得到 channel address

        # 返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_2_16G_1P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad

        return result

    if numa_mode == 'Enable':
        result = "One CPU Has No Interleave"
        return result


def SAD_Base_2_32G_1P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        Socket_Id = 0  # 已知

        address_mod = ''
        base = ''  # 待求取
        logChId = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 8, 8, 8, 8, 8, 8, 8]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_1P where SAD_NO = '2_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00107fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        db_data = connect.select(
            "select _MOD3, _MOD3_MODE, _MOD3_AsMod2, _INTERLEAVE_MODE from PURPLE_SAD_1P where SAD_NO "
            "like '%%2_32G_SAD%%' and _BASE = '%s' " % to_hex_str(base)
        )
        mod3, mod3_mode, mod3_as_mod2, interleave_mode = (int(''.join(i)) for i in db_data)

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        Target_Id = InterleaveList_0[interleaveListIndex]
        # -----------------------------------------------------------------------------------------------------------------------

        if mod3 == 1:
            if mod3_as_mod2 == 0:  # 2
                ch_mod = 3  # 3 chway mode
            else:
                ch_mod = 2  # 2 chway mode

            if mod3_mode == 0:
                address_mod = (addr >> 6) % ch_mod
            if mod3_mode == 1:
                address_mod = (addr >> 8) % ch_mod
            if mod3_mode == 2:
                address_mod = (addr >> 12) % ch_mod

            if mod3_as_mod2 == 0:  # 3 chway
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x6)
            if mod3_as_mod2 == 1:  # 2 chway, ch 0,1
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x2)
            if mod3_as_mod2 == 2:  # 2 chway, ch 1,2
                logChId = (Target_Id & 0x1) | (((address_mod ^ 0x1) << 1) & 0x2) | ((address_mod << 2) & 0x4)
            if mod3_as_mod2 == 3:  # 2 chway, ch 0, 2
                logChId = (Target_Id & 0x1) | ((address_mod << 2) & 0x4)
        else:
            logChId = Target_Id & 0x7

        # -----------------------------------------------------------------------------------------------------------------------
        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_2_32G_1P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_2_32G_1P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':
        result = "One CPU Has No Interleave"
        return result


def SAD_Base_3_16G_1P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        Socket_Id = 0  # 已知

        address_mod = ''
        base = ''  # 待求取
        logChId = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取
        InterleaveList = []

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = (0xc, 0xd, 0xc, 0xd, 0xc, 0xd, 0xc, 0xd)
        InterleaveList_1 = (0xa, 0xa, 0xa, 0xa, 0xa, 0xa, 0xa, 0xa)

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 3):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_1P where SAD_NO = '3_16G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x000c7fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        temp_data = connect.select(
            "select _MOD3, _MOD3_MODE, _MOD3_AsMod2, _INTERLEAVE_MODE, _SAD from PURPLE_SAD_1P "
            "where SAD_NO like '%%3_16G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        mod3, mod3_mode, mod3_as_mod2, interleave_mode = (int(''.join(i)) for i in temp_data[:4])
        sad = ''.join(temp_data[4])

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        InterleaveList = InterleaveList_1 if (sad == 'SAD2') else InterleaveList_0
        Target_Id = InterleaveList[interleaveListIndex]
        # -----------------------------------------------------------------------------------------------------------------------

        if mod3 == 1:
            if mod3_as_mod2 == 0:  # 2
                ch_mod = 3  # 3 chway mode
            else:
                ch_mod = 2  # 2 chway mode

            if mod3_mode == 0:
                address_mod = (addr >> 6) % ch_mod
            if mod3_mode == 1:
                address_mod = (addr >> 8) % ch_mod
            if mod3_mode == 2:
                address_mod = (addr >> 12) % ch_mod

            if mod3_as_mod2 == 0:  # 3 chway
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x6)
            if mod3_as_mod2 == 1:  # 2 chway, ch 0,1
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x2)
            if mod3_as_mod2 == 2:  # 2 chway, ch 1,2
                logChId = (Target_Id & 0x1) | (((address_mod ^ 0x1) << 1) & 0x2) | ((address_mod << 2) & 0x4)
            if mod3_as_mod2 == 3:  # 2 chway, ch 0, 2
                logChId = (Target_Id & 0x1) | ((address_mod << 2) & 0x4)
        else:
            logChId = Target_Id & 0x7

        # -----------------------------------------------------------------------------------------------------------------------
        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_3_16G_1P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_3_16G_1P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':
        result = "One CPU Has No Interleave"
        return result


def SAD_Base_4_16G_1P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        Socket_Id = 0  # 待求取

        base = ''  # 待求取
        logChId = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = (0xa, 0xb, 0xc, 0xd, 0xa, 0xb, 0xc, 0xd)

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_1P where SAD_NO = '4_16G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00107fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        db_data = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_1P where SAD_NO "
            "like '%%4_16G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        interleave_mode, mod3 = (int(''.join(i)) for i in db_data)

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        Target_Id = InterleaveList_0[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_4_16G_1P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_4_16G_1P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':
        result = "One CPU Has No Interleave"
        return result


def SAD_Base_4_32G_1P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        Socket_Id = 0  # 待求取

        base = ''  # 待求取
        logChId = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [0xa, 0xb, 0xc, 0xd, 0xa, 0xb, 0xc, 0xd]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_1P where SAD_NO = '4_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00207fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        db_data = connect.select(
            "select _MOD3, _INTERLEAVE_MODE from PURPLE_SAD_1P where SAD_NO "
            "like '%%4_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        mod3, interleave_mode = (int(''.join(i)) for i in db_data)

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        Target_Id = InterleaveList_0[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_4_32G_1P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_4_32G_1P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':
        result = "One CPU Has No Interleave"
        return result


def SAD_Base_8_32G_1P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        Socket_Id = 0  # 待求取

        base = ''  # 待求取
        logChId = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [0xa, 0xb, 0xc, 0xd, 0xa, 0xb, 0xc, 0xd]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_1P where SAD_NO = '8_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00407fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        interleave_mode_temp, mod3_temp = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_1P where SAD_NO "
            "like '%%8_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        interleave_mode = int(''.join(interleave_mode_temp))
        mod3 = int(''.join(mod3_temp))

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        Target_Id = InterleaveList_0[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)
        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_8_32G_1P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_8_32G_1P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':
        result = "One CPU Has No Interleave"
        return result


def SAD_Base_4_32G_2P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        base = ''  # 待求取
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 1, 1, 8, 9, 1, 1]
        InterleaveList_1 = [0, 0, 8, 9, 0, 0, 8, 9]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = '4_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00207fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        interleave_mode_temp, mod3_temp = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_2P where "
            "SAD_NO like '%%4_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        mod3 = int(''.join(mod3_temp))
        interleave_mode = int(''.join(interleave_mode_temp))

        #   根据输入的 system address 和 SAD 区间 求出 Socket_Id  #############################
        addr_bits = bin(addr)[-10:-8]
        if addr_bits == '00' or addr_bits == '01':
            Socket_Id = 0
        if addr_bits == '10' or addr_bits == '11':
            Socket_Id = 1

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_4_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_4_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':

        base = ''  # 待求取
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 8, 9, 8, 9, 8, 9]
        InterleaveList_1 = [8, 9, 8, 9, 8, 9, 8, 9]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   确定 addr 属于哪一个SAD，并进一步求出属于哪个socket
        for num in range(0, 3):
            base_temp = connect.select(
                "select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = 'NUMA_4_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00207fffffff:
                result = "The System Address Out of Range"
                return result

        Socket_Id_temp = connect.select(
            " select _SOCKET from PURPLE_SAD_2P where SAD_NO like '%%NUMA_4_32G_SAD%%' and _BASE = '%s' " % to_hex_str(
                base))

        Socket_Id = (''.join(Socket_Id_temp))[-1]
        Socket_Id = int(Socket_Id)

        # 根据求出的 SAD和socket 范围 求取 interleave_mode 以及 mod 3 的值
        interleave_mode_temp, mod3_temp = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_2P where SAD_NO "
            "like '%%NUMA_4_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        interleave_mode = int(''.join(interleave_mode_temp))
        mod3 = int(''.join(mod3_temp))

        # 根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_4_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_4_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result


def SAD_Base_8_32G_2P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        base = ''  # 待求取
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 1, 1, 0xa, 0xb, 1, 1]
        InterleaveList_1 = [0, 0, 8, 9, 0, 0, 0xa, 0xb]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = '8_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00407fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        interleave_mode_temp, mod3_temp = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_2P where SAD_NO "
            "like '%%8_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        interleave_mode = int(''.join(interleave_mode_temp))
        mod3 = int(''.join(mod3_temp))

        #   根据输入的 system address 和 SAD 区间 求出 Socket_Id  #############################
        addr_bits = bin(addr)[-10:-8]
        if addr_bits == '00' or addr_bits == '01':
            Socket_Id = 0
        if addr_bits == '10' or addr_bits == '11':
            Socket_Id = 1

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_8_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_8_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':

        base = ''  # 待求取
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 0xa, 0xb, 8, 9, 0xa, 0xb]
        InterleaveList_1 = [8, 9, 0xa, 0xb, 8, 9, 0xa, 0xb]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   确定 addr 属于哪一个SAD，并进一步求出属于哪个socket
        for num in range(0, 3):
            base_temp = connect.select(
                "select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = 'NUMA_8_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00407fffffff:
                result = "The System Address Out of Range"
                return result

        Socket_Id_temp = connect.select(
            " select _SOCKET from PURPLE_SAD_2P where SAD_NO like '%%NUMA_8_32G_SAD%%' and _BASE = '%s' " % to_hex_str(
                base))

        Socket_Id = (''.join(Socket_Id_temp))[-1]
        Socket_Id = int(Socket_Id)

        #   根据求出的 SAD和socket 范围 求取 interleave_mode 以及 mod 3 的值
        interleave_mode_temp, mod3_temp = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_2P where SAD_NO "
            "like '%%NUMA_8_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        interleave_mode = int(''.join(interleave_mode_temp))
        mod3 = int(''.join(mod3_temp))

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_8_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_8_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result


def SAD_Base_16_32G_2P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        base = ''  # 待求取
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 1, 1, 0xa, 0xb, 1, 1]
        InterleaveList_1 = [0, 0, 8, 9, 0, 0, 0xa, 0xb]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = '16_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00807fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        db_data = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_2P where SAD_NO "
            "like '%%16_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        interleave_mode, mod3 = (int(''.join(i)) for i in db_data)

        #   根据输入的 system address 和 SAD 区间 求出 Socket_Id  #############################
        addr_bits = bin(addr)[-10:-8]
        if addr_bits == '00' or addr_bits == '01':
            Socket_Id = 0
        if addr_bits == '10' or addr_bits == '11':
            Socket_Id = 1

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_16_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_16_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':

        base = ''  # 待求取
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 0xa, 0xb, 8, 9, 0xa, 0xb]
        InterleaveList_1 = [8, 9, 0xa, 0xb, 8, 9, 0xa, 0xb]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   确定 addr 属于哪一个SAD，并进一步求出属于哪个socket
        for num in range(0, 3):
            base_temp = connect.select(
                "select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = 'NUMA_16_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00807fffffff:
                result = "The System Address Out of Range"
                return result

        Socket_Id_temp = connect.select(
            " select _SOCKET from PURPLE_SAD_2P where SAD_NO "
            "like '%%NUMA_16_32G_SAD%%' and _BASE = '%s' " % to_hex_str(
                base))

        Socket_Id = (''.join(Socket_Id_temp))[-1]
        Socket_Id = int(Socket_Id)

        #   根据求出的 SAD和socket 范围 求取 interleave_mode 以及 mod 3 的值
        interleave_mode_temp, mod3_temp = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_2P where SAD_NO "
            "like '%%NUMA_16_32G_SAD%%' and _BASE = '%s' " % to_hex_str(base)
        )
        interleave_mode = int(''.join(interleave_mode_temp))
        mod3 = int(''.join(mod3_temp))

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_16_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_16_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result


def SAD_Base_16_64G_2P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        base = ''  # 待求取
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 1, 1, 0xa, 0xb, 1, 1]
        InterleaveList_1 = [0, 0, 8, 9, 0, 0, 0xa, 0xb]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = '16_64G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x01007fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        interleave_mode_temp, mod3_temp = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_2P where SAD_NO "
            "like '%%16_64G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        interleave_mode = int(''.join(interleave_mode_temp))
        mod3 = int(''.join(mod3_temp))

        #   根据输入的 system address 和 SAD 区间 求出 Socket_Id  #############################
        addr_bits = bin(addr)[-10:-8]
        if addr_bits == '00' or addr_bits == '01':
            Socket_Id = 0
        if addr_bits == '10' or addr_bits == '11':
            Socket_Id = 1

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_16_64G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_16_64G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':

        base = ''  # 待求取
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 0xa, 0xb, 8, 9, 0xa, 0xb]
        InterleaveList_1 = [8, 9, 0xa, 0xb, 8, 9, 0xa, 0xb]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   确定 addr 属于哪一个SAD，并进一步求出属于哪个socket
        for num in range(0, 3):
            base_temp = connect.select(
                "select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = 'NUMA_16_64G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x01007fffffff:
                result = "The System Address Out of Range"
                return result

        Socket_Id_temp = connect.select(
            " select _SOCKET from PURPLE_SAD_2P where SAD_NO "
            "like '%%NUMA_16_64G_SAD%%' and _BASE = '%s' " % to_hex_str(
                base))

        Socket_Id = (''.join(Socket_Id_temp))[-1]
        Socket_Id = int(Socket_Id)

        #   根据求出的 SAD和socket 范围 求取 interleave_mode 以及 mod 3 的值
        interleave_mode_temp, mod3_temp = connect.select(
            "select _INTERLEAVE_MODE, _MOD3 from PURPLE_SAD_2P where SAD_NO "
            "like '%%NUMA_16_64G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        interleave_mode = int(''.join(interleave_mode_temp))
        mod3 = int(''.join(mod3_temp))

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        #   根据上面求出的 Target_Id 的值，求出 logic_channel_id
        if mod3 == 0:
            logChId = Target_Id & 0x7
        if mod3 == 1:
            pass

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_16_64G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_16_64G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result


def SAD_Base_24_32G_2P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        base = ''  # 待求取
        address_mod = ''
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 1, 1, 8, 9, 1, 1]
        InterleaveList_1 = [0, 0, 8, 9, 0, 0, 8, 9]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = '24_32G_SAD%s'" % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00c06fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        db_data = connect.select(
            "select _MOD3, _MOD3_MODE, _MOD3_AsMod2, _INTERLEAVE_MODE from PURPLE_SAD_2P where SAD_NO "
            "like '%%24_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        mod3, mod3_mode, mod3_as_mod2, interleave_mode = (int(''.join(i)) for i in db_data)

        #   根据输入的 system address 和 SAD 区间 求出 Socket_Id  #############################
        addr_bits = bin(addr)[-10:-8]
        if addr_bits == '00' or addr_bits == '01':
            Socket_Id = 0
        if addr_bits == '10' or addr_bits == '11':
            Socket_Id = 1

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]
        ##############################################################################################################
        if mod3 == 1:
            if mod3_as_mod2 == 0:  # 2
                ch_mod = 3  # 3 chway mode
            else:
                ch_mod = 2  # 2 chway mode

            if mod3_mode == 0:
                address_mod = (addr >> 6) % ch_mod
            if mod3_mode == 1:
                address_mod = (addr >> 8) % ch_mod
            if mod3_mode == 2:
                address_mod = (addr >> 12) % ch_mod

            if mod3_as_mod2 == 0:  # 3 chway
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x6)
            if mod3_as_mod2 == 1:  # 2 chway, ch 0,1
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x2)
            if mod3_as_mod2 == 2:  # 2 chway, ch 1,2
                logChId = (Target_Id & 0x1) | (((address_mod ^ 0x1) << 1) & 0x2) | ((address_mod << 2) & 0x4)
            if mod3_as_mod2 == 3:  # 2 chway, ch 0, 2
                logChId = (Target_Id & 0x1) | ((address_mod << 2) & 0x4)
        else:
            logChId = Target_Id & 0x7
        ###############################################################################################################
        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_24_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_24_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':

        base = ''  # 待求取
        address_mod = ''
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = (8, 9, 8, 9, 8, 9, 8, 9)
        InterleaveList_1 = (8, 9, 8, 9, 8, 9, 8, 9)

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   确定 addr 属于哪一个SAD，并进一步求出属于哪个socket
        for num in range(0, 3):
            base_temp = connect.select(
                "select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = 'NUMA_24_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00c03fffffff:
                result = "The System Address Out of Range"
                return result

        Socket_Id_temp = connect.select(
            "select _SOCKET from PURPLE_SAD_2P where SAD_NO like '%%NUMA_24_32G_SAD%%' and _BASE = '%s'" % to_hex_str(
                base))

        Socket_Id = (''.join(Socket_Id_temp))[-1]
        Socket_Id = int(Socket_Id)

        #   根据求出的 SAD和socket 范围 求取 interleave_mode 以及 mod 3 的值
        db_data = connect.select(
            "select _MOD3, _MOD3_MODE, _MOD3_AsMod2, _INTERLEAVE_MODE from PURPLE_SAD_2P where SAD_NO "
            "like '%%NUMA_24_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        mod3, mod3_mode, mod3_as_mod2, interleave_mode = (int(''.join(i)) for i in db_data)

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        ##############################################################################################################
        if mod3 == 1:
            if mod3_as_mod2 == 0:  # 2
                ch_mod = 3  # 3 chway mode
            else:
                ch_mod = 2  # 2 chway mode

            if mod3_mode == 0:
                address_mod = (addr >> 6) % ch_mod
            if mod3_mode == 1:
                address_mod = (addr >> 8) % ch_mod
            if mod3_mode == 2:
                address_mod = (addr >> 12) % ch_mod

            if mod3_as_mod2 == 0:  # 3 chway
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x6)
            if mod3_as_mod2 == 1:  # 2 chway, ch 0,1
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x2)
            if mod3_as_mod2 == 2:  # 2 chway, ch 1,2
                logChId = (Target_Id & 0x1) | (((address_mod ^ 0x1) << 1) & 0x2) | ((address_mod << 2) & 0x4)
            if mod3_as_mod2 == 3:  # 2 chway, ch 0, 2
                logChId = (Target_Id & 0x1) | ((address_mod << 2) & 0x4)
        else:
            logChId = Target_Id & 0x7
        ###############################################################################################################

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_24_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_24_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result


def SAD_Base_12_32G_2P(addr, page_mode, numa_mode):
    if numa_mode == 'Disable':

        base = ''  # 待求取
        address_mod = ''
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = [8, 9, 1, 1, 8, 9, 1, 1]
        InterleaveList_1 = [0, 0, 8, 9, 0, 0, 8, 9]

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   求取 system adreess 属于哪一个 SAD 范围
        for num in range(0, 2):
            base_temp = connect.select("select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = '12_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00606fffffff:
                result = "The System Address Out of Range"
                return result

        #   根据求出的 SAD 范围 求取 interleave_mode 以及 mod 3 的值
        db_data = connect.select(
            "select _MOD3, _MOD3_MODE, _MOD3_AsMod2, _INTERLEAVE_MODE from PURPLE_SAD_2P where SAD_NO "
            "like '%%12_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        mod3, mod3_mode, mod3_as_mod2, interleave_mode = (int(''.join(i)) for i in db_data)

        #   根据输入的 system address 和 SAD 区间 求出 Socket_Id  #############################
        addr_bits = bin(addr)[-10:-8]
        if addr_bits == '00' or addr_bits == '01':
            Socket_Id = 0
        if addr_bits == '10' or addr_bits == '11':
            Socket_Id = 1

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]
        ##############################################################################################################
        if mod3 == 1:
            if mod3_as_mod2 == 0:  # 2
                ch_mod = 3  # 3 chway mode
            else:
                ch_mod = 2  # 2 chway mode

            if mod3_mode == 0:
                address_mod = (addr >> 6) % ch_mod
            if mod3_mode == 1:
                address_mod = (addr >> 8) % ch_mod
            if mod3_mode == 2:
                address_mod = (addr >> 12) % ch_mod

            if mod3_as_mod2 == 0:  # 3 chway
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x6)
            if mod3_as_mod2 == 1:  # 2 chway, ch 0,1
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x2)
            if mod3_as_mod2 == 2:  # 2 chway, ch 1,2
                logChId = (Target_Id & 0x1) | (((address_mod ^ 0x1) << 1) & 0x2) | ((address_mod << 2) & 0x4)
            if mod3_as_mod2 == 3:  # 2 chway, ch 0, 2
                logChId = (Target_Id & 0x1) | ((address_mod << 2) & 0x4)
        else:
            logChId = Target_Id & 0x7
        ###############################################################################################################
        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)
        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_12_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_12_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result

    if numa_mode == 'Enable':

        base = ''  # 待求取
        address_mod = ''
        logChId = 0  # 待求取
        Socket_Id = 0  # 待求取
        MC_Id = 0  # 待求取
        Channel_Id = 0  # 待求取
        Target_Id = 0  # 待求取
        interleaveListIndex = 0  # 待求取

        # 配置信息 2.  Socket 0 and Socket 1: NM INTERLEAVE LIST   /InterleaveListCfg
        InterleaveList_0 = (8, 9, 8, 9, 8, 9, 8, 9)
        InterleaveList_1 = (8, 9, 8, 9, 8, 9, 8, 9)

        # 配置信息 3.  获取 MMIO 的地址区间,并 确定输入的 system address 是否属于 MMIO 区间
        if not memoryConfig.is_dram_addr(addr):
            return NOT_A_DRAM_RESULT

        #   确定 addr 属于哪一个SAD，并进一步求出属于哪个socket
        for num in range(0, 3):
            base_temp = connect.select(
                "select _BASE,_LIMIT from PURPLE_SAD_2P where SAD_NO = 'NUMA_12_32G_SAD%s'  " % num)
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])  # 求出了属于具体 SAD 区间的 base值
                break
            if addr < 0x0 or addr > 0x00603fffffff:
                result = "The System Address Out of Range"
                return result

        Socket_Id_temp = connect.select(
            " select _SOCKET from PURPLE_SAD_2P where SAD_NO "
            "like '%%NUMA_12_32G_SAD%%' and _BASE = '%s' " % to_hex_str(
                base))

        Socket_Id = (''.join(Socket_Id_temp))[-1]
        Socket_Id = int(Socket_Id)

        #   根据求出的 SAD和socket 范围 求取 interleave_mode 以及 mod 3 的值
        db_data = connect.select(
            "select _MOD3, _MOD3_MODE, _MOD3_AsMod2, _INTERLEAVE_MODE from PURPLE_SAD_2P where SAD_NO "
            "like '%%NUMA_12_32G_SAD%%' and _BASE = '%s'" % to_hex_str(base)
        )
        mod3, mod3_mode, mod3_as_mod2, interleave_mode = (int(''.join(i)) for i in db_data)

        #   根据数据库中求出的 interleave_mode 的值，求出 interleaveListIndex
        interleaveListIndex = (addr >> INTERLEAVE_MODE_VAL_TUPLE[interleave_mode]) & 0x7

        #   根据 interleaveListIndex 在 Socket  NM INTERLEAVE LIST 中的坐标求出 Target_Id
        if Socket_Id == 0:
            Target_Id = InterleaveList_0[interleaveListIndex]
        if Socket_Id == 1:
            Target_Id = InterleaveList_1[interleaveListIndex]

        ##############################################################################################################
        if mod3 == 1:
            if mod3_as_mod2 == 0:  # 2
                ch_mod = 3  # 3 chway mode
            else:
                ch_mod = 2  # 2 chway mode

            if mod3_mode == 0:
                address_mod = (addr >> 6) % ch_mod
            if mod3_mode == 1:
                address_mod = (addr >> 8) % ch_mod
            if mod3_mode == 2:
                address_mod = (addr >> 12) % ch_mod

            if mod3_as_mod2 == 0:  # 3 chway
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x6)
            if mod3_as_mod2 == 1:  # 2 chway, ch 0,1
                logChId = (Target_Id & 0x1) | ((address_mod << 1) & 0x2)
            if mod3_as_mod2 == 2:  # 2 chway, ch 1,2
                logChId = (Target_Id & 0x1) | (((address_mod ^ 0x1) << 1) & 0x2) | ((address_mod << 2) & 0x4)
            if mod3_as_mod2 == 3:  # 2 chway, ch 0, 2
                logChId = (Target_Id & 0x1) | ((address_mod << 2) & 0x4)
        else:
            logChId = Target_Id & 0x7
        ###############################################################################################################

        #   根据上面求出的 logic_channel_id---（logChId） ，结合 RingId 和 Chnlid 配置求出 iMC_id 和Channel_id
        if logChId in Ringid:
            MC_Id = Ringid[logChId]

        if logChId in Chnlid:
            Channel_Id = Chnlid[logChId]

        # 调取 tad 解析函数
        socket_id = ('SOCKET%s' % Socket_Id)
        mc_id = ('MC%s' % MC_Id)
        channel_id = ('CHANNEL%s' % Channel_Id)

        #   返回 TAD 结果
        result_tad = forwardTadOperation.TAD_Base_12_32G_2P(addr, socket_id, mc_id, page_mode, numa_mode)

        #   返回 RIR 结果
        channelAddr = to_int(result_tad)

        result_rir = forwardRirOperation.RIR_12_32G_2P(socket_id, mc_id, channel_id, channelAddr, page_mode, numa_mode)

        result = to_hex_str(addr) + "," + str(Socket_Id) + "," + str(
            3 * MC_Id + Channel_Id) + "," + result_rir + "," + result_tad
        return result
