#!/usr/bin/python
# -*- coding: UTF-8 -*-


def is_dram_addr(addr):
    sad_mmio_map = {
        "A": (0xa0000, 0xbffff), "B": (0xc0000, 0xfffff), "C": (0x78000000, 0x7bffffff), "D": (0x7f000000, 0x7fffffff),
        "E": (0x80000000, 0x8fffffff), "F": (0x90000000, 0x9d7fffff), "G": (0x9d800000, 0xaaffffff),
        "H": (0xab000000, 0xb87fffff), "I": (0xb8800000, 0xc5ffffff), "J": (0xfc000000, 0xffffffff),
        "K": (0xc6000000, 0xd37fffff), "L": (0xd3800000, 0xe0ffffff), "M": (0xe1000000, 0xee7fffff),
        "N": (0xee800000, 0xfbffffff)
    }
    for k, v in sad_mmio_map.items():
        if v[0] <= addr <= v[1]:
            return False
    return True
