#!/usr/bin/python
# -*- coding: UTF-8 -*-

BANK_NUM_TUPLE = ("7", "8", "13", "14", "15", "16", "17", "18")
TIME_FORMATTER = "%Y-%m-%d %H:%M"
TIME_SEC_FORMATTER = "%Y-%m-%d %H:%M:%S"
SYS_TIME_FORMATTER = "%Y-%m-%d/%H:%M:%S"

# 最大间隔时间5分钟
MAX_INTERVAL_SECS = 5 * 60
# 最小连续报错数20
MIN_CONTINUE_COUNT = 20
# 最少多DQ报错个数
MIN_DQ_ERROR_COUNT = 5

# 数据库筛选配置
SPLIT_SYMBOL = "__"
OPERATOR_MAP = {
    "eq": "=",
    "gt": ">",
    "gte": ">=",
    "lt": "<",
    "lte": "<=",
}


class CheckResult(object):
    PASS = "pass"
    NOT_PASS = "not_pass"
    WARNING = "warning"


# 原始回文报错地址信息表字段
ORIGIN_ERR_DQ_KEYS = (
    "id",
    "sn",
    "ctrl",
    "log_time",
    "node",
    "channel",
    "dimm",
    "rank",
    "bgroup",
    "bank",
    "row",
    "col",
    "dq",
    "continued_id",
    "continued_num",
    "multiple_dq_err_count",
    "_row_same",
    "_column_same",
    "_bank_same",
    "level"
)

# 原始回文规则告警信息
ORIGIN_WARN_DATA_KEYS = (
    "id",
    "sn",
    "ctrl",
    "log_start_time",
    "log_end_time",
    "node",
    "channel",
    "dimm",
    "count",
    "email_send_count",
    "level"
)

IS_DEBUG = False

# 告警级别
LEVEL_ERR = "error"
LEVEL_WARN = "warning"

# 最小连续报错数
ROW_MIN_CONTINUE_COUNT = 26
# 最少多dq报错个数
ROW_MIN_DQ_ERROR_COUNT = 1

# 最小连续报错数
COLUMN_MIN_CONTINUE_COUNT = 30
# 最少多dq报错个数
COLUMN_MIN_DQ_ERROR_COUNT = 1

# 最小连续报错数
BANK_MIN_CONTINUE_COUNT = 17
# 最少多DQ报错个数
BANK_MIN_DQ_ERROR_COUNT = 1

MASK_ACT_ERR_RULE = "mask_act_err_rule"
BSP_POWER_OFF_RULE = "bsp_power_off_rule"
BSP_POWER_ON_RULE = "bsp_power_on_rule"
EXT_FS_RULE = "ext_fs_rule"
READ_ONLY_FS_RULE = "read_only_fs_rule"
CTRL_BORD_BOOT_DISK = "ctrl_bord_boot_disk"
HOT_PLUG_INTERRUPT = "hot_plug_interrupt"
HARD_RESETTING_LINK = "hard_resetting_link"
