# -*- coding: UTF-8 -*-

import common
from container_base_check import ContainerCheck

PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)

CHECK_URL_LIST = ["infra/inspect/service/status"]


def execute(cyber_rest):
    dev_node = PY_JAVA_ENV.get("devInfo")
    item_check = ContainerCheck(dev_node, CHECK_URL_LIST, LANG, LOGGER)
    flag, msg = item_check.execute_check_cyber_engine()
    return flag, "\n".join(item_check.all_cli_ret), msg
