"""
@version: Toolkit V200R006C00
@time: 2019/08/30
@file: check_item_domain_expand_onetime_disknum.py
@function: check disk number when expand disk domain
@modify:
"""
import common
from cbb.frame.cli import cliUtil
from frameone.util import common as frameCommon

context = py_java_env.get("context")
lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)
DISK_NUMBER_LIMIT = 128


@frameCommon.fakeProgress(py_java_env, totalSeconds=30, logger=logger,
                          interval=1)
def execute(cli):
    """
    硬盘域一次性扩容盘数检查
    :param cli: cli连接
    :return flag: True(检查通过) / False(检查不通过) /
                  cliUtil.RESULT_NOCHECK(未检查) / cliUtil.RESULT_NOSUPPORT(不涉及)
    :return cliRet: cli回显内容
    :return errMsg: 错误消息
    """

    errMsg = ""

    # 获取版本信息
    flag, software_version, patch_version = cliUtil.getSystemVersion(cli, lang)
    if not flag:
        errMsg = common.getMsg(lang, "cannot.get.product.version.info")
        return cliUtil.RESULT_NOCHECK, "", errMsg

    # 版本判断 在版本范围内才进行校验
    if not in_software_version_range(software_version):
        errMsg = common.getMsg(lang, "software.version.does.not.to.be.checked")
        logger.logInfo(errMsg)
        return cliUtil.RESULT_NOSUPPORT, "", ""

    # 获取扩容配置数据
    exp_disk_list = common.getExpDiskListFromContext(py_java_env)

    # 按照硬盘域+引擎汇总硬盘数
    summary_disk_number_dict = get_summary_disk_number(exp_disk_list)

    # 硬盘数大于128 报错
    flag = True
    errList = []
    for key in summary_disk_number_dict.keys():
        disk_number_dict = summary_disk_number_dict.get(key)
        disk_number = disk_number_dict.get("disk_number")
        if disk_number > DISK_NUMBER_LIMIT:
            flag = False
            disk_domain_id = disk_number_dict.get("disk_domain_id")
            engine_id = disk_number_dict.get("engine_id")
            if engine_id == "new":
                errList.append(
                    common.getMsg(
                        lang,
                        "disks.over.limit.when.create.disk.domain",
                        DISK_NUMBER_LIMIT))
            else:
                errList.append(
                    common.getMsg(
                        lang,
                        "disks.over.limit.when.expand.disk.domain",
                        (engine_id, disk_domain_id, DISK_NUMBER_LIMIT)))

    errMsg = "".join(errList)

    return flag, "", errMsg


def in_software_version_range(software_version):
    return "V300R006C50" <= software_version <= "V300R006C60SPC100" \
           or "V500R007C30" <= software_version <= "V500R007C60"


def get_summary_disk_number(exp_disk_list):
    summary_disk_number_dict = {}

    for exp_disk in exp_disk_list:
        disk_domain_id = exp_disk.get("diskDomain")
        engine_id = exp_disk.get("eng")
        disk_number = int(exp_disk.get("diskNum"))
        tmp_key = disk_domain_id + "#" + engine_id
        default_dict = {"disk_domain_id": disk_domain_id,
                        "engine_id": engine_id}
        tmp_dict = summary_disk_number_dict.get(tmp_key, default_dict)
        tmp_dict["disk_number"] = tmp_dict.get("disk_number", 0) + disk_number
        summary_disk_number_dict[tmp_key] = tmp_dict

    return summary_disk_number_dict
