# -*- coding: UTF-8 -*-

import cliUtil
import common
from common_utils import get_dpa_rest_record

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(dpa_rest):
    record = ""
    try:
        err_msg = ""
        node_query_uri = "/oauths/licenses"
        record = get_dpa_rest_record(dpa_rest, node_query_uri)
        license_totle_nums = record.get("responseData", {}).get("totalNum")
        for license_info in record.get("responseData", {}).get("data", [{}]):
            license_active_flag = str(license_info.get("activeFlag"))
            license_expired = str(license_info.get("expired"))
            license_code = license_info.get("licenseCode")
            if license_active_flag != "True":
                err_msg += common.getMsg(LANG, "dpa.license.active.status.abnormal",
                                         (license_code, license_active_flag))
                LOGGER.logNoPass("The activeFlag of License [{}] is abnormal (License activeFlag:{})".format
                                 (license_code, license_active_flag))
                continue
            elif license_expired != "False":
                err_msg += common.getMsg(LANG, "dpa.license.expired.status.abnormal", license_code)
                LOGGER.logNoPass("License [%s] Expired".format(license_code))

        if not err_msg:
            return True, "Total Number of License are {}.\n{}".format(license_totle_nums, record), ""
        return False, "Total Number of License are {}.\n{}".format(license_totle_nums, record), err_msg

    except Exception as exp:
        LOGGER.logError(str(exp))
        return (cliUtil.RESULT_NOCHECK, record,
                common.getMsg(LANG, "query.result.abnormal"))