# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import common
from common_utils import get_dpa_rest_record

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
NEED_CHECK_STATUS = ["4", "8", "256"]


def execute(dpa_rest):
    error_msg = ""
    record_list = []
    for status in NEED_CHECK_STATUS:
        node_query_uri = "/datasyncs/job_instaces?count=15&engineType=&filter=&index=0&jobStatus={}".format(status)
        record = get_dpa_rest_record(dpa_rest, node_query_uri)
        record_list.append(str(record))
        if record.get("responseData", {}).get("data"):
            LOGGER.logNoPass("There are running remote replication tasks.")
            error_msg += common.getMsg(LANG, "dpa.remote.replication.task.abnormal")
    if error_msg:
        return False, "\n".join(record_list), error_msg
    return True, "\n".join(record_list), ""
