# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import common
import dpa_common
import cliUtil
from common_utils import get_dpa_rest_record

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
HOPE_TYPES = (1, 2)


def execute(dpa_rest):
    err_msg = ""
    record = ""
    try:
        job_list, record = dpa_common.get_backup_job_list(dpa_rest)
        if not job_list:
            err_msg += common.getMsg(LANG, "dpa.get.backup.job.list.abnormal")
        for job in job_list:
            flag, temp_record = get_exectype(dpa_rest, job.get("jobId"))
            record = "{}\n{}".format(record, temp_record)
            if not flag:
                err_msg += common.getMsg(LANG, "dpa.standard.backup.backup.policy.abnormal",
                                         (job.get("jobId"), job.get("jobName")))
        if err_msg:
            return False, record, err_msg
        return True, record, err_msg
    except Exception as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, record, common.getMsg(LANG, "query.result.abnormal")


def get_exectype(dpa_rest, job_id):
    types = list()
    node_query_uri = "/backups/job/{}/schedule".format(job_id)
    record = get_dpa_rest_record(dpa_rest, node_query_uri)
    job_list = record.get("responseData", {}).get("data", [{}])
    for job in job_list:
        if "execType" in job.keys():
            types.append(job.get("execType"))
    check_results = [exec_type in types for exec_type in HOPE_TYPES]
    if False in check_results:
        LOGGER.logNoPass(
            "check full_backup is {};check incremental_backup is {}".format(check_results[0], check_results[1]))
        return False, record
    return True, record
