# -*- coding: UTF-8 -*-
import cliUtil
import common
import config
import expandconfig

'''
双活裁剪型号进行LUN扩容会挂死系统
'''
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

CHECK_STEP_6 = {
    "V500R007C00SPC100":["2800 V5","5300 V5","5300F V5"],
    "V300R006C10SPC100":["2200 V3","2600_V3","2600F V3","2600 V3 for Video","2800 V3","5300 V3"],
}

CHECK_STEP_7 = {
    "V500R007C00SPC100":["5500 V5","5500 V5 Elite","5500F V5","5600 V5","5600F V5","5800 V5","5800F V5",
                         "6800 V5","6800F V5","18500 V5","18500F V5","18800 V5","18800F V5"],
    "V300R006C10SPC100":["5500 V3","5500F V3","5600 V3","5600F V3","5800 V3","5800F V3","6800 V3",
                         "6800F V3","6900 V3","18500 V3","18500F V3","18800 V3","18800F V3"],
}

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

def execute(cli):
    cliRet = ""
    try:
        #进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, LOGGER)
        #进度开始
        common.inProcess(py_java_env)
        LOGGER.logInfo("process Thread started!")

        checkItem = CheckItem(cli, LANG, LOGGER)
        checkItem.check()
        return checkItem.getResult()
    except Exception, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal")
    finally:
        common.finishProcess(py_java_env)
        LOGGER.logInfo("finish process!")


class CheckItem():
    def __init__(self, cli, lang, logger):
        self.cli = cli
        self.lang = lang
        self.logger = logger

        self.allCliRet = ""
        self.result = True
        self.allErrMsg = ""
        self.originProductModel = self.getOriginProductModel()
        self.productModel = self.getProductModel4Rule()
        self.expDiskList = expandconfig.ExpandConfig(py_java_env).getAllExpDiskList()

        return

    def setResult(self,flag):
        if flag != True:
            self.result = flag if flag and self.result else False
        return

    def check(self):
        self.productModel = self.getProductModel4Rule()
        if self.result != True:
            return

        self.version, self.patch = self.getSysAndPatchVer()
        if self.result != True:
            return

        self.rule = self.getRule()
        self.checkVersion()
        if self.result != True:
            return

        flag, self.controlList, __ = cliUtil.getControllerIdList(self.cli, self.lang)
        if flag != True:
            self.result = False
            self.allErrMsg += common.getMsg(self.lang, "cannot.ctrl.id.ip")
            return
        self.checkRule()
        return

    def getOriginProductModel(self):
        devInfo = common.getCurDeviceInfo(py_java_env)
        return str(devInfo.getDeviceType())

    def getProductModel4Rule(self):
        productModel = self.originProductModel
        if not common.isDorado5000(productModel):
            return productModel

        flag, cliRet, errMsg, type = common.getEnclosureType(self.cli, self.lang)
        self.allCliRet += cliRet
        if flag != True:
            self.setResult(flag)
            self.allErrMsg += common.getMsg(self.lang, "cannot.get.enclosure.info")
            return None

        return "%s %s"%(productModel, type)

    def getSysAndPatchVer(self):
        flag, sys, patch, cliRet, errMsg = common.getProductVersionAndHotPatchVersion(self.cli, self.logger, self.lang)
        self.allCliRet += cliRet
        if flag != True:
            self.setResult(flag)
            self.allErrMsg += common.getMsg(self.lang, "cannot.get.product.version.info")
            return None,None
        return sys, patch

    def getRule(self):
        for rule in config.HETERO_LUN_CONF:
            model = rule[0]
            sys = rule[1]
            if sys == self.version and model == self.productModel:
                return rule

        return None

    def checkVersion(self):
        if not self.rule:
            self.setResult(cliUtil.RESULT_NOSUPPORT)
            return

        soluationPatch = self.rule[4]
        if soluationPatch != None and soluationPatch <= self.patch :
            self.setResult(cliUtil.RESULT_NOSUPPORT)
            return

        return

    def checkRule(self):
        self.expDiskNumMap = self.getExpDiskNum()
        self.logger.logInfo("expand disk info:%s" %self.expDiskNumMap)
        self.lunNumMap = self.getLunNum()
        self.logger.logInfo("get lun info:%s" % self.lunNumMap)
        if self.lunNumMap == None:
            return

        self.diskNumMap = self.getDiskNum()
        self.logger.logInfo("get disk info:%s" % self.diskNumMap)
        if self.diskNumMap == None:
            return

        if CHECK_STEP_6.has_key(self.version) and self.productModel in CHECK_STEP_6.get(self.version):
            self.checkStep6()
        elif CHECK_STEP_7.has_key(self.version) and self.productModel in CHECK_STEP_7.get(self.version):
            self.checkStep7()
        else:
            self.checkStep8()
        return

    def getLunNum(self):

        lunNumMap = {}
        flag, cliRet, errMsg, rmDevIdList = cliUtil.getRemoteDevOfHetero(self.cli, self.lang)
        self.allCliRet += cliRet
        if flag != True:
            self.setResult(flag)
            self.allErrMsg += common.getMsg(self.lang, "remote.device.idinfomation")
            return None

        if (not rmDevIdList) and self.version not in CHECK_STEP_6.keys():
            self.setResult(cliUtil.RESULT_NOSUPPORT)
            return None

        heteroLunList = []
        for devId in rmDevIdList:
            flag, cliRet, errMsg, lunList = cliUtil.getHeteroLunByRmDevId(self.cli, self.lang, devId)
            self.allCliRet += cliRet
            if flag != True:
                self.setResult(flag)
                self.allErrMsg += common.getMsg(self.lang, "lun.edev.rmdev.info.faile", devId)
                return None
            heteroLunList.extend(lunList)

        for lunWwn in heteroLunList:
            flag, cliRet, errMsg, ctrls = cliUtil.getCtrlByLunWwn(self.cli, self.lang, lunWwn)
            self.allCliRet += cliRet
            if flag != True:
                self.setResult(flag)
                self.allErrMsg += common.getMsg(self.lang, "lun.edev.wwn.info.faile", lunWwn)
                return None
            for ctrl in ctrls:
                lunNumMap[ctrl] = lunNumMap.get(ctrl, 0) + 1

        return lunNumMap

    def getDiskNum(self):
        flag, cliRet, errMsg, ctrlMap = cliUtil.getDiskNum4Ctrl(self.cli,self.lang)
        self.allCliRet += cliRet
        if flag != True:
            self.setResult(flag)
            self.allErrMsg += common.getMsg(self.lang, "cannot.get.diskinfo")
            return None
        return ctrlMap

    def getExpDiskNum(self):
        totalNumMap = {}
        for exp in self.expDiskList:

            if exp.getDiskDomainId() == "none":
                ctrlList = self.controlList
            else:
                logicId = exp.getDiskLogicEngId()
                ctrlList =  common.getCtrlsByLogicEng(logicId, self.originProductModel)

            for ctrl in ctrlList:
                totalNumMap[ctrl] = totalNumMap.get(ctrl, 0) + exp.getDiskNum()

        return totalNumMap

    def getErrMsg(self):
        errMsg = ""
        if not self.rule[4]:
            info = self.rule[5].split("+")
            if len(info) > 1:
                # 异构Lun数量和硬盘数量接近满规格，存在扩容风险，请升级到%s及以后的版本后再扩容，如有疑问请联系技术支持工程师协助处理。
                errMsg = common.getMsg(self.lang, "exp.hetero.lun.sys.patch.fail", info[1].strip())
            else:
                # 异构Lun数量和硬盘数量接近满规格，存在扩容风险，请升级到%s及以后的版本后再扩容，如有疑问请联系技术支持工程师协助处理。
                errMsg = common.getMsg(self.lang, "exp.hetero.lun.sys.fail", info[0].strip())
        else:
            # 异构Lun数量和硬盘数量接近满规格，存在扩容风险，请安装%s及以后的补丁后再扩容，如有疑问请联系技术支持工程师协助处理。
            errMsg = common.getMsg(self.lang, "exp.hetero.lun.patch.fail", self.rule[4].strip())
        return errMsg

    def checkMaxRule(self, maxNum):
        ctrlList = self.expDiskNumMap.keys()
        ctrlList = sorted(ctrlList)
        for ctrl in ctrlList:
            diskNum = self.diskNumMap.get(ctrl, 0)
            lunNum = self.lunNumMap.get(ctrl, 0)
            expDiskNum = self.expDiskNumMap.get(ctrl)
            if (diskNum + lunNum + expDiskNum) > maxNum :
                self.logger.logInfo("[check_item_exp_hetero_lun] The controller(%s) is not passed."
                                    "(diskNum:%s, lunNum:%s, expDiskNum:%s, maxNum:%s)"%(ctrl, diskNum, lunNum, expDiskNum, maxNum))
                self.result = False
                self.allErrMsg += self.getErrMsg()
                return
        return

    def checkStep6(self):
        maxNum = self.rule[2] - 70
        self.checkMaxRule(maxNum)
        return

    def checkStep7(self):
        maxNum = self.rule[3] - 512 - 70
        self.checkMaxRule(maxNum)
        return

    def checkStep8(self):
        maxNum = self.rule[3] - 70
        self.checkMaxRule(maxNum)
        return

    def getResult(self):
        return self.result, self.allCliRet, self.allErrMsg