# -*- coding: UTF-8 -*-
import cliUtil
import common
import common_cache
import common_utils
import config
import traceback

from com.huawei.ism.tool.obase.exception import ToolException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def execute(cli):
    '''
            检查方法    
            步骤1 以admin用户登录设备;
            步骤2 执行命令：show system general查询产品型号;
            步骤3 执行命令：show upgrade package查询系统软件版本和系统补丁版本。
            
            检查标准    
            1、若步骤2获取的设备型号不为Oceanstor Dorado 6800 V6/8000 V6/18000 V6/18500 V6/18800 V6/18800K V6，则检查通过，否则继续检查；
            2、若步骤3获取的软件版本若为6.0.1.SPH6及以上版本，则检查通过，否则继续检查；
            3、若扩容场景为高端扩容到4控，则检查通过；若扩容场景为高端扩容到8控，则检查不通过；

            修复建议
            1、请升级到6.0.1版本并安装SPH6或更高版本补丁后，再进行扩容操作。
    '''

    return PatchVersionHighEndCheck(cli, LANG, PY_JAVA_ENV, LOGGER).run()


class PatchVersionHighEndCheck(object):
    allCliRet = ""

    def __init__(self, cli,lang,env,logger):
        self.cli = cli
        self.lang = lang
        self.env = env
        self.logger = logger
        self.allCliRet = ""
    def run(self):
        try:
            # 获取设备型号
            flag, productModel, product_version,result, = \
            cliUtil.getProductModelAndVersionNotOEM(self.cli,self.lang)
            if flag != True:
                return (cliUtil.RESULT_NOCHECK, self.allCliRet, result)
            self.allCliRet= result
            LOGGER.logInfo("check_expansion_version : Get product model [%s] " % (productModel))
            # 设备是否为DoradoV6的高端设备
            if productModel not in config.DORADO_DEVS_V6_HIGH:
                LOGGER.logInfo("product model is not high-end device")
                return (True, self.allCliRet, "")
            # 获取设备当前产品版本
            cliRet, curProductVersion, hotPatchVersion = common.getHotPatchVersionAndCurrentVersion(self.cli, self.lang)
            LOGGER.logInfo("check_expansion_version:Get current product version [%s] ,hot patch version [%s]" % (
                curProductVersion, hotPatchVersion))
            self.allCliRet = common.joinLines(self.allCliRet, cliRet)

            # 校验件版本若为6.0.1.SPH6及以上则通过
            flag, self.allCliRet, errMsg=self.checkproductVersionAndPatchVerdion(curProductVersion,hotPatchVersion,product_version)
            return flag,self.allCliRet,errMsg
        except Exception:
            LOGGER.logError(str(traceback.format_exc()))
            raise
        except:
            LOGGER.logError(str(traceback.format_exc()))
            return (cliUtil.RESULT_NOCHECK, self.allCliRet, common.getMsg(LANG, "query.result.abnormal"))

    def getProductModelAndProductVersion(self):
        '''
        @summary: 执行命令show system general，将 Product Model
                  回显存放到同一个字典列表中
        @param cli: cli对象
        '''


        return (True, productModel, product_version, "")

    def checkproductVersionAndPatchVerdion(self,curProductVersion,hotPatchVersion,product_version):
        '''
                @summary: 2、若步骤3获取的软件版本若为6.0.1.SPH6及以上版本，则检查通过，否则继续检查；
            3、若扩容场景为高端扩容到4控，则检查通过；若扩容场景为高端扩容到8控，则检查不通过；
                @:param self
                @:param curProductVersion 版本
                @:param hotPatchVersion 补丁版本
                '''
        if not (curProductVersion and hotPatchVersion):
            err_msg = common.getMsg(LANG, "cannot.get.product.version.info")
            return cliUtil.RESULT_NOCHECK, self.allCliRet, err_msg
        patch_num = common_utils.get_p_patch_num(hotPatchVersion)
        if "6.0.1" in curProductVersion and patch_num >= 6:
            LOGGER.logInfo("check_expansion_version: success.")
            return (True, self.allCliRet, "")
        else:
            ctrlNumAfExp = common.getExpCtrlNumber(py_java_env)
            LOGGER.logInfo("check_expansion_version:the ctrlNumAfExp is [%s]" % ctrlNumAfExp)
            if ctrlNumAfExp == 4:
                return (True, self.allCliRet, "")
            if ctrlNumAfExp == 8:
                LOGGER.logInfo("check_expansion_version:Not Pass.Get current product version [%s] "
                               ",hot patch version [%s]" % (curProductVersion, hotPatchVersion))
                errMsg = common.getMsg(LANG, "exp.current.product.version", (product_version))
                return (False, self.allCliRet, errMsg)
