# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

def getTier(ddType):
    if not ddType:
        return None
    
    ddType = ddType.lower()
    if ddType == "ssd":
        return "tier0"
    if ddType == "sas":
        return "tier1"
    if ddType in ["nearline sas", "sata"]:
        return "tier2"
    
    return None

def execute(cli):
    '''
        硬盘域扩容检查： 
                检查同一个硬盘域扩容时，是否同时扩容三层。
    '''
    cliRet = ""
    cliRetAll = ""
    errMsg = ""
    layerMax = 3
    
    try:
        cmd = "show disk_domain general"
        LOGGER.logInfo(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRet = checkRet[1]
        cliRetAll += cliRet
        if "error" in cliRet.lower() or (not cliUtil.hasCliExecPrivilege(cliRet)):
            return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
        
        expDiskList = py_java_env.get("expDiskList")
        LOGGER.logInfo("expDiskList is %s" % str(expDiskList))
        if not expDiskList:
            return (cliUtil.RESULT_NOSUPPORT, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
        
        #进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, LOGGER)
        #进度开始
        common.inProcess(py_java_env)
        LOGGER.logInfo("process Thread started!")
        
        tierMap = {}
        threeTierMap = {}
        engList = []
        domainList = []
        for expDiskDict in expDiskList:
            eng = expDiskDict.get("eng")
            #忽略新建硬盘域场景
            if eng == "new":
                continue
            
            if len(eng) < 4 or (not eng[3].isdigit()):
                return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
            #CTEx或DAEx场景，x取值为引擎编号
            eng = eng[3]
            
            #在已有硬盘域上扩容场景
            ddType = expDiskDict.get("diskModel")
            tier = getTier(ddType)
            if not tier:
                continue
            
            ddName = expDiskDict.get("diskDomain")
            
            key = (eng, ddName)
            tierInfo = tierMap.get(key,[])
            if tier in tierInfo:
                continue
            tierInfo.append(tier)
            tierMap[key] = tierInfo
            
            if len(tierInfo) == layerMax:
                threeTierMap[key] = tierInfo
                engList.append(eng)
                domainList.append(ddName)
        
        LOGGER.logInfo("threeTierMap is %s" % str(threeTierMap))
        resultList = []
        for threeDDName in domainList:
            cmd = "show disk in_domain disk_domain_id=%s|filterColumn include columnList=ID,Type" % threeDDName
            LOGGER.logInfo(cmd)
            checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            cliRet = checkRet[1]
            cliRetAll += cliRet
            if "error" in cliRet.lower() or (not cliUtil.hasCliExecPrivilege(cliRet)):
                return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
            cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
            
            newThreeTierMap = {}
            for line in cliRetLinesList:
                diskID = line.get("ID")
                if len(diskID) < 4 or (not diskID[3].isdigit()):
                    return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
                #CTEx或DAEx场景，x取值为引擎编号
                newEng = diskID[3]
                if newEng not in engList:
                    continue
                newKey = (newEng, threeDDName)
                
                threeTier = getTier(line.get("Type"))
                if not threeTier:
                    continue
                threeTierList = newThreeTierMap.get(newKey, [])
                if threeTier in threeTierList:
                    continue
                threeTierList.append(threeTier)
                newThreeTierMap[newKey] = threeTierList
                if len(threeTierList) == layerMax:
                    resultList.append(newKey)
                
        if len(resultList) == 0:
            return (True, cliRetAll, errMsg)
        
        for result in resultList:
            errMsg += common.getMsg(LANG, "exp.diskdomain.check.fail", (result[0], result[1]))
        return (False, cliRetAll, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        common.finishProcess(py_java_env)
        LOGGER.logInfo("finish process!")
