# -*- coding: UTF-8 -*-
import re

import common
import config
import cliUtil
from com.huawei.ism.tool.obase.exception import ToolException
from common import UnCheckException
from risk_version_config import SMART_IO_NO_RISK_VERSION
from common_utils import is_super_administrator
from collections import namedtuple

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)

CommandResult = namedtuple('CommandResult',
                           field_names=['cmd_flag', 'cmd_ret',
                                        'cmd_err_msg', 'cmd_product_model'])
# 进度总剩余时间
LIMIT_TIME = 120
# 进度刷新间隔
INTERVAL = 2


def execute(cli):
    """
    smartIO1.0卡固件版本检查
    :param cli: cli链接
    :return:
    """
    conn_cli = ""
    meg_dict = dict()
    meg_dict['all_cli_ret_list'] = list()
    meg_dict['all_err_meg'] = list()
    meg_dict['not_pass_controller'] = list()
    all_cli_ret_list = meg_dict.get('all_cli_ret_list', list())
    all_err_meg = meg_dict.get('all_err_meg', list())
    try:
        flag, ret, msg, product_model = check_risk_model(cli)
        all_cli_ret_list.append(ret)
        if flag is not True:
            return flag, ret, msg
        flag, soft_version, patch_ver, cli_ret_version, err_msg = \
            common.get_soft_and_patch_version(cli, LOGGER, LANG)
        all_cli_ret_list.append(cli_ret_version)
        meg_dict["patch_ver"] = patch_ver
        meg_dict["soft_version"] = soft_version
        meg_dict["product_model"] = product_model
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret_list), err_msg
        if not check_risk_version(soft_version):
            return cliUtil.RESULT_NOSUPPORT, "\n".join(all_cli_ret_list), ""
        # 如果是18000执行debug命令获取阵列链接
        create_ret = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV,
                                                        LOGGER,
                                                        LANG)
        if create_ret[0] is not True:
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret_list), \
                   create_ret[2]
        conn_cli = create_ret[1]
        # 这里是构建控制器信息
        flag = build_controller_name(cli, LANG, meg_dict)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, "\n".join(
                all_cli_ret_list), common.getMsg(
                LANG, "query.result.abnormal")
        # 开始心跳
        check_smart_version_execption(conn_cli, PY_JAVA_ENV, LOGGER, LANG, "",
                                      meg_dict)
        LOGGER.logInfo("smario1.0 end of heartbeat")

        return process_result(meg_dict, all_err_meg,
                              "\n".join(all_cli_ret_list), soft_version,
                              patch_ver)
    except UnCheckException as un:
        LOGGER.logException(un)
        return cliUtil.RESULT_NOCHECK, "\n".join(
            all_cli_ret_list), un.errorMsg
    except (ToolException, Exception) as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, "\n".join(
            all_cli_ret_list), common.getMsg(
            LANG, "query.result.abnormal")
    finally:
        if conn_cli != "" \
                and common.is18000(PY_JAVA_ENV, conn_cli) \
                and conn_cli is not cli:
            common.closeConnection(conn_cli, PY_JAVA_ENV, LOGGER)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
        common.finishProcess(PY_JAVA_ENV)
        LOGGER.logInfo("finish process!")


def check_risk_model(cli):
    # 下发show system general以便在回文中显示
    flag, product_model, cli_ret, err_msg = \
        cliUtil.getProductModelWithCliRet(cli, LANG)

    if flag is not True:
        return CommandResult(cmd_flag=cliUtil.RESULT_NOCHECK, cmd_ret=cli_ret,
                             cmd_err_msg=err_msg, cmd_product_model=product_model)

    if common.isDorado(product_model) or common.is18000(PY_JAVA_ENV, cli) \
            or '2100 V3' in product_model or '2200 V3' in product_model:
        return CommandResult(cmd_flag=cliUtil.RESULT_NOSUPPORT, cmd_ret=cli_ret,
                             cmd_err_msg="", cmd_product_model=product_model)
    # 不是超级管理员账号,报未完成检查
    if not is_super_administrator(cli, PY_JAVA_ENV.get("devInfoMap").get("userName"), LANG):
        return CommandResult(cmd_flag=cliUtil.RESULT_NOCHECK, cmd_ret=cli_ret,
                             cmd_err_msg=common.getMsg(LANG, "loginUser.name.level.must.be.super.admin"),
                             cmd_product_model=product_model)
    return CommandResult(cmd_flag=True, cmd_ret=cli_ret,
                         cmd_err_msg="", cmd_product_model=product_model)


def process_result(meg_dict, all_err_meg, all_ret, soft_version, patch_ver):
    """
    避免超长方法
    :param meg_dict:  容器
    :param all_cli_ret_list: 回文
    :param soft_version: 版本
    :param patch_ver: 型号
    :return: 返回值
    """

    if meg_dict.get('not_support_flag', False):
        return cliUtil.RESULT_NOSUPPORT, all_ret, ""
    if meg_dict.get('not_check_flag', False):
        return cliUtil.RESULT_NOCHECK, all_ret, "\n".join(all_err_meg)
    if meg_dict.get('not_pass_flag_without_controller', False):
        return False, all_ret, \
               common.getMsg(LANG,
                             "smartIo_not_pass_without_controller",
                             (soft_version, patch_ver))
    if meg_dict.get('warning_flag_without_controller', False):
        return cliUtil.RESULT_WARNING, \
               all_ret, common.getMsg(LANG,
                                      "smartIo_not_pass_without_controller",
                                      (soft_version, patch_ver))
    if meg_dict.get('not_pass_flag', False):
        not_pass_controller = list(
            set(meg_dict.get('not_pass_controller', list())))
        not_pass_controller.sort()
        return False, all_ret, common.getMsg(
            LANG, "smartIo_not_pass", (soft_version, patch_ver, ",".join(not_pass_controller)))
    return True, all_ret, ""


def check_risk_version(soft_version):
    """
    检查是否为风险版本
    :param soft_version: 设备版本
    :return: T
    """
    return soft_version in SMART_IO_NO_RISK_VERSION


@common.checkAllEngineInClusterWarp
def check_smart_version_execption(cli, PY_JAVA_ENV, LOGGER, LANG,
                                  heart_beat_cli_ret, meg_dict):
    """
    轮询引擎进行检查
    :param cli: cli链接
    :param PY_JAVA_ENV: 上下文
    :param LOGGER: 日志
    :param LANG: lang
    :param heart_beat_cli_ret: 心跳回显
    :param meg_dict 参数字典
    :return:
    """

    flag, err_msg, cli_ret, current_ctrl, engine_ctrl_mapping_dict, \
    current_engine, node_num = common.getEngineCtrlNodeInfo(cli, LOGGER, LANG)
    LOGGER.logInfo("current_ctrl id is:%s" % current_ctrl)

    current_controller = meg_dict.get("node_controller_map", dict).get(current_ctrl, "--")
    LOGGER.logInfo("current_controller id is:%s" % current_controller)

    # 获取当前引擎控制器信息
    flag, cli_ret, e_msg = cliUtil.enterDeveloperMode(cli, LANG)
    all_cli_ret_list = meg_dict.get('all_cli_ret_list', list())
    all_err_meg = meg_dict.get('all_err_meg', list())
    all_cli_ret_list.append(cli_ret)
    if flag is not True:
        meg_dict['not_check_flag'] = True
        all_err_meg.append(e_msg)
        return common.CHECK_FLAG_NOT_CONTINUE

    cmd = "show cluster general"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret_list.append(cli_ret)
    if flag is not True:
        meg_dict['not_check_flag'] = True
        all_err_meg.append(err_msg)
        return common.CHECK_FLAG_NOT_CONTINUE

    cli_ret_lines_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
    network_mode = ""
    for info in cli_ret_lines_list:
        network_mode = info.get("Network Mode", "")

    if network_mode.lower() != 'switch mode' and network_mode.lower() != 'switchless mode':
        if not is_expansion_disk_or_ctrl_scene(meg_dict.get("product_model"), LOGGER):
            meg_dict['not_support_flag'] = True
            return common.CHECK_FLAG_NOT_CONTINUE

    path_version = meg_dict.get('patch_ver', "--")
    soft_version = meg_dict.get("soft_version", "--")
    # 系统未安装补丁或补丁版本低于V300R006C50SPH109或V500R007C30SPH109则不通过
    if not check_hot_path_version(soft_version, path_version, meg_dict):
        return common.CHECK_FLAG_NOT_CONTINUE
    cmd = 'minisystem'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret_list.append(cli_ret)
    if not cliUtil.isInMinisystemMode(cli_ret):
        meg_dict['not_check_flag'] = True
        all_err_meg.append(common.getMsg(LANG, "query.result.abnormal"))
        return common.CHECK_FLAG_NOT_CONTINUE

    cmd = "cat /startup_disk/image/boot_osp/versions.conf"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, LANG)
    all_cli_ret_list.append(cli_ret)
    if flag is not True:
        meg_dict['not_check_flag'] = True
        all_err_meg.append(err_msg)
        return common.CHECK_FLAG_NOT_CONTINUE

    if '[SmartIO]' in cli_ret:
        smart_io_ret = cli_ret[cli_ret.find(r'[SmartIO]'):]
        pattern_hot_patch = re.compile(r'Version=1.20T(\d+)')
        match_hot_path = pattern_hot_patch.search(smart_io_ret)
        if match_hot_path and int(match_hot_path.group(1)) >= 9 and soft_version in ["V300R006C50SPC100",
                                                                                     "V500R007C30SPC100"]:
            return common.CHECK_FLAG_CONTINUE
        elif match_hot_path and int(match_hot_path.group(1)) >= 17 and soft_version in ["V300R006C20", "V500R007C10"]:
            return common.CHECK_FLAG_CONTINUE


    if current_controller == '--':
        meg_dict['not_pass_flag_without_controller'] = True
        return common.CHECK_FLAG_NOT_CONTINUE
    meg_dict['not_pass_flag'] = True
    meg_dict.get('not_pass_controller', list()).append(
        current_controller)
    return common.CHECK_FLAG_CONTINUE


def build_controller_name(cli, lang, meg_dict):
    """
    控制器名称为
    构建controller名称
    :param cli: cli
    :param LANG: lang
    :param meg_dict: 检查项字典
    :return:是否构建成功
    """

    is_qry_succ, present_node_id_list = common.get_engine_node_id_list(
        cli, PY_JAVA_ENV, LOGGER)
    check_ret = cliUtil.getControllerIdList(cli, lang)
    if is_qry_succ is True and check_ret[0] is True:
        meg_dict['node_controller_map'] = dict(
            zip(present_node_id_list, check_ret[1]))
        return True
    else:
        return False


def check_hot_path_version(product_ver, hot_ver, meg_dict):
    """
    判断补丁是否大于当前版本
    product_ver： 系统软件版本
    hot_ver：热补丁版本
    :return: 是否不需要继续检查
    """

    # 判断补丁版本是否在风险版本中
    if product_ver in config.smartIO_hot_ver_dict:
        best_hot_ver = config.smartIO_hot_ver_dict.get(product_ver, "")
        if hot_ver >= best_hot_ver and not re.search(r"SPH\d[6-9]\d", hot_ver):
            return True
        meg_dict['not_pass_flag_without_controller'] = True
        return False
    meg_dict['warning_flag_without_controller'] = True
    return False


def is_expansion_disk_or_ctrl_scene(product_model, logger):
    """
    扩容评估场景的扩容控制器和扩容控制器场景。
    :return:
    """
    scene_data = PY_JAVA_ENV.get("sceneData")
    if not scene_data:
        return False

    logger.logInfo("scene data :{}".format(scene_data))
    if not all(
            [
                scene_data.get("mainScene") == "Expansion",
                scene_data.get("toolScene") == "perInspector",
                any(
                    [
                        scene_data.get("subScene") == "Expansion Controller",
                        PY_JAVA_ENV.get("expMode") == "EXTEND_CTRL"
                    ]
                ),
            ]
    ):
        return False
    ctrl_number = int(PY_JAVA_ENV.get("expCtrl", 0))
    logger.logInfo("aft_ctrl_number :{}".format(ctrl_number))
    if ctrl_number <= 2:
        return False
    # 6800 需要进行特殊判断，扩容后控制器大于4才是扩引擎场景
    if "6800" in product_model:
        if ctrl_number <= 4:
            return False
    return True
