# -*- coding: UTF-8 -*-
from cbb.business.operate.fru.common.checkItem import compute_storage_common
from cbb.frame.checkitem.context_adapter import InspectContext
import cliUtil
import common

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
#要求存储多个电源正常状态数量大于3
POWER_OK_NUMS = 3
POWER_QUERY_URL = "/redfish/v1/chassis/enclosure/power"


def execute(cli):
    context = InspectContext(PY_JAVA_ENV, cli)
    inspect_context = context.get_context()
    if not common.check_holding_fcv_connection(inspect_context):
        return cliUtil.RESULT_NOSUPPORT, "", ""
    all_cli_ret = []
    record = get_control_enclosure_power_connect(inspect_context)
    all_cli_ret.append('{}\n{}'.format(POWER_QUERY_URL, str(record)))
    power_supplies_health = \
        [power for power in record.get("PowerSupplies", [{}]) if power.get("Status", {}).get("Health") == "OK"]
    err_msg_list = []
    if len(power_supplies_health) < POWER_OK_NUMS:
        err_msg_list.append(common.getMsg(LANG, "computer.storage.power.supply.health.status.abnormal"))
        LOGGER.logNoPass("The health status of control enclosure power supply is abnormal")
    err_msg_list.extend(check_enc_power(cli, all_cli_ret))
    if not err_msg_list:
        return True, "\n".join(all_cli_ret), ""
    return False, "\n".join(all_cli_ret), "\n".join(err_msg_list)


def get_power_info(cli, all_cli_ret):
    cmd = "show power_supply"
    flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret.append(ret)
    return cliUtil.getHorizontalCliRet(ret)


def check_enc_power(cli, all_cli_ret):
    err_msgs_list = []
    power_infos_list = get_power_info(cli, all_cli_ret)
    for line in power_infos_list:
        power_id = line.get("ID", "")
        health_status = line.get("Health Status")
        running_status = line.get("Running Status")
        if (health_status != common.STATUS_NORMAL) or (running_status != common.STATUS_ONLINE):
            err_msgs_list.append(
                common.getMsg(LANG, "power.supply.status.abnormal", (power_id, health_status, running_status)))
            LOGGER.logNoPass("Disk enclosure power supply [{}] is abnormal(health status: {}, running status: {})"
                             .format(power_id, health_status, running_status))
    return err_msgs_list


def get_control_enclosure_power_connect(inspect_context):
    inspect_context['devNode0'] = inspect_context.get('devInfo')
    redfish_conn = compute_storage_common.get_redfish_connection(inspect_context)
    return compute_storage_common.get_info_by_redfish_rest_conn(redfish_conn, POWER_QUERY_URL)
