# -*- coding: UTF-8 -*-

import cliUtil
import common
import config_1
from common_cache import get_product_model_with_cliret_cache
from common_cache import get_version_and_patch_cache

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env


def execute(cli):
    all_cli_ret = []
    try:
        # 获取设备型号
        flag, cli_ret, err_msg, product_model = \
            get_product_model_with_cliret_cache(PY_JAVA_ENV, cli, LOGGER)
        all_cli_ret.append(cli_ret)
        if flag is not True:
            return flag, "\n".join(all_cli_ret), err_msg

        # 获取设备版本和热补丁
        flag, p_version, p_patch, cli_ret, err_msg = \
            get_version_and_patch_cache(PY_JAVA_ENV, cli, LOGGER)
        all_cli_ret.append(cli_ret)
        if flag is not True:
            return flag, "\n".join(all_cli_ret), err_msg

        flag = check_result(product_model, p_version, p_patch)
        if flag:
            return True, "\n".join(all_cli_ret), ""
        err_msg = common.getMsg(LANG, "risk.controller.link.suggestion",
                                (product_model, p_version, p_patch))
        return cliUtil.RESULT_WARNING, "\n".join(all_cli_ret), err_msg

    except Exception, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret), common.getMsg(
            LANG, "query.result.abnormal")


def check_result(product_model, p_version, p_patch):
    """
    根据产品型号、系统软件版本、热补丁版本  得出结果
    :param product_model:
    :param p_version:
    :param p_patch:
    :return:
    """
    if product_model not in config_1.RISK_MODEL:
        return True
    if common.isDorado(product_model):
        if p_version >= "V300R002C20" or \
                p_version in config_1.RIGHT_VERSION_PATCH_D and \
                p_patch >= config_1.RIGHT_VERSION_PATCH_D[p_version]:
            return True
    else:
        if p_version >= "V500R007C50" or \
                p_version in config_1.RIGHT_VERSION_PATCH and \
                p_patch >= config_1.RIGHT_VERSION_PATCH[p_version]:
            return True
    return False
