# -*- coding: UTF-8 -*-
import cliUtil
import common
import hardware
from cbb.frame.base import baseUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
        机框状态检查：
                机框Health Status为Normal且Running Status为Online为正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show enclosure"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.enclosure.info")
            LOGGER.logNoPass("Cannot get information about enclosure")
            return (False, cliRet, errMsg)

        for line in cliRetLinesList:
            enclosureId = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            # 需要跳过残留框检查时，不是0号引擎上的框都不检查
            if is_exp_ctrl_skip(py_java_env)\
                    and not enclosureId.startswith("CTE0")\
                    and not enclosureId.startswith("DAE0"):
                continue
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "enclosure.health.status.abnormal", (enclosureId, healthStatus))
                LOGGER.logNoPass("The Health Status of enclosure [%s] is abnormal (Health Status:%s)" 
                     % (enclosureId, healthStatus))
            
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "enclosure.running.status.abnormal", (enclosureId, runningStatus))
                LOGGER.logNoPass("The Running Status of enclosure [%s] is abnormal (Running Status:%s)" 
                     % (enclosureId, runningStatus))

            if healthStatus != common.STATUS_NORMAL or runningStatus != common.STATUS_ONLINE:
                eLabel = hardware.getHardwareBomCode("Enclosure",cli,enclosureId)[1]
                if not eLabel or len(eLabel) == 0:
                    eLabel = 'Unknown'
                errMsg += common.getMsg(LANG, "hardware.bom.info", (enclosureId, eLabel))
                LOGGER.logNoPass("The Hardware ID [%s] BOMCode:%s" % (enclosureId, eLabel))
        
        if flag:
            LOGGER.logPass()
        
        cmd = "show enclosure|filterColumn include columnList=ID,SN"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] is True:
             cliRet += checkRet[1]
        
        return (flag, cliRet, errMsg)

    except Exception as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet,
                common.getMsg(LANG, "query.result.abnormal"))


def is_exp_ctrl_skip(py_java_env):
    """ 判断当前设备及场景下是否需要跳过残留框检查
        V5R7C60 Kunpeng/V6 6.0，存在扩控失败后残留新扩框和硬盘框的问题，需要跳过残留框
    :param py_java_env:
    :return:
    """
    pdt_model = str(py_java_env.get("devInfo").getDeviceType())
    pdt_version = str(py_java_env.get("devInfo").getProductVersion()).upper()
    # DoradoV6 6.0, V5R7C70 Kunpeng及之前版本,存在扩控回退后有残留框的场景，
    # 扩控评估需要跳过残留的控制框和硬盘框，只检查0号引擎上的框
    is_need_skip_dev = any([all([baseUtil.isDoradoV6Dev(pdt_model),
                                 pdt_version.startswith("6.0")]),
                            all([baseUtil.isArmDevV5New(pdt_model),
                                 "KUNPENG" in pdt_version,
                                 pdt_version.replace("KUNPENG", "").strip()
                                 <= "V500R007C70"])])
    if not is_need_skip_dev:
        return False

    # 是否是扩容场景巡检--扩容前评估--扩控评估
    scene_data = py_java_env.get("sceneData")
    if not scene_data:
        return False
    if all([scene_data.get("mainScene") == "Expansion",
            scene_data.get("toolScene") == "perInspector",
            any([scene_data.get("subScene") == "Expansion Controller",
                 py_java_env.get("expMode") == "EXTEND_CTRL"])]):
        return True
    return False
