# -*- coding: UTF-8 -*-
import cliUtil
import traceback
import common
from common import UnCheckException

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
allCliRet = ""

def execute(cli):

    '''
        成员盘空闲率检查 
        步骤2  执行命令：show enclosure，获取硬盘框信息，记录关键字” ID”所对应的硬盘框ID列表。
    '''
    try:
        #步骤2 检查设备硬盘框ID        
        (flag, errMsg) = checkEnclosureId(cli)
        return (flag, allCliRet, errMsg)

    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        if unCheckException.flag == False:
            return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)
        return (unCheckException.flag, unCheckException.cliRet, unCheckException.errorMsg)

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))

def checkEnclosureId(cli):
    '''
    @summary: 查询设备硬盘框ID列表
    @param cli: cli回显 

    @return: 
        Flag:
            True:硬盘框ID 无异常
            False: 硬盘框ID 含有EAD999
    '''
    global allCliRet

    cmd = "show enclosure"
    ENCLOSURE_ID = "ID"
    error_dae = {"DAE999", "999"}

    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        LOGGER.logInfo("Get the device enclosure info has same error.")
        raise UnCheckException(errMsg, allCliRet)

    dictList = cliUtil.getHorizontalCliRet(cliRet)
    if len(dictList) == 0:
        errMsg = common.getMsg(LANG, "query.result.abnormal")
        raise UnCheckException(errMsg, allCliRet)

    for diskEnclosureInfo in dictList:
        enclosureId = diskEnclosureInfo.get(ENCLOSURE_ID, "").strip()

        if enclosureId == "" or enclosureId == '--':
            LOGGER.logInfo("Get the device enclosure ID is Null.")
            errMsg = common.getMsg(LANG, "query.result.abnormal")
            raise UnCheckException(errMsg, allCliRet)

        if enclosureId in error_dae:
            LOGGER.logInfo(
                "Get the device has enclosure ID is %s." % enclosureId)
            return (False,
                    common.getMsg(LANG, "device.has.enclosureId.error",
                                  enclosureId))

    return (True, errMsg)
