# --*-- coding: utf-8 --*--

import common
import cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    cliRet = ""
    try:
        
        # 检查阵列是否为风险版本
        flag, cliRet, errMsg = checkVersion(cli)
        if flag != False:
            return (flag, cliRet, errMsg)
        
        # 获取FC信息
        flag, cliInfo, errMsg = getFcInfo(cli)
        cliRet = common.joinLines(cliRet, cliInfo)
        if flag != True:
            return (flag, cliRet, errMsg)
        
        # 获取Role为INI and TGT的port
        flag, iniAndTgtFcPortList, errMsg = getIniAndTgtFcPortID(cliInfo)
        if flag != True:
            return (flag, cliRet, errMsg)
        
        # 检查model是否存在为4 port SmartIO I/O Module或8x8G FC Optical Interface Module的port
        if iniAndTgtFcPortList:
            flag, cliInfo, errMsg = getSpecialModelFcPort(cli, iniAndTgtFcPortList)
            cliRet = common.joinLines(cliRet, cliInfo)
            return (flag, cliRet, errMsg)
        
        return (True, cliRet, "")
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
          
        
def getIniAndTgtFcPortID(cliRet):
    '''
    @summary: 获取Role（工作角色）为INI and TGT的port ID
    '''
    roleKey = "INI and TGT"
    
    iniAndTgtFcPortList = []

    cliRetDictList = cliUtil.getHorizontalCliRet(cliRet)
    for cliRetDict in cliRetDictList:
        #Role无法获取，不继续检查
        role = cliRetDict.get("Role")
        if role == None:
            errMsg = common.getMsg(LANG, "can.not.get.role")
            return (cliUtil.RESULT_NOCHECK, iniAndTgtFcPortList, errMsg)  # 修改备注：role无法获取就不继续检查，而不是不通过
        
        portId = cliRetDict.get("ID")
        if role == roleKey:
            iniAndTgtFcPortList.append(portId)
        
    return (True, iniAndTgtFcPortList, "")


def getFcInfo(cli):
    '''
    @执行命令show port general physical_type=FC，获取cli回显
    '''
    #获取命令回显
    cmd = 'show port general physical_type=FC'
    return cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    
    
def getSpecialModelFcPort(cli, iniAndTgtFcPortList):
    '''
    @执行命令show interface_module interface_module_id=ID，
                获取Model为4 port SmartIO I/O Module或8x8G FC Optical Interface Module的port
    '''
    
    cliRet = ""
    errMsg = ""
    flag = True
    cmdMould = "show interface_module interface_module_id=%s"
    bugModelTuple = ("4 port SmartIO I/O Module", "8x8G FC Optical Interface Module")
    
    # 接口卡与其model的关系字典
    interfaceAndModelDict = {}
    
    for portId in iniAndTgtFcPortList:
        # 获取接口卡ID，接口卡ID是portID的关系，如:CTE0.A.IOM1.P0 -> CTE0.A.IOM1
        interfaceId = ".".join(portId.split(".")[:-1])  
        
        # 如果该接口卡查询过一次，则直接获取其model,否者执行命令获取该接口卡的model
        if interfaceId in interfaceAndModelDict:
            model = interfaceAndModelDict.get(interfaceId)
        else:
            cmd = cmdMould % interfaceId
            execRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
            cliInfo = execRet[1]
            cliRet += "\n" + cliInfo
            # 命令执行出错，则直接退出（出现一次错误，后面的很可能也会出错）
            if execRet[0] != True:
                return execRet
            
            # 解析回显
            interfaceInfoDictList = cliUtil.getVerticalCliRet(cliInfo)
            for interfaceInfoDict in interfaceInfoDictList:
                model = interfaceInfoDict.get("Model")
                if model == None:
                    errMsg = common.getMsg(LANG, "can.not.get.port.interface.model", interfaceId)
                    return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)  # 修改备注：model无法获取就不继续检查，而不是不通过
                
                # 接口卡第一次处理，需要记录该接口卡的model
                interfaceAndModelDict[interfaceId] = model
            
        # 根据model确定是否需要上报
        if model in bugModelTuple:
            flag = cliUtil.RESULT_WARNING
            errMsg += common.getMsg(LANG, "ini.and.TGT.port.warning.model", (portId, model))
    
    return (flag, cliRet, errMsg)
            

def checkVersion(cli):
    """
    @summary: 检查阵列版本是否为风险版本
    @return: True:非问题版本；False:问题版本。
    """
    bugVersionDict = {"V300R005C00":"",
                      "V300R005C01":"",
                      "V300R005C00SPC300":"V300R005C00SPH302",
    }
    
    # 获取设备当前产品版本和补丁信息
    checkRet, currentVersionDictList, hotPatchVersionList = common.parse_upgradePackage(cli, LANG)
    cliRet = checkRet[1]
    if checkRet[0] != True:
        LOGGER.logSysAbnormal()
        return (cliUtil.RESULT_NOCHECK, cliRet, checkRet[2])
    
    flag, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
    if not flag:
        return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
    
    # 判断当前设备是否为风险版本
    if currentVersion not in bugVersionDict:
        return (True, cliRet, "")
    
    hotPatchVersion = bugVersionDict.get(currentVersion)
    if hotPatchVersion:
        flag, currentHotPatchVersion, errMsg = common.getHotPatchVersion(hotPatchVersionList, LANG)
        if not flag:
            return (cliUtil.RESULT_NOCHECK, cliRet, errMsg)
        if currentHotPatchVersion >= hotPatchVersion:
            return (True, cliRet, "")
    
    return (False, cliRet, "")