# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import cliUtil
import common

ONLINE_WWN = "online"
OFFLINE_WWN = "offline"

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """
    后台任务风险检查
    """
    check_host_initiator_redundancy = CheckItem(cli, LANG, LOGGER)
    return check_host_initiator_redundancy.execute()


class CheckItem:
    def __init__(self, cli, lang, logger):
        self.cli = cli
        self.lang = lang
        self.logger = logger
        self.cli_ret = list()

    @staticmethod
    def check_rule(initiator_info):
        not_pass_flag = False
        warning_flag = False
        not_redundant_host = []
        offline_host_initiator = []
        part_offline_host_initiator = []
        for host_id, host_initiator_dict in initiator_info.items():
            online_wwn_nmb = len(host_initiator_dict.get(ONLINE_WWN, []))
            offline_wwn_nmb = len(host_initiator_dict.get(OFFLINE_WWN, []))
            wwn_nmb = online_wwn_nmb + offline_wwn_nmb
            if 1 < online_wwn_nmb == wwn_nmb:
                continue
            if online_wwn_nmb == 1 and wwn_nmb == 1:
                warning_flag = True
                not_redundant_host.append(host_id)
            elif online_wwn_nmb == 1 and wwn_nmb > 1:
                not_pass_flag = True
                not_redundant_host.append(host_id)
            elif online_wwn_nmb == 0 and wwn_nmb == 1:
                not_pass_flag = True
                offline_host_initiator.append(host_id)
            elif offline_wwn_nmb == wwn_nmb:
                warning_flag = True
                offline_host_initiator.append(host_id)
            else:
                part_offline_host_initiator.append(host_id)
                warning_flag = True
        return [not_pass_flag, not_redundant_host, offline_host_initiator, part_offline_host_initiator, warning_flag]

    def execute(self):

        # 获取基本信息
        # 步骤2 执行命令：show initiator initiator_type=FC isfree=no，查询当前已经加入主机的FC启动器，获取启动器的在线情况和加入的主机ID；
        cmd = 'show initiator initiator_type=FC isfree=no'
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(self.cli, cmd, True, self.lang)
        self.cli_ret.append(cli_ret)
        # flag存在nocheck状态
        if flag is not True:
            return flag, "\n".join(self.cli_ret), err_msg
        initiators = cliUtil.getHorizontalCliRet(cli_ret)
        initiator_info = dict()
        for initiator in initiators:
            host_id = initiator.get("Host ID")
            status = initiator.get("Running Status")
            wwn = initiator.get("WWN")
            host_initiator_dict = initiator_info.setdefault(host_id, dict())
            if status == "Online":
                host_initiator_dict.setdefault(ONLINE_WWN, list()).append(wwn)
            else:
                host_initiator_dict.setdefault(OFFLINE_WWN, list()).append(wwn)
        flag, cli_ret, err_msg = self.check_initiator(initiator_info)
        return flag, cli_ret, err_msg

    def check_initiator(self, initiator_info):
        check_info_list = self.check_rule(initiator_info)
        not_pass_flag = check_info_list[0]
        not_redundant_host = check_info_list[1]
        offline_host_initiator = check_info_list[2]
        part_offline_host_initiator = check_info_list[3]
        warning_flag = check_info_list[4]

        err_msg_list = []
        self.build_err_msg(err_msg_list, offline_host_initiator, "offline_host_initiator")
        self.build_err_msg(err_msg_list, not_redundant_host, "not_redundant_host")
        self.build_err_msg(err_msg_list, part_offline_host_initiator, "part_offline_host_initiator")
        if not_pass_flag:
            return False, "\n".join(self.cli_ret), "\n".join(err_msg_list)
        if warning_flag:
            return cliUtil.RESULT_WARNING, "\n".join(self.cli_ret), "\n".join(err_msg_list)
        return True, "\n".join(self.cli_ret), ""

    def build_err_msg(self, err_msg_list, err_host_list, err_msg_key):
        """
        构建错误信息
        :param err_msg_list: 错误信息列表
        :param err_host_list: 问题主机列表
        :param err_msg_key: 错误消息key
        :return: 错误信息列表
        """
        if err_host_list:
            err_msg_list.append(common.getMsg(self.lang, err_msg_key, ",".join(set(err_host_list))))
