# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2012-. All rights reserved.

import os

import cliUtil
import common

from frameone.util import common as frame_common
from cbb.frame.base.config import NEW_DORADO
from cbb.frame.cli.cliUtil import get_performance_layer_id_and_engine_dict

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)

# 进度总剩余时间
LIMIT_TIME_SECS = 120
# 进度刷新间隔
INTERVAL_SECS = 2
# 性能层最小盘数
MIN_DISK_NUM = 16


@frame_common.fakeProgress(
    py_java_env, totalSeconds=LIMIT_TIME_SECS,
    logger=logger, interval=INTERVAL_SECS)
def execute(cli):
    """扩容评估内双活扩控检查
    检查项ID：check_item_hypermetro_inner_controller_expansion

    :param cli: cli连接
    :return:
    """

    cli_ret_all = []

    try:
        # 获取OMRP中规定的CLI命令回显 展示在详细信息中
        cli_ret_all += get_cli_ret(cli)

        # 获取存储池和硬盘域对应关系 不存在则返回不涉及
        pool_and_disk_domain_map = common.getpoolAndDiskDomainMap(py_java_env)
        logger.logInfo(
            "pool_and_disk_domain_map is %s" % pool_and_disk_domain_map)

        is_hypermetro_inner = \
            py_java_env.get("expInfo").isHasInnerMetroLicense()
        # 不是内双活返回不涉及
        if not is_hypermetro_inner:
            return cliUtil.RESULT_NOSUPPORT, "".join(cli_ret_all), ""

        dev_ctrl_num = int(py_java_env.get("expInfo").getDevCtrlsNum())
        exp_ctrl_num = int(py_java_env.get("expInfo").getExpCtrlsNum())
        # 不是4扩8或者不是2扩8场景返回不涉及
        if (dev_ctrl_num, exp_ctrl_num) not in [(4, 8), (2, 8)]:
            return cliUtil.RESULT_NOSUPPORT, "".join(cli_ret_all), ""

        # 新融合内双活扩控检查
        product_model = str(py_java_env.get("devInfo").getDeviceType())
        if product_model in NEW_DORADO:
            return check_new_dorado_exp(cli, cli_ret_all, pool_and_disk_domain_map, product_model)

        if not pool_and_disk_domain_map:
            logger.logSysAbnormal()
            return cliUtil.RESULT_NOSUPPORT, "\n".join(cli_ret_all), ""

        err_msg_list, flag = check_inner_ctrl_exp(cli_ret_all, pool_and_disk_domain_map)
        return flag, "\n".join(cli_ret_all), "".join(err_msg_list)

    except Exception as e:
        logger.logException(e)
        err_msg = common.getMsg(lang, "query.result.abnormal")
        return cliUtil.RESULT_NOCHECK, "".join(cli_ret_all), err_msg


def check_new_dorado_exp(cli, cli_ret_all, pool_and_disk_domain_map, product_model):
    """
    除18500K外，其他新融合内双活扩控只检查性能层的盘数
    """
    flag, err_msg, ret = exp_evaluate_for_performance_layer(cli)
    cli_ret_all.append(ret)
    if product_model != 'OceanStor 18500K' or not query_disks_for_pool(cli, pool_and_disk_domain_map):
        return flag, "\n".join(cli_ret_all), "".join(err_msg)

    # 18500K需要补充执行硬盘域扩容评估，并拼接结果返回
    inner_err_msg, inner_flag = check_inner_ctrl_exp(cli_ret_all, pool_and_disk_domain_map)
    err_msg.extend(inner_err_msg)

    return flag and inner_flag, "\n".join(cli_ret_all), "".join(err_msg)


def query_disks_for_pool(cli, pool_and_disk_domain_map):
    disk_list = []
    if not pool_and_disk_domain_map:
        return disk_list
    for domain_id in pool_and_disk_domain_map.values():
        cmd = "show disk in_domain disk_domain_id={}".format(domain_id)
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        disk_list.extend(cliUtil.getHorizontalCliRet(cli_ret))
    return disk_list


def check_inner_ctrl_exp(cli_ret_all, pool_and_disk_domain_map):
    err_msg_list = []
    flag = True
    for pool_id in pool_and_disk_domain_map:
        disk_domain_id = pool_and_disk_domain_map.get(pool_id)
        evaluate_param = {}
        evaluate_param["poolId"] = pool_id
        evaluate_param["diskDomainId"] = disk_domain_id
        rest_flag, rest_msg, ret = \
            common.exp_evaluate_by_rest(
                py_java_env, evaluate_param, logger)
        cli_ret_all.append(ret)
        if not rest_flag:
            flag = False
            err_msg_list += rest_msg
            err_msg_list.append(os.linesep)
    return err_msg_list, flag


def exp_evaluate_for_performance_layer(cli):
    """
        性能层扩容评估
        :param cli: cli
        :return:
        """
    exp_performance_layer_evaluate_param = {}
    default_list = ['0']
    exp_performance_layer_evaluate_param["diskNumList"] = default_list
    exp_performance_layer_evaluate_param["diskCapacityList"] = default_list
    performance_layer_id_and_engine_dict = \
        get_performance_layer_id_and_engine_dict(cli, lang)
    if not performance_layer_id_and_engine_dict:
        return cliUtil.RESULT_NOSUPPORT, [], ""
    for performance_layer_id, engine_list in performance_layer_id_and_engine_dict.items():
        exp_performance_layer_evaluate_param["id"] = performance_layer_id
        exp_performance_layer_evaluate_param["engineIdList"] = engine_list

    return common.exp_performance_layer_evaluate_by_rest(
        py_java_env, exp_performance_layer_evaluate_param, logger)


def get_cli_ret(cli):
    """获取OMRP中规定的CLI命令回显 展示在详细信息中

    :param cli:
    :return:
    """
    cli_ret_all = []

    cmd = "show system general"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cli_ret_all.append(cli_ret)

    cmd = "show license"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cli_ret_all.append(cli_ret)

    cmd = "show disk_domain general"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    cli_ret_all.append(cli_ret)

    return cli_ret_all
