# -*- coding: UTF-8 -*-
import re
import time
import datetime
import traceback

from com.huawei.ism.exception import IsmException
from com.huawei.ism.tool.obase.exception import ToolException
from cbb.frame.adapter.replace_adapter import compare_version

import common
import config
import cliUtil


PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)

EXPIRE_TIME = "Expire Time"
CA_EXPIRE_TIME = "CA Expire Time"
CERT_TYPE = "Type"
NOT_SUPPORT_CERTIFICATE = "enter a correct parameter"


def execute(cli):
    conn = ''
    all_cli_ret = []
    try:
        # 如果是18000执行debug命令获取阵列链接
        flag, conn, err_msg = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER, LANG)
        if not flag:
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret), err_msg
        # 获取系统时间，校验系统时间格式
        (flag, sys_date, err_msg) = get_system_date_with_cli_ret(conn, all_cli_ret)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret), err_msg
        if not check_is_regular_time(sys_date):
            err_msg = common.getMsg(LANG, "cannot.get.system.time.info")
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret), err_msg
        LOGGER.logInfo("Get system date is {}".format(sys_date))
        # 获取证书信息
        (flag, certificate_info_dictList, err_msg) = get_cert_info(conn, all_cli_ret)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret), err_msg
        LOGGER.logInfo("Get certificate expire time certificateInfoDictList:{}".format(certificate_info_dictList))
        # 校验证书过期时间
        return check_cert_expire(sys_date, certificate_info_dictList, all_cli_ret)

    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return cliUtil.RESULT_NOCHECK, "\n".join(all_cli_ret), common.getMsg(LANG, "query.result.abnormal")
    finally:
        if conn is not cli and common.is18000(PY_JAVA_ENV, cli):
            common.closeConnection(conn, PY_JAVA_ENV, LOGGER)
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def get_system_date_with_cli_ret(cli, all_cli_ret):
    # 获取系统时间
    cmd = "show system general"
    (flag, cli_ret, err_msg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret.append(cli_ret)
    if flag != True:
        return flag, "", err_msg
    cli_ret_dict_list = cliUtil.getVerticalCliRet(cli_ret)
    if len(cli_ret_dict_list) == 0:
        return cliUtil.RESULT_NOCHECK, "", common.getMsg(LANG, "cannot.get.system.time.info")
    cli_ret_dict = cli_ret_dict_list[0]
    sys_time = cli_ret_dict.get("Time")
    reg_date = re.compile("\d{4,}\-\d{1,2}\-\d{1,2}")
    match_date = reg_date.match(sys_time)
    if match_date:
        return True, str(match_date.group()), ""
    return False, "", common.getMsg(LANG, "cannot.get.system.time.info")


def get_cert_info(cli, all_cli_ret):
    # 判断系统版本，决定是否要获取"CA Expire Time"字段
    cert_info_dict_list = []
    (check_flag, check_result, err_msg) = check_is_get_ca_expire_time(cli, all_cli_ret)
    if check_flag is not True:
        return False, cert_info_dict_list, err_msg
    try:
        cmd = "show certificate general type="
        cli_ret = cli.execCmd(cmd)
        all_cli_ret.append(cli_ret)
    except IsmException:
        #出现异常时，由框架上层处理
        LOGGER.logError(str(traceback.format_exc()))
        raise
    regx = re.compile(r"type=([^?\s]\S+)")
    need_check_cert_list = regx.findall(cli_ret)
    LOGGER.logInfo("need check certificates list:{}".format(need_check_cert_list))
    # 生成证书字典列表
    for cert_type in need_check_cert_list:
        cert_info_dict = {CERT_TYPE: cert_type}
        if check_result:
            LOGGER.logInfo("Start get Expire Time,CA Expire Time")
            (flag, ca_time, err_msg) = get_ca_expire_time_and_expire_time(cli, cert_type, all_cli_ret)
            if flag is not True:
                LOGGER.logInfo("Get {} CA time failed".format(cert_type))
                return flag, cert_info_dict_list, err_msg
            if ca_time:
                cert_info_dict[CA_EXPIRE_TIME] = ca_time[0]
                cert_info_dict[EXPIRE_TIME] = ca_time[1]
                cert_info_dict_list.append(cert_info_dict)
        else:
            LOGGER.logInfo("Start get lower system product:Expire Time")
            (flag, expire_time, err_msg) = get_expire_time(cli, cert_type, all_cli_ret)
            if flag is not True:
                LOGGER.logInfo("Get {} CA time failed".format(cert_type))
                return flag, cert_info_dict_list, err_msg
            if expire_time:
                cert_info_dict[EXPIRE_TIME] = expire_time
                cert_info_dict_list.append(cert_info_dict)
    return True, cert_info_dict_list, ""


def check_is_get_ca_expire_time(cli, all_cli_ret):
    check_result = False
    product_model = str(common.getProductModeFromContext(PY_JAVA_ENV))
    LOGGER.logInfo("Get product model from context:{}".format(product_model))
    # 获取设备当前产品版本
    check_ret, cur_product_version_dict_list, _ = common.parse_upgradePackage(cli, LANG)
    all_cli_ret.append(str(check_ret[1]))
    if check_ret[0] is not True:
        LOGGER.logSysAbnormal()
        return check_ret[0], check_result, check_ret[2]
    result, cur_product_version, err_msg = common.getCurrentVersion(cur_product_version_dict_list, LANG)
    if not result:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, err_msg
    LOGGER.logInfo("Get product version :[{}] ".format(cur_product_version))
    if product_model in config.DORADO_DEVS or product_model == "Dorado NAS":
        if cur_product_version >= "V300R002C00":
            check_result = True
        if "." in cur_product_version and cur_product_version >= "6.0":
            check_result = True
        if "OceanProtect" in product_model and compare_version(cur_product_version, "1.2.RC1") < 0:
            check_result = True
        if "Micro" in product_model:
            check_result = True
    else:
        if cur_product_version.startswith("V3") and cur_product_version >= "V300R006C30":
            check_result = True
        if cur_product_version.startswith("V5") and cur_product_version >= "V500R007C20":
            check_result = True
    return True, check_result, ""


def get_ca_expire_time_and_expire_time(cli, cert_type, all_cli_ret):
    expire_time_list = []
    ca_expire_time_list = []
    LOGGER.logInfo("get {} CA expire time and expire time".format(cert_type))
    cmd = "show certificate general type={} detail=yes".format(cert_type)
    check_ret = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if not check_is_need_deal_ret(check_ret):
        all_cli_ret.append(check_ret[1])
        LOGGER.logInfo("cli {} not support".format(cmd))
        return (True, "", "")
    all_cli_ret.append(check_ret[1])
    if check_ret[0] is not True:
        LOGGER.logSysAbnormal()
        return (check_ret[0], "", check_ret[2])
    cli_ret_dict_list = cliUtil.getVerticalCliRet(check_ret[1])
    if len(cli_ret_dict_list) == 0:
        return (cliUtil.RESULT_NOCHECK, "", common.getMsg(LANG, "get.CA.expire.time.failed"))
    for cli_ret_dict in cli_ret_dict_list:
        expire_time_list.append(cli_ret_dict.get(EXPIRE_TIME, ""))
        ca_expire_time_list.append(cli_ret_dict.get(CA_EXPIRE_TIME, ""))
    return (True, (deal_time_list_get_min_data(ca_expire_time_list), deal_time_list_get_min_data(expire_time_list)), "")


def get_expire_time(cli, cert_type, all_cli_ret):
    LOGGER.logInfo("get {} expire time".format(cert_type))
    cmd = "show certificate general type={}".format(cert_type)
    check_ret = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if not check_is_need_deal_ret(check_ret):
        all_cli_ret.append(check_ret[1])
        LOGGER.logInfo("cli {} not support".format(cmd))
        return (True, "", "")
    all_cli_ret.append(check_ret[1])
    if check_ret[0] != True:
        LOGGER.logSysAbnormal()
        return (check_ret[0], "", check_ret[2])
    cli_ret_dict_list = cliUtil.getHorizontalCliRet(check_ret[1])
    if len(cli_ret_dict_list) == 0:
        return (cliUtil.RESULT_NOCHECK, "", common.getMsg(LANG, "get.CA.expire.time.failed"))
    return (True, cli_ret_dict_list[0].get(EXPIRE_TIME, ""), "")


def check_is_need_deal_ret(check_ret):
    if NOT_SUPPORT_CERTIFICATE in check_ret[1].lower() or "^" in check_ret[1]:
        return False
    return True


def deal_time_list_get_min_data(need_deal_list):
    # 处理时间列表，获取最早过期时间（时间列表中的最小值）
    need_deal_list = list(set(need_deal_list))
    if "--" in need_deal_list and len(need_deal_list) != 1:
        need_deal_list.remove("--")
    return min(need_deal_list)


def cal_time(current_time, expire_time):
    """
    计算两个日期（格式必须为%Y-%m-%d）相差多少天，会忽略时间。
    @param current_time:系统当前时间
    @param expire_time:证书过期时间
    @return:相差天数
    """
    try:
        current_time = time.strptime(current_time, "%Y-%m-%d")
        expire_time = time.strptime(expire_time, "%Y-%m-%d")
        current_time = datetime.datetime(current_time[0], current_time[1], current_time[2])
        expire_time = datetime.datetime(expire_time[0], expire_time[1], expire_time[2])
        # 返回两个变量相差的值，就是相差天数
        return True, (expire_time - current_time).days
    except:
        LOGGER.logInfo("parse date failed.")
        return False, ""


def check_cert_expire(sys_time, cert_info_dicts, all_cli_ret):
    err_msg = ""
    check_result_set = set()
    for cert_info_dict in cert_info_dicts:
        if len(cert_info_dict) == 3:
            # 获取 Expire Time,CA Expire Time这两个时间与当前系统时间的差值
            ca_expire_time_flag = False
            expire_time_flag = False
            expire_time = cert_info_dict.get(EXPIRE_TIME)
            ca_expire_time = cert_info_dict.get(CA_EXPIRE_TIME)
            if check_is_regular_time(expire_time):
                expire_time_flag, expire_time_dif_days = cal_time(sys_time, expire_time)
                LOGGER.logInfo(
                    "type:{},  expire_time_dif_days:{}.".format(cert_info_dict.get(CERT_TYPE), expire_time_dif_days))
            if check_is_regular_time(ca_expire_time):
                ca_expire_time_flag, ca_expire_time_dif_days = cal_time(sys_time, ca_expire_time)
                LOGGER.logInfo(
                    "type:{}, ca_expire_time_dif_days:{}.".format(cert_info_dict.get(CERT_TYPE),
                                                                  ca_expire_time_dif_days))
        if len(cert_info_dict) == 2:
            # 获取 Expire Time时间与当前系统时间的差值
            ca_expire_time_flag = False
            expire_time_flag = False
            expire_time = cert_info_dict.get(EXPIRE_TIME)
            if check_is_regular_time(expire_time):
                expire_time_flag, expire_time_dif_days = cal_time(sys_time, expire_time)
                LOGGER.logInfo(
                    "type:{},  expire_time_dif_days:{}.".format(cert_info_dict.get(CERT_TYPE), expire_time_dif_days))

        cert_expire_flag = True
        if expire_time_flag:
            cert_expire_flag = check_expire_days(expire_time_dif_days)
        cert_ca_expire_flag = True
        if ca_expire_time_flag:
            cert_ca_expire_flag = check_expire_days(ca_expire_time_dif_days)

        if cert_ca_expire_flag is not True and cert_expire_flag is not True:
            err_msg += common.getMsg(LANG, "check.cert.expire.no.pass",
                                     (cert_info_dict.get(CERT_TYPE), expire_time, ca_expire_time))
            check_result_set.add(cert_expire_flag)
            check_result_set.add(cert_ca_expire_flag)
        elif cert_ca_expire_flag is not True:
            err_msg += common.getMsg(LANG, "check.cert.expire.no.pass.only.ca.cert.expire",
                                     (cert_info_dict.get(CERT_TYPE), ca_expire_time))
            check_result_set.add(cert_ca_expire_flag)
        elif cert_expire_flag is not True:
            err_msg += common.getMsg(LANG, "check.cert.expire.no.pass.only.cert.expire",
                                     (cert_info_dict.get(CERT_TYPE), expire_time))
            check_result_set.add(cert_expire_flag)

    if False in check_result_set:
        return False, "\n".join(all_cli_ret), err_msg
    if cliUtil.RESULT_WARNING in check_result_set:
        return cliUtil.RESULT_WARNING, "\n".join(all_cli_ret), err_msg
    return True, "\n".join(all_cli_ret), ""


def check_expire_days(expire_time_dif_days):
    """
    180<expire_time_dif_days<356 为建议优化
    expire_time_dif_days<180 为不通过

    @param expire_time_dif_days: 差异天数
    @return: 结果
    """
    if expire_time_dif_days >= 365:
        return True
    if expire_time_dif_days > 180:
        return cliUtil.RESULT_WARNING
    return False


def check_is_regular_time(time_str):
    # 校验是否是合法的日期
    try:
        if time_str == "--":
            return False
        time.strptime(time_str, "%Y-%m-%d")
        return True
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return False
