# -*- coding: UTF-8 -*-
import common
from cbb.frame.cli import cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

DORADO_RISK_VERSION = {'V300R002C00': '',
                       'V300R002C10SPC100': 'V300R002C10SPH105',
                       'V300R002C00SPC100': ''}


def execute(cli):
    """
    检查克隆ID是否小于源LUN ID,buglist 2020,02,29新增
    :param cli:
    :return:
    """
    # 获取克隆lun id大于lunid的列表，若有，则继续，否则通过
    cli_ret = ""
    try:
        flag, soft_version, patch_version, cli_ret_version, err_msg = \
            common.get_soft_and_patch_version(cli, LOGGER, LANG)
        cli_ret += cli_ret_version
        if flag is not True:
            return flag, cli_ret, err_msg
            # 如果型号或版本不存在风险
        if soft_version not in DORADO_RISK_VERSION:
            LOGGER.logInfo("Not in risky version.")
            return flag, cli_ret, err_msg

        least_patch_ver = DORADO_RISK_VERSION.get(soft_version)
        # 风险版本已安装对应版本热补丁, 则检查通过
        if patch_version and least_patch_ver and \
                patch_version >= least_patch_ver:
            LOGGER.logInfo("Corresponding patch installed.")
            return True, cli_ret, err_msg

        flag, cli_ret_meg, err_msg, clone_lun_meg = get_clone_lun_too_large(
            cli)
        cli_ret = common.joinLines(cli_ret, cli_ret_meg)
        if flag is not True:
            return flag, cli_ret, err_msg
        if not clone_lun_meg:
            LOGGER.logInfo("The storage has no clone id smaller than source.")
            return flag, cli_ret, err_msg

        # 构造错误信息
        err_msg += clone_lun_meg
        return False, cli_ret, err_msg
    except Exception as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, cli_ret, common.getMsg(
            LANG, "query.result.abnormal")


def get_clone_lun_too_large(cli):
    """
    获取克隆lun id大于lunid的列表
    :param cli:
    :return:
    """
    clone_lun_meg = ""
    cmd = "show lun_clone general"
    LOGGER.logExecCmd(cmd)
    flag, cliRet, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    # 如果license不存在，则不涉
    if flag == cliUtil.RESULT_NOSUPPORT:
        LOGGER.logInfo("license get failed")
        return True, cliRet, err_msg, clone_lun_meg
    if flag is not True:
        LOGGER.logSysAbnormal()
        err_msg += common.getMsg(LANG, "query.result.abnormal")
        return cliUtil.RESULT_NOCHECK, cliRet, err_msg, clone_lun_meg
    # 如果Command executed successfully 直接报通过
    if cliUtil.queryResultWithNoRecord(cliRet):
        return True, cliRet, err_msg, clone_lun_meg
    cli_ret_lines_list = cliUtil.getHorizontalNostandardCliRet(cliRet)
    for line in cli_ret_lines_list:
        source_id = line.get("Source ID", "")
        clone_lun_id = line.get("ID", "")
        if not source_id or not clone_lun_id:
            err_msg += common.getMsg(LANG, "query.result.abnormal")
            return cliUtil.RESULT_NOCHECK, cliRet, err_msg, clone_lun_meg
        if int(source_id) > int(clone_lun_id):
            clone_lun_meg += common.getMsg(LANG, "clone_id_less.meg",
                                           (clone_lun_id, source_id))
    return True, cliRet, err_msg, clone_lun_meg
