# -*- coding: UTF-8 -*-

import copy
import re

import common
import cliUtil
from cbb.frame.cli import cliUtil as cbbCliUtil
from cbb.frame.adapter.replace_adapter import compare_version
from container_base_check import ContainerCheck

PY_JAVA_ENV = py_java_env
LOGGER = common.getLogger(PY_LOGGER, __file__)
LANG = common.getLang(PY_JAVA_ENV)

CHECK_V2_URL_LIST = ["alarms?pageSize=10&pageNo=0&language={}&shouldAllNodes=false".format(LANG.upper())]
CHECK_V1_URL_LIST = ["inspections/alarms?lang={}".format(LANG)]
CONTAINER_CMD = "show container_application general name=dataprotect namespace=dpa"
DIVIDING_REVISION = "1.5.RC1"


def execute(cli):
    """
    数据保护告警信息检查
    """
    result, msg = common.is_support_data_protect_check(PY_JAVA_ENV, cli)
    if msg:
        return cliUtil.RESULT_NOCHECK, "", msg
    if not result:
        return cliUtil.RESULT_NOSUPPORT, "", ""
    dev_node = PY_JAVA_ENV.get("devInfo")
    flag, ips_dict = common.is_need_change_devnode_ip(cli, LOGGER, LANG)
    if flag:
        temp_dev_node = copy.deepcopy(dev_node)
        temp_dev_node.setIp(ips_dict.get("0")[0])
        flag, item_check, msg = _container_check(temp_dev_node, cli)
        ret = deal_unicode("\n".join(item_check.all_cli_ret))
        return flag, ret, msg
    flag, item_check, msg = _container_check(dev_node, cli)
    ret = deal_unicode("\n".join(item_check.all_cli_ret))
    return flag, ret, msg


def deal_unicode(ret):
    try:
        return unicode(ret).decode("unicode-escape")
    except UnicodeEncodeError:
        return ret


def _container_check(dev_node, cli):
    # 如果容器应用版本在1.5.RC1之前，则使用V1的接口, 否则使用V2接口
    revision = get_container_version(cli)
    LOGGER.info("the container revision is {}".format(revision))
    if compare_version(revision, DIVIDING_REVISION) < 0:
        return _container_v1_check(dev_node)
    return _container_v2_check(dev_node)


def _container_v1_check(dev_node):
    item_check = ContainerCheck(dev_node, CHECK_V1_URL_LIST, LANG, LOGGER)
    flag, msg = item_check.execute_check()
    return flag, item_check, msg


def _container_v2_check(dev_node):
    item_check = ContainerCheck(dev_node, CHECK_V2_URL_LIST, LANG, LOGGER)
    flag, msg = item_check.execute_check_alarm_status()
    return flag, item_check, msg


def get_container_version(cli):
    flag, cli_ret, err_msg = cbbCliUtil.execCmdInCliMode(cli, CONTAINER_CMD, False, LANG)
    if not flag:
        return DIVIDING_REVISION
    return re.search(r"Revision\s*:\s*(\S+)", cli_ret).group(1)