# -*- coding: UTF-8 -*-
from memory_inspect.check_item.timed_check_item_base import TimedLogBaseCheckItem
from memory_inspect.parser.ses_log_parser import SesLogParser
from memory_inspect.rule.ses_module_rule import ExpSesRule
from memory_inspect.utils.constants import CheckResult

ITEM_ID = "SesModuleCheck"


def execute(cli):
    return SesModuleCheck(py_java_env, PY_LOGGER, cli).execute()


class SesModuleCheck(TimedLogBaseCheckItem):
    def do_check(self):
        self.parse_log_files()
        return self.run_rules()

    def parse_log_files(self):
        collected_files = self.context.get("collected_files") or {}
        parser = SesLogParser(self.logger)
        for ctrl, one_ctrl_files in collected_files.items():
            self._update_last_err_time(ctrl)
            ses_log_files = one_ctrl_files.get("ses_log", [])
            parse_data_list = parser.parse(ctrl, ses_log_files)
            filter_data = []
            for data in parse_data_list:
                if data.get("time") <= self.last_err_time:
                    continue
                data.update(dict(sn=self.sn, ctrl=ctrl, item_id=ITEM_ID))
                filter_data.append(data)
            if filter_data:
                self.db_service.log_err_tbl.save_log_error_data(filter_data)

    def run_rules(self):
        rule_obj = ExpSesRule(self._get_rule_context())
        status = rule_obj.execute()
        origin_info = rule_obj.origin_info
        if status:
            return CheckResult.NOT_PASS, origin_info, "\n".join(rule_obj.err_msg)
        return CheckResult.PASS, origin_info, ""

    def _update_last_err_time(self, ctrl):
        last_err_time = self.db_service.log_err_tbl.get_latest_err_time_from_db(self.sn, ctrl, ITEM_ID)
        self.logger.info("ctrl:{}, _update_last_err_time: {}".format(
            ctrl, last_err_time)
        )
        if last_err_time:
            self.last_err_time = last_err_time
