# -*- coding: UTF-8 -*-
import common

from cbb.business.operate.expansion import common as exp_common
from cbb.frame.context import contextUtil
from cbb.business.operate.expansion.scm import check_expand_scm

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)
context = contextUtil.getContext(py_java_env)


def execute(cli):
    """
    智能缓存池扩引擎检查
    :param cli:cli
    :return:
    """
    free_disk_dict = py_java_env.get("scmExpInfo")
    if not free_disk_dict:
        return False, "", \
               exp_common.getMsg(lang, "smart.cache.pool.not.pass")
    free_disk_list = free_disk_dict.get("disk_location").split(",")
    # 持久化配置数据
    exp_common.save_expansion_config_data(free_disk_dict,
                                          logger,
                                          "expansionSCM.dat")

    return check_expand_scm.execute(cli, lang, logger, context,
                                    free_disk_list=free_disk_list)
