# -*- coding: UTF-8 -*-
import common
from cbb.frame.cli import cliUtil
from cbb.frame.base import baseUtil
import cliUtil as cliUtils
from com.huawei.ism.tool.obase.exception import ToolException

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''
FILE_ERR_MEG = ''
NOT_CHECK = False
NODE_ID_AND_CONTROLLER_MAP = {}

FILE_TYPE_LIST = ['-', 'd', 'b', 'c', 'l', 'p', 's']

DIR_LIST_CHECK_MARK = ['/OSM/log/pangea/BMC/',
                       '/OSM/log/pangea/BMC/tmp/BMCLOG/local/',
                       '/OSM/log/pangea/BMC/tmp/BMCLOG/smma/',
                       '/OSM/log/pangea/BMC/tmp/BMCLOG/smmb/']
LS_L = 'ls -l '
# 进度总剩余时间
LIMIT_TIME = 120
# 进度刷新间隔
INTERVAL = 2


def execute(cli):
    """
    BMC日志异常检查
    :param cli:
    :return:
    """
    global ALL_CLI_RET, FILE_ERR_MEG, NOT_CHECK
    conn_cli = ""
    try:
        flag, soft_version, _, cli_ret_version, err_msg = \
        common.get_soft_and_patch_version(cli, LOGGER, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET,
                                       cli_ret_version)
        # 进度条刷新
        common.threadUpProcess(PY_JAVA_ENV, LIMIT_TIME, INTERVAL, LOGGER)
        # 进度开始
        common.inProcess(PY_JAVA_ENV)
        if flag is not True:
            return flag, ALL_CLI_RET, err_msg
        if not (soft_version < 'V300R006C61' or (
                'V5' in soft_version and soft_version < 'V500R007C60') or (
                        'V3' in soft_version and baseUtil.isDoradoDev(
                    soft_version))):
            return True, ALL_CLI_RET, err_msg

        flag, cli_ret_engine, err_msg = get_engine_type(cli)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET,
                                       cli_ret_engine)
        if flag is not False:
            return flag, ALL_CLI_RET, err_msg



        # 如果是18000执行debug命令获取阵列链接
        create_ret = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER,
                                                       LANG)
        if create_ret[0] is not True:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, create_ret[2]
        conn_cli = create_ret[1]

        flag = build_controller_name(cli, LANG)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(
                LANG, "query.result.abnormal")

        check_bmc_log_execption(conn_cli, PY_JAVA_ENV, LOGGER, LANG, "")
        LOGGER.logInfo("BMC end of heartbeat")
        if NOT_CHECK is True:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, FILE_ERR_MEG
        if FILE_ERR_MEG:
            return False, ALL_CLI_RET, FILE_ERR_MEG
        return True, ALL_CLI_RET, FILE_ERR_MEG
    except common.UnCheckException as uncheck:
        LOGGER.logError(
            "Failed to heart beat :%s" % str(uncheck.errorMsg))
        return (
            cliUtil.RESULT_NOCHECK, ALL_CLI_RET,
            uncheck.errorMsg)
    except (ToolException, Exception) as exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(
            LANG, "query.result.abnormal")
    finally:
        if conn_cli != "":
            if common.is18000(PY_JAVA_ENV, conn_cli) and conn_cli is not cli:
                common.closeConnection(conn_cli, PY_JAVA_ENV, LOGGER)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
        common.finishProcess(PY_JAVA_ENV)
        LOGGER.logInfo("finish process!")



def get_engine_type(cli):
    """
    获取引擎信息，并且判断是否包含2U设备，如果有，则通过
    :param cli:
    :return:
    """
    cmd = "show enclosure"
    LOGGER.logExecCmd(cmd)
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if flag is not True:
        LOGGER.logSysAbnormal()
        LOGGER.logError("Failed to get engine information")
        return cliUtil.RESULT_NOCHECK, cli_ret, err_msg

    cliRetLinesList = cliUtil.getHorizontalCliRet(cli_ret)

    if len(cliRetLinesList) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.enclosure.info")
        LOGGER.logNoPass("Cannot get information about enclosure")
        return cliUtil.RESULT_NOCHECK, cli_ret, errMsg

    for line in cliRetLinesList:
        logic_type = line.get("Logic Type", "")
        type = line.get("Type", "")
        if logic_type == 'Engine'and '2U' in type:
            return True, cli_ret, err_msg

    return False, cli_ret, err_msg,


@common.checkAllEngineInClusterWarp
def check_bmc_log_execption(cli, PY_JAVA_ENV, LOGGER, LANG,
                            heart_beat_cli_ret):
    """
    轮询引擎进行检查
    :param cli:
    :param PY_JAVA_ENV:
    :param LOGGER:
    :param LANG:
    :param heart_beat_cli_ret:
    :return:
    """
    global ALL_CLI_RET, FILE_ERR_MEG, NODE_ID_AND_CONTROLLER_MAP, NOT_CHECK
    # 获取当前引擎控制器信息
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET,
                                   heart_beat_cli_ret)
    flag, err_msg, cli_ret, current_ctrl, engine_ctrl_mapping_dict, \
    current_engine, node_num = \
        common.getEngineCtrlNodeInfo(cli, LOGGER, LANG)
    LOGGER.logInfo("current_ctrl id is:%s" % current_ctrl)

    current_controller = NODE_ID_AND_CONTROLLER_MAP.get(current_ctrl, "--")
    LOGGER.logInfo("current_controller id is:%s" % current_controller)

    cmd = "ls -l /OSM/coffer_log/log_secondary/cur_debug/pangea/BMC"

    flag, cliRet, errMsg = cliUtils.excute_cmd_in_minisystem_with_check(cli,
                                                                        cmd,
                                                                        LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag is not True:
        FILE_ERR_MEG = common.joinLines(FILE_ERR_MEG, errMsg)
        NOT_CHECK = True
        return common.CHECK_FLAG_NOT_CONTINUE
    null_file, has_p_start, has_question_mark = check_file_is_exption(cliRet)
    if null_file:
        LOGGER.logInfo("/OSM/coffer_log/log_secondary/cur_debug/"
                       "pangea/BMC Is an empty file")
        return common.CHECK_FLAG_CONTINUE
    if has_question_mark:
        FILE_ERR_MEG = \
            common.joinLines(FILE_ERR_MEG,
                             common.getMsg(LANG, "bmc.log.meg",
                                           (current_controller,
                                            "/OSM/coffer_log"
                                            "/log_secondary/"
                                            "cur_debug"
                                            "/pangea/BMC")))
        LOGGER.logInfo("/OSM/coffer_log/log_secondary/cur_debug/ has ?")
        LOGGER.logInfo(common.getMsg(LANG, "bmc.log.meg",
                                           (current_controller,
                                            "/OSM/coffer_log"
                                            "/log_secondary/"
                                            "cur_debug"
                                            "/pangea/BMC")))
        return common.CHECK_FLAG_CONTINUE
    cmd = "ls -l /OSM/log/pangea"
    flag, cliRet, errMsg = cliUtils.excute_cmd_in_minisystem_with_check(cli,
                                                                        cmd,
                                                                        LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET,
                                   cliRet)
    if flag is not True:
        FILE_ERR_MEG = common.joinLines(FILE_ERR_MEG, errMsg)
        NOT_CHECK = True
        return common.CHECK_FLAG_NOT_CONTINUE
    null_file, has_p_start, has_question_mark = check_file_is_exption(cliRet)
    if null_file:
        LOGGER.logInfo("/OSM/log/pangea Is an empty file")
        return common.CHECK_FLAG_CONTINUE
    for dir in DIR_LIST_CHECK_MARK:
        cmd = LS_L + dir
        flag, cliRet, errMsg = cliUtils.excute_cmd_in_minisystem_with_check(
            cli, cmd, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET,
                                       cliRet)
        if flag is not True:
            FILE_ERR_MEG = common.joinLines(FILE_ERR_MEG, errMsg)
            NOT_CHECK = True
            return common.CHECK_FLAG_NOT_CONTINUE
        null_file, has_p_start, has_question_mark = check_file_is_exption(
            cliRet)
        if null_file:
            return common.CHECK_FLAG_CONTINUE
        if has_p_start:
            FILE_ERR_MEG = common.joinLines \
                (FILE_ERR_MEG,
                 common.getMsg(LANG, "bmc.log.meg", (current_controller, dir)))
    return common.CHECK_FLAG_CONTINUE


def check_file_is_exption(cliRet):
    """
    查看回文是否有文件为空，为P开头，以？开头命令
    :param cliRet:
    :return:
    """
    has_p_start = False
    has_question_mark = False
    is_empty = True
    #这三种情况被视为空文件
    if 'permission denied.' in cliRet.lower() or 'no such file' \
            in cliRet.lower():
        return True, False, False
    lin_list = cliRet.splitlines()
    # total 0即使total为0在有些系统下也可能有空文件或文件夹
    if "total 0" in cliRet.lower():
        for line in lin_list:
            if line.strip()[0] in FILE_TYPE_LIST:
                is_empty = False
                break
        if is_empty is True:
            return True, False, False
    for line in lin_list:
        value_list = line.strip().split(" ")
        if len(value_list) <= 1:
            continue
        if value_list[0].startswith("p"):
            has_p_start = True
        if "??" in cliRet:
            has_question_mark = True
    return False, has_p_start, has_question_mark


def build_controller_name(cli, lang):
    """
    控制器名称为
    构建controller名称
    :return:
    """
    global NODE_ID_AND_CONTROLLER_MAP
    is_qry_succ, present_node_id_list = get_engine_node_id_list(
        cli)
    check_ret = cliUtil.getControllerIdList(cli, lang)
    if is_qry_succ is True and check_ret[0] is True:
        NODE_ID_AND_CONTROLLER_MAP = dict(
            zip(present_node_id_list, check_ret[1]))
        return True
    else:
        return False


def get_engine_node_id_list(cli):
    '''
    @summary: 获取当前引擎的全部健康节点信息，当前节点信息。
    @param cli: cli连接
    @return: current_engine_ctrl_id_list)
        current_engine_ctrl_id_list: 当前引擎的全部健康节点信息
    '''
    # 获取当前节点信息，当前引擎的全部节点信息。
    cmd = 'sys showcls'
    # 当前节点
    current_engine_ctrl_id_list = []
    flag, cliRet, errMsg = common.executeDebugCommand(cli, cmd, PY_JAVA_ENV,
                                                      LOGGER)
    if flag is not True:
        LOGGER.logInfo("get node info Failed. errMsg: %s" % errMsg)
        return False, current_engine_ctrl_id_list

    engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)

    for engineInfo in engineInfoDictList:
        ctrlNodeId = engineInfo.get("id", "")
        if ctrlNodeId == "":
            continue
        current_engine_ctrl_id_list.append(ctrlNodeId)
    return True, current_engine_ctrl_id_list





