# -*- coding: UTF-8 -*-

from cbb.frame.base import product

import common
import cliUtil
import config 
from common import AsynProgress

PY_JAVA_ENV = py_java_env
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ""
originInfos = []
allPortList4OneGroup = []
bondPort = {}
checkResultList = []

def execute(cli):
    '''
     NAS业务冗余链路风险检查
    '''
    global ALL_CLI_RET
    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    try:
        myPthread.start_thread()
        p_version = str(PY_JAVA_ENV.get("devInfo").getProductVersion())
        p_model = str(PY_JAVA_ENV.get("devInfo").getDeviceType())
        flag, product, cli_ret, err_msg = cliUtil.getProductVersionWithCliRet(
            cli, LANG
        )
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        if flag is not True:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, err_msg

        risk_flag = check_is_risk_version(p_version, p_model)
        if not risk_flag:
            return cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, ''

        if is_dorado_v6_risk_version(p_version):
            check_ret = check_nas_business_for_v6(cli)
        else:
            # 检查FTP、CIFS、NFS、NDMP是否都存在
            check_ret = checkNasBusiness(cli)
        if check_ret[0] != common.CHECK_FLAG_CONTINUE:
            return check_ret
        #冗余链路检查
        return checkRedundantLink(cli)                
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        #停止刷新进度
        myPthread.setStopFlag(True)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def check_is_risk_version(p_version, p_model):
    """
    检查是否风险版本和型号
    dorado 6.1 是风险型号返回 True
    检查是否在检查版本范围内V300R003C10及之后的版本或者是否为Dorado NAS型号
    :return: True 是风险版本需要继续检查
              False 非风险版本
    """
    # 检查是否在检查版本范围内V300R003C10及之后的版本或者是否为Dorado NAS型号
    if is_dorado_v6_risk_version(p_version):
        return True
    if p_version < config.NAS_REDUNTANT_LINK_VER["minCurrentVersion"] and \
            'Dorado NAS' not in p_model:
        LOGGER.logInfo("The device not need check nas redundant link.")
        return False

    return True


def is_dorado_v6_risk_version(p_version):
    return product.isDigitalVer(p_version) and (p_version >= "6.1" or p_version <= "5.9")


def queryLogicalPortInfo(cli):
    '''查询所有的逻辑端口信息'''
    global ALL_CLI_RET
    logicalPortInfoList = []
    cmd = "show logical_port general |filterColumn include columnList=Logical\\sPort\\sName,Failover\\sGroup\\sID,Support\\sProtocol"
    checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
    if not cliUtil.hasCliExecPrivilege(checkRet[1]):
        return (False, logicalPortInfoList, common.getMsg(LANG, "query.result.abnormal"))
    if checkRet[0] != True:
        return (False, logicalPortInfoList, checkRet[2])
    if cliUtil.queryResultWithNoRecord(checkRet[1]):
        return (True, logicalPortInfoList, "")

    logicalPortInfoList = cliUtil.getHorizontalCliRet(checkRet[1])
    if len(logicalPortInfoList) == 0:
        return (False, logicalPortInfoList, common.getMsg(LANG, "query.result.abnormal"))
    return (True, logicalPortInfoList, "")

def queryETHPortByFailoverGroupId(cli, failoverGroupId):
    '''查询漂移组内所有的ETH物理端口'''
    global ALL_CLI_RET, allPortList4OneGroup
    cmd = "show failover_group member failover_group_id=%s type=eth_port" % failoverGroupId
    checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
    if not cliUtil.hasCliExecPrivilege(checkRet[1]):
        return (False, "", common.getMsg(LANG, "query.result.abnormal"))
    if checkRet[0] != True:
        return (False, "", checkRet[2])
    if cliUtil.queryResultWithNoRecord(checkRet[1]):
        return (True, "", "")
    cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
    for line in cliRetLinesList:
        runningStatus = line.get("Running Status")
        if runningStatus == "Link Up":
            portId = line.get("ID")
            allPortList4OneGroup.append(portId)
    return (True, "", "")

def checkRedundantPort(portIdList):
    '''
        检查端口是否 A/B 平面冗余;区分端口所属平面的方法：
        物理端口ID为CTEx.A.XX或CTEx.C.XX,或者CTEx.Rx.IOMx.xx格式的，或者CTEx.IOM.Hx.xx为A平面;
        物理端口ID为CTEx.B.XX或CTEx.D.XX,或者CTEx.Lx.IOMx.xx格式的，或者CTEx.IOM.Lx.xx为B平面
    '''
    ctrl_second_ids = []
    ctrl_third_ids = []
    for portId in portIdList:
        seg = portId.split(".")
        #支持共享卡的设备物理端口命名规则改为CTEx.IOM.x.x，检查第三位
        if len(seg) > 2 and seg[1].upper() == 'IOM':
            # 共享卡设备取第三位判断平面，Hx为A平面，Lx为B平面
            ctrl_id = seg[2][0]
            ctrl_third_ids.append(ctrl_id)
        else:
            ctrl_id = seg[1][0]
            ctrl_second_ids.append(ctrl_id)
    # 检查第二位
    ctrl_second_a_plan = ["A", "C", "R"]
    ctrl_second_b_plan = ["B", "D", "L"]
    ctrl_second_ids = map(lambda x: x[-1].upper(), ctrl_second_ids)
    second_a_list = list(
        set(ctrl_second_ids).intersection(set(ctrl_second_a_plan)))
    second_b_list = list(
        set(ctrl_second_ids).intersection(set(ctrl_second_b_plan)))
    # 检查第三位
    ctrl_third_a_plan = ["H"]
    ctrl_third_b_plan = ["L"]
    ctrl_third_ids = map(lambda x: x[-1].upper(), ctrl_third_ids)
    third_a_list = list(
        set(ctrl_third_ids).intersection(set(ctrl_third_a_plan)))
    third_b_list = list(
        set(ctrl_third_ids).intersection(set(ctrl_third_b_plan)))
    # A,B平面是否冗余
    return bool(
        (second_a_list or third_a_list) and (second_b_list or third_b_list))


def queryBondPort4FailoverGroup(cli, failoverGroupId):
    '''若ETH_port不冗余，继续检查Bond_port'''
    global ALL_CLI_RET, allPortList4OneGroup
    cmd = "show failover_group member failover_group_id=%s type=bond_port" % failoverGroupId
    checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
    if not cliUtil.hasCliExecPrivilege(checkRet[1]):
        return (False, "", common.getMsg(LANG, "query.result.abnormal"))
    if checkRet[0] != True:
        return (False, "", checkRet[2])
    if cliUtil.queryResultWithNoRecord(checkRet[1]):
        return (True, "", "")
    cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
    for line in cliRetLinesList:
        runningStatus = line.get("Running Status")
        if runningStatus == "Link Up":
            bondPortIdStr = line.get("Port ID List")
            bondPortIdList = bondPortIdStr.split(",")
            allPortList4OneGroup.extend(bondPortIdList)
    return (True, "", "")

def queryVlanBondPort(cli, failoverGroupId):
    '''若ETH_port和bond_port不冗余，继续检查vlan下面的绑定口'''
    global ALL_CLI_RET, allPortList4OneGroup, bondPort
    cmd = "show failover_group member failover_group_id=%s type=vlan" % failoverGroupId
    checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
    if not cliUtil.hasCliExecPrivilege(checkRet[1]):
        return (False, "", common.getMsg(LANG, "query.result.abnormal"))
    if checkRet[0] != True:
        return (False, "", checkRet[2])
    if cliUtil.queryResultWithNoRecord(checkRet[1]):
        return (True, "", "")
    cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
    bondPortNameList = []
    for line in cliRetLinesList:
        runningStatus = line.get("Running Status")
        if runningStatus == "Link Up":
            bondPortName = line.get("Port ID")
            portType = line.get("Port Type")
            if portType == "Bond":
                bondPortNameList.append(bondPortName)
            else:
                allPortList4OneGroup.append(bondPortName)
    if len(bondPortNameList) == 0:
        LOGGER.logInfo("The failover(%s) has not vlan." % failoverGroupId)
        return (True, "", "")
    #若已经查询过show bond_port,不再重复执行
    if len(bondPort) == 0:
        queryRet = queryAllBondPort(cli)
        if queryRet[0] == False:
            return (False, "", queryRet[2])
    for bondPortName in bondPortNameList:
        bondPortIdList = bondPort.get(bondPortName, None)
        if bondPortIdList:
            allPortList4OneGroup.extend(bondPortIdList)

    return (True, "", "")

def queryAllBondPort(cli):
    '''查询VLAN下面的所有绑定口'''
    global ALL_CLI_RET, bondPort
    cmd = "show bond_port"
    checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
    if not cliUtil.hasCliExecPrivilege(checkRet[1]):
        return (False, "", common.getMsg(LANG, "query.result.abnormal"))
    if checkRet[0] != True:
        return (False, "", checkRet[2])
    if cliUtil.queryResultWithNoRecord(checkRet[1]):
        return (True, "", "")
    cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
    for line in cliRetLinesList:
        runningStatus = line.get("Running Status")
        if runningStatus == "Link Up":
            name = line.get("Name")
            portIdListStr = line.get("Port ID List")
            bondPort[name] = portIdListStr.split(",")
    return (True, "", "")

def checkFtp(cli):
    '''检查ftp业务'''
    global ALL_CLI_RET
    try:
        cmd = "show service ftp"
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
        if not cliUtil.hasCliExecPrivilege(checkRet[1]) or \
        ("Error: Failed to process the message" in checkRet[1]\
         and "Suggestion: Try again later" in checkRet[1]):
            return CheckResult(True, False, "FTP")
        if checkRet[0] != True:
            return CheckResult(cliUtil.RESULT_NOCHECK, None, "FTP", cmd)
        cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            return CheckResult(cliUtil.RESULT_NOCHECK, None, "FTP", cmd)
        runningStatus = cliRetLinesList[0].get("Running Status", "")
        acceesSwitch = cliRetLinesList[0].get("Anonymous Access Switch", "")
        LOGGER.logInfo("runningStatus : %s , acceesSwitch : %s" % (runningStatus, acceesSwitch))
        if runningStatus.lower() != "running":
            #Running Status的值不是Running,肯定不存在NAS业务
            return CheckResult(True, False, "FTP")
        if acceesSwitch.lower() == "on":
            #Running Status的值是Running，并且Anonymous Access Switch的值是on，存在NAS业务
            return CheckResult(True, True, "FTP")
        
        cmd = "show share_permission ftp"
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return CheckResult(True, False, "FTP")
        
        if checkRet[0] != True:
            return CheckResult(cliUtil.RESULT_NOCHECK, None, "FTP", cmd)
    
        if cliUtil.queryResultWithNoRecord(checkRet[1]):
            return CheckResult(True, False, "FTP")
        # 不为No matching records，则确认存在ftp共享，存在FTP业务
        cliRetLinesList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(cliRetLinesList) == 0:
            return CheckResult(cliUtil.RESULT_NOCHECK, None, "FTP", cmd)
        return CheckResult(True, True, "FTP")
    except Exception, exception:
        LOGGER.logException(exception)
        return CheckResult(cliUtil.RESULT_NOCHECK, None, "FTP", cmd)

def checkCifs(cli, controlList):
    '''检查CIFS业务'''
    global ALL_CLI_RET
    try:
        noCheckCmd = ""
        for ctrlId in controlList:
            cmd = "show cifs server_info controller=%s" % ctrlId
            checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
            
            if not cliUtil.hasCliExecPrivilege(checkRet[1]):
                return CheckResult(True, False, "CIFS")
            
            if checkRet[0] != True:
                noCheckCmd = common.joinLines(noCheckCmd, cmd)
                continue
            
            if cliUtil.queryResultWithNoRecord(checkRet[1]):
                continue
    
            cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
            if len(cliRetLinesList) == 0:
                noCheckCmd = common.joinLines(noCheckCmd, cmd)
                continue
            
            # Protocol Detail 的值大于0，则表示存在CIFS业务
            protocolDetail = cliRetLinesList[0].get("Protocol Detail", "")
            if '/' in protocolDetail:
                for num in protocolDetail.split('/'):
                    if int(num) > 0:
                        return CheckResult(True, True, "CIFS")
        if noCheckCmd != "":
            return CheckResult(cliUtil.RESULT_NOCHECK, None, "CIFS", noCheckCmd)
        else:
            return CheckResult(True, False, "CIFS")
    except Exception, exception:
        LOGGER.logException(exception)
        return CheckResult(cliUtil.RESULT_NOCHECK, None, "CIFS", noCheckCmd)

def checkNfs(cli, controlList):
    '''检查NFS业务'''
    global ALL_CLI_RET
    try:
        noCheckCmd = ""
        p_version = str(PY_JAVA_ENV.get("devInfo").getProductVersion())
        for ctrlId in controlList:
            cmd = "show nfs server_info controller=%s" % ctrlId
            checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
            
            if not cliUtil.hasCliExecPrivilege(checkRet[1]):
                return CheckResult(True, False, "NFS")
            
            if checkRet[0] != True:
                noCheckCmd = common.joinLines(noCheckCmd, cmd)
                continue
    
            if cliUtil.queryResultWithNoRecord(checkRet[1]):
                continue
    
            cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
            if len(cliRetLinesList) == 0:
                noCheckCmd = common.joinLines(noCheckCmd, cmd)
                continue
    
            nfs4ConnectionCount = cliRetLinesList[0].get("NFS4 Connection Count", '0')
            nfs3ConnectionCount = cliRetLinesList[0].get("NFS3 Connection Count", '0')
            nfs41ConnectionConnt = cliRetLinesList[0].get("NFS4.1 Connection Count", '0')

            # 产品可能存在不支持时显示的 --，设置默认值0
            if nfs4ConnectionCount == '--':
                nfs4ConnectionCount = '0'

            if nfs3ConnectionCount == '--':
                nfs3ConnectionCount = '0'

            if nfs41ConnectionConnt == '--':
                nfs41ConnectionConnt = '0'

            if is_dorado_v6_risk_version(p_version):
                if int(nfs3ConnectionCount) > 0:
                    return CheckResult(True, True, "NFS")

            elif int(nfs3ConnectionCount) > 0 or int(
                    nfs4ConnectionCount) > 0 or int(nfs41ConnectionConnt) > 0:
                return CheckResult(True, True, "NFS")
            
        if noCheckCmd != "":
            return CheckResult(cliUtil.RESULT_NOCHECK, None, "NFS", noCheckCmd)
        else:
            return CheckResult(True, False, "NFS")
    except Exception, exception:
        LOGGER.logException(exception)
        return CheckResult(cliUtil.RESULT_NOCHECK, None, "NFS", noCheckCmd)

def checkNdmp(cli):
    '''检查NDMP业务'''
    global ALL_CLI_RET
    try:
        cmd = "show service ndmp_connection"
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, checkRet[1])
        if not cliUtil.hasCliExecPrivilege(checkRet[1]):
            return CheckResult(True, False, "NDMP")
        LOGGER.logInfo("ndmp checkRet=%s" % checkRet[0])
        
        if checkRet[0] != True:
            return CheckResult(cliUtil.RESULT_NOCHECK, None, "NDMP", cmd)
        
        cliRetLinesList = cliUtil.getVerticalCliRet(checkRet[1])
        LOGGER.logInfo("ndmp cliRetLinesList=%s" % cliRetLinesList)
        if len(cliRetLinesList) == 0:
            return CheckResult(cliUtil.RESULT_NOCHECK, None, "NDMP", cmd)
        LOGGER.logInfo("ndmp lient Connection=%s" % cliRetLinesList[0].get("Client Connection"))
    
        if cliRetLinesList[0].get("Client Connection") != "0":
            #Client Connection的值大于0，则表示存在NDMP业务
            return CheckResult(True, True, "NDMP")
        return CheckResult(True, False, "NDMP")
    except Exception, exception:
        LOGGER.logException(exception)
        return CheckResult(cliUtil.RESULT_NOCHECK, None, "NDMP", cmd)


def checkRedundantLink(cli):
    '''冗余链路检查'''
    global ALL_CLI_RET, allPortList4OneGroup
    notRedundantLogicPort = {}
    #获取逻辑端口信息
    queryLogicalPortInfoRet = queryLogicalPortInfo(cli)
    if queryLogicalPortInfoRet[0] == False:
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, queryLogicalPortInfoRet[2]
    logicalPortInfoList = queryLogicalPortInfoRet[1]
    if len(logicalPortInfoList) == 0:
        LOGGER.logInfo("[RedundantLinkCheck]The number of logical port is 0.")
        return True, ALL_CLI_RET, ""
    groupIdRedundantDict = {}  # 保存相同的failoverGroupID的冗余状态，避免同一个ID重复查询端口信息
    # 遍历获取的逻辑端口
    p_version = str(PY_JAVA_ENV.get("devInfo").getProductVersion())
    for logicalPortInfo in logicalPortInfoList:
        allPortList4OneGroup = []
        logicalPortName = logicalPortInfo.get("Logical Port Name")
        supportProtocal = logicalPortInfo.get("Support Protocol")
        failoverGroupId = logicalPortInfo.get("Failover Group ID")
        if failoverGroupId == "--":
            continue
        # dorado v6 只记录包含NFS的逻辑端口
        if is_dorado_v6_risk_version(p_version):
            if "NFS" not in supportProtocal:
                continue
        elif "NFS" not in supportProtocal and "CIFS" not in supportProtocal:
            LOGGER.logInfo("The logical port(%s) is not support nas." % logicalPortName)
            continue
        if groupIdRedundantDict.has_key(failoverGroupId):
            isRedundant = groupIdRedundantDict.get(failoverGroupId)
            if isRedundant == True:
                LOGGER.logInfo("The logical port(%s) is redundant." % logicalPortName)
            else:
                notRedundantLogicPort[logicalPortName] = failoverGroupId
                LOGGER.logInfo("The logical port(%s) is not redundant." % logicalPortName)
            continue

        #查询漂移组ETH端口是否冗余
        portListRet = queryETHPortByFailoverGroupId(cli, failoverGroupId)
        if portListRet[0] == False:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, portListRet[2]
        isRedundant = checkRedundantPort(allPortList4OneGroup)
        groupIdRedundantDict[failoverGroupId] = isRedundant
        if isRedundant == True:
            LOGGER.logInfo("The logical port(%s) is redundant." % logicalPortName)
            continue
        #若ETH不冗余，继续检查bond_port端口
        portListRet = queryBondPort4FailoverGroup(cli, failoverGroupId)
        if portListRet[0] == False:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, portListRet[2]
        isRedundant = checkRedundantPort(allPortList4OneGroup)
        groupIdRedundantDict[failoverGroupId] = isRedundant
        if isRedundant == True:
            LOGGER.logInfo("The logical port(%s) is redundant." % logicalPortName)
            continue
        # 若ETH+bond_port不冗余，继续检查Vlan下面的bond_port端口
        portListRet = queryVlanBondPort(cli, failoverGroupId)
        if portListRet[0] == False:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, portListRet[2]
        isRedundant = checkRedundantPort(allPortList4OneGroup)
        groupIdRedundantDict[failoverGroupId] = isRedundant
        if isRedundant == True:
            LOGGER.logInfo("The logical port(%s) is redundant." % logicalPortName)
        else:
            notRedundantLogicPort[logicalPortName] = failoverGroupId
            LOGGER.logInfo("The logical port(%s) is not redundant." % logicalPortName)

    if notRedundantLogicPort:
        LOGGER.logInfo("put errMsg")
        noRedundantMsg = ""
        for logicPort, failoverGroup in notRedundantLogicPort.items():
            noRedundantMsg += common.getMsg(LANG, "nasRedundantLink.logicport", (logicPort, failoverGroup))
        errMsg = common.getMsg(LANG, "nasRedundantLink.nopass", noRedundantMsg)
        LOGGER.logInfo("errMsg %s" % errMsg)
        return False, ALL_CLI_RET, errMsg
    return True, ALL_CLI_RET, ""


def check_nas_business_for_v6(cli):
    """检查NFS是否都存在"""
    global ALL_CLI_RET
    flag, ctrl_list, err_msg = cliUtil.getControllerIdList(cli, LANG)
    if flag is not True:
        errMsg = common.getMsg(LANG, "cannot.get.controller.info")
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg

    flag, ret, err_msg = cliUtil.enterDeveloperMode(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
    if flag is not True:
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, err_msg

    # 检查NFS业务
    nfs_check_result = checkNfs(cli, ctrl_list)

    # 判断是否有不存在的NAS业务，如果有则返回检查通过
    all_check_ret_list = [nfs_check_result]
    all_no_check_business_name = ""
    all_no_check_cmd = ""
    for check_result in all_check_ret_list:
        if check_result.haveNas:
            LOGGER.logInfo("The NAS business exist:{}".format(
                check_result.businessName)
            )
            return common.CHECK_FLAG_CONTINUE, ALL_CLI_RET, ""
        elif check_result.status == cliUtil.RESULT_NOCHECK:
            all_no_check_business_name = common.joinLines(
                all_no_check_business_name, check_result.businessName
            )
            all_no_check_cmd = common.joinLines(
                all_no_check_cmd, check_result.checkCmd
            )
    if all_no_check_business_name != "":
        err_msg = common.getMsg(
            LANG,
            "one.of.nas.businesses.not.check",
            (all_no_check_cmd, all_no_check_business_name),
        )
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, err_msg
    return True, ALL_CLI_RET, ""


def checkNasBusiness(cli):
    '''检查FTP、CIFS、NFS、NDMP是否都存在'''
    global ALL_CLI_RET
    checkRet = cliUtil.getControllerIdList(cli, LANG)
    if checkRet[0] != True:
        errMsg = common.getMsg(LANG, "cannot.get.controller.info")
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg
    controlList = checkRet[1]
    #检查NFS业务
    nfsCheckResult = checkNfs(cli, controlList)
    #检查CIFS业务
    cifsCheckResult = checkCifs(cli, controlList)
    #检查NDMP业务
    ndmpCheckResult = checkNdmp(cli)
    #检查FTP业务
    ftpCheckResult = checkFtp(cli)
    
    #判断是否有不存在的NAS业务，如果有则返回检查通过，如果没有判断是否存在未检查的情况如果存在，则返回未检查，如果业务都存在则继续检查。
    allCheckResultList = [ftpCheckResult, cifsCheckResult, nfsCheckResult, ndmpCheckResult]
    allHaveNasBusinessName = ""
    allNoCheckBusinessName = ""
    allNoCheckCmd = ""
    for checkResult in allCheckResultList:
        if checkResult.haveNas == True:
            allHaveNasBusinessName = ",".join((allHaveNasBusinessName, checkResult.businessName))
        elif checkResult.status == cliUtil.RESULT_NOCHECK:
            allNoCheckBusinessName = common.joinLines(allNoCheckBusinessName, checkResult.businessName)
            allNoCheckCmd = common.joinLines(allNoCheckCmd, checkResult.checkCmd)
    if allHaveNasBusinessName != "":
        LOGGER.logInfo("The following NAS business exist:%s"%allHaveNasBusinessName)
        return common.CHECK_FLAG_CONTINUE, ALL_CLI_RET, ""
    if allNoCheckBusinessName != "":
        errMsg = common.getMsg(LANG, "one.of.nas.businesses.not.check", (allNoCheckCmd, allNoCheckBusinessName))
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg
    return True, ALL_CLI_RET, ""


class CheckResult():
    def __init__(self, status, haveNas, businessName, checkCmd = ""):
        self.status = status
        self.haveNas = haveNas
        self.businessName = businessName
        self.checkCmd = checkCmd

