# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    BST开关检查: 
        BST Enabled值Yes或No表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show bst configuration"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.bst.config.info")
            LOGGER.logNoPass("Cannot get information about BST Configuration")
            return (False, cliRet, errMsg)
        
        retDict = cliRetLinesList[0]
        bstEnabled = retDict.get("Enabled")
        if not bstEnabled in [common.STATUS_YES, common.STATUS_NO]:
            errMsg = common.getMsg(LANG, "disk.bst.status.abnormal", bstEnabled)
            LOGGER.logNoPass("The BST Enabled Status of Disk is abnormal (Enabled:%s)" % bstEnabled)
            return (False, cliRet, errMsg)
            
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg) 

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
