# -*- coding: UTF-8 -*-
import traceback

import cliUtil
import common
from cbb.frame.util.common import fakeProgress
from common_utils import get_err_msg

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def execute(cli):
    """
    环形3DC执行切检查
    :param cli:
    :return:
    """
    net_check_bond_mtu = CheckDrStarVersion(
        cli, LANG, PY_JAVA_ENV, LOGGER
    )
    flag, msg = net_check_bond_mtu.execute_check()
    return flag, "\n".join(net_check_bond_mtu.all_ret_list), msg


class CheckDrStarVersion:
    def __init__(self, cli, lang, env, logger):
        self.cli = cli
        self.lang = lang
        self.env = env
        self.logger = logger
        self.all_ret_list = []

    def execute_check(self):
        try:
            err_msg_id_list = self.check_dr_star()
            if not err_msg_id_list:
                return True, ''
            return False, get_err_msg(
                LANG, "software.check.dr.star.version.not.pass",
                '\n'.join(err_msg_id_list)
            )
        except common.UnCheckException as e:
            LOGGER.logError(str(e))
            return cliUtil.RESULT_NOCHECK, e.errorMsg
        except Exception:
            LOGGER.logError(str(traceback.format_exc()))
            return (
                cliUtil.RESULT_NOCHECK,
                common.getMsg(self.lang, "query.result.abnormal"),
            )

    def check_dr_star(self):
        """
        判断3DC执行切检查结果
        :return: 错误的端口ID list
        """
        err_id_list = list()
        cmd = "show dr_star general"
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(self.cli, cmd,
                                                            True, self.lang)
        self.all_ret_list.append(cli_ret)
        if flag is not True:
            raise common.UnCheckException(err_msg, cli_ret)

        if cliUtil.queryResultWithNoRecord(cli_ret):
            return err_id_list

        bond_port_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)
        err_id_list = [bond.get("ID") for bond in bond_port_list
                       if bond.get("ID")]
        return err_id_list
