# -*- coding: UTF-8 -*-
import traceback

import cliUtil
import common
from common import UnCheckException
from common_utils import get_err_msg

from cbb.business.checkitems.check_ipvsix_on_cross_intf_bonding import (
    CrossIntfBondCheck,
)

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """
    跨卡绑定端口IPV6地址检查
    :param cli:
    :return:
    """
    dev_info = PY_JAVA_ENV.get("devInfo")
    p_version_mem = str(dev_info.getProductVersion())
    p_model = str(dev_info.getDeviceType())
    bond_port_check = CrossIntfBondCheck(
        cli, LANG, LOGGER, p_version_mem, p_model, [], False
    )
    try:
        flag = bond_port_check.execute_check()
        all_ret = "\n".join(bond_port_check.all_cli_ret)
        LOGGER.logInfo(
            "flag is:{}, physic msg is:{}".format(
                flag, bond_port_check.physic_port_err_bond_name)
        )
        if flag:
            return True, all_ret, ""
        err_msg_list = create_err_msg(bond_port_check)
        return False, all_ret, "".join(err_msg_list)
    except UnCheckException as e:
        return (
            cliUtil.RESULT_NOCHECK, "\n".join(bond_port_check.all_cli_ret),
            e.errorMsg,
        )
    except Exception:
        LOGGER.logError(str(traceback.format_exc()))
        return (
            cliUtil.RESULT_NOCHECK, "\n".join(bond_port_check.all_cli_ret),
            common.getMsg(LANG, "query.result.abnormal"),
        )


def create_err_msg(bond_port_check):
    """
    创建错误消息
    :param bond_port_check:
    :return:
    """
    err_msg_list = []
    # 存在物理口直接绑定跨卡绑定。
    if bond_port_check.physic_port_err_bond_name:
        err_key = "software.cross.intf.bond.physic.not.pass"
        params = ",".join(bond_port_check.physic_port_err_bond_name)
        err_msg_list.append(get_err_msg(LANG, err_key, params))
    LOGGER.logInfo(
        "logical_port_err_logic_name:{}".format(
            bond_port_check.logical_port_err_logic_name)
    )
    # 存在逻辑端口带VLAN/不带VLAN跨卡绑定。
    if bond_port_check.logical_port_err_logic_name:
        err_key = "software.cross.intf.bond.logic.not.pass"
        params = ",".join(bond_port_check.logical_port_err_logic_name)
        err_msg_list.append(get_err_msg(LANG, err_key, params))
    LOGGER.logInfo(
        "default_fg_err_port_list:{}".format(
            bond_port_check.default_fg_err_port_list)
    )
    # 存在漂移组默认逻辑端口跨卡绑定
    if bond_port_check.default_fg_err_port_list:
        err_key = "software.cross.intf.bond.default.fg.not.pass"
        params = ",".join(bond_port_check.default_fg_err_port_list)
        err_msg_list.append(get_err_msg(LANG, err_key, params))
    LOGGER.logInfo(
        "fg_err_port_dict:{}".format(bond_port_check.fg_err_port_dict)
    )
    # 存在漂移组非默认逻辑端口跨卡绑定
    if bond_port_check.fg_err_port_dict:
        for fg, err_port_info in bond_port_check.fg_err_port_dict.items():
            err_key = "software.cross.intf.bond.fg.not.pass"
            params = (err_port_info.get("logic_ports"),
                      err_port_info.get("bond_names"))
            err_msg_list.append(get_err_msg(LANG, err_key, params))
    return err_msg_list
