# -*- coding: UTF-8 -*-
"""
@version: Toolkit V200R006C00
@time: 2019,10,17
@file: check_item_software_ftp_ARM.py
@function:
@modify:
"""
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

check_device_type = {'2100 V3', '2200 V3', '2600 V3', '2600F V3', '5300 V5',
                     '5500 V5 Elite', '5110 V5', '5110F V5', '5210 V5',
                     '5210F V5'}
check_device_version = {'V300R006C50SPC100', 'V300R006C50SPC200',
                        'V300R006C60', 'V500R007C30SPC100',
                        'V500R007C30SPC200', 'V500R007C50'}


def execute(cli):
    all_cli_ret = ''
    # 获取设备型号
    sys_flag, product_model, sys_cli_ret, error_msg = cliUtil.\
        getProductModelWithCliRet(cli, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, sys_cli_ret)
    if sys_flag is not True:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, error_msg
    # 获取设备版本和热补丁
    cli_ret, sys_version_list, hotpatch_version_list = \
        common.parse_upgradePackage(cli, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, cli_ret[1])
    if cli_ret[0] is not True:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, cli_ret[2]
    hot_patch_flag, hot_patch, hotpatch_error = common.getHotPatchVersion(
        hotpatch_version_list, LANG)
    if not hot_patch_flag:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, hotpatch_error
    product_version_flag, product_version, product_version_error \
        = common.getCurrentVersion(sys_version_list, LANG)
    if not product_version_flag:
        return cliUtil.RESULT_NOCHECK, all_cli_ret, product_version_error
    if not check_bug_version(product_model, product_version, hot_patch):
        return True, all_cli_ret, ''
    cmd = 'show service ftp'
    ftp_flag, ftp_cli_ret, ftp_error = \
        cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    all_cli_ret = common.joinLines(all_cli_ret, ftp_cli_ret)
    if ftp_flag is not True:
        # 如果执行失败，看是否是命令不支持，如果命令不支持视为成功
        for line in ftp_cli_ret.splitlines():
            if line.strip() == "^":
                return True, all_cli_ret, ''
        return cliUtil.RESULT_NOCHECK, all_cli_ret, ftp_error
    # 解析FTP回显
    dict_list = cliUtil.getVerticalCliRet(ftp_cli_ret)
    for info in dict_list:
        running_status = info.get('Running Status')
        if running_status == "Running":
            return False, all_cli_ret, \
                   common.getMsg(LANG, 'ftp.arm.status.error')
    return True, all_cli_ret, ''


def check_bug_version(product_model, product_version, hot_patch):
    """
    检查版本和补丁
    :param product_model:model
    :param product_version:version
    :param hot_patch:hot_patch
    :return:T F
    """
    if product_model not in check_device_type \
            or product_version not in check_device_version:
        return False
    else:
        if (product_version.startswith(
            'V300R006') and hot_patch >= 'V300R006C50SPH108') or (
                product_version.startswith(
                    'V500R007') and hot_patch >= 'V500R007C30SPH108'):
            return False
    return True
