# -*- coding: UTF-8 -*-
import cliUtil
import common
import traceback
import config
from common import AsynProgress
from com.huawei.ism.tool.obase.exception import ToolException

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ""
CHECK_ISCSI_DORADO_V3_PRODUCT_MODEL_LIST = ["Dorado5000 V3", "Dorado6000 V3", "Dorado18000 V3"]
CHECK_ISCSI_DORADO_V3_VERSION_HOTPATCH_DICT = {"V300R001C30SPC100": "V300R001C30SPH102"}


def execute(cli):
    '''

    '''
    global ALL_CLI_RET
    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start_thread()
    connCli = ""
    needInstallHotPatchFlag = True
    try:
        # 检查设备型号
        productModel = str(common.getProductModeFromContext(PY_JAVA_ENV))
        if productModel not in CHECK_ISCSI_DORADO_V3_PRODUCT_MODEL_LIST:
            return (True, ALL_CLI_RET, "")

        # 查询产品版本和补丁版本号
        flag, cliRet, errMsg, softwareVersion, hotPatchVersion = common.getVersion(cli, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))
        LOGGER.logInfo("softwareVersion is: %s, hotPatchVersion:%s" % (softwareVersion, hotPatchVersion))
        if softwareVersion not in CHECK_ISCSI_DORADO_V3_VERSION_HOTPATCH_DICT:
            return (True, ALL_CLI_RET, "")
        # 如果未安装热补丁则记录需要安装热补丁。
        needHotPatchVersion = CHECK_ISCSI_DORADO_V3_VERSION_HOTPATCH_DICT.get(softwareVersion, "")
        if needHotPatchVersion != "" and hotPatchVersion != "--" and hotPatchVersion >= needHotPatchVersion:
            needInstallHotPatchFlag = False

        # 检查每个控制器的iscsi复制链路是否超过8条
        checkFlag, isExistIscsiRisk, errMsg = checkIsExistIscsiRisk(cli)
        if checkFlag != True:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))

        if isExistIscsiRisk and needInstallHotPatchFlag:
            return (False, ALL_CLI_RET,
                    common.getMsg(LANG, "check.iscsi.dorado.v3.exist.risk.install.hotpatch", needHotPatchVersion))
        if isExistIscsiRisk:
            return (False, ALL_CLI_RET, common.getMsg(LANG, "check.iscsi.dorado.v3.exist.risk"))
        if needInstallHotPatchFlag:
            return (
                False, ALL_CLI_RET, common.getMsg(LANG, "check.iscsi.dorado.v3.install.hotpatch", needHotPatchVersion))
        return (True, ALL_CLI_RET, "")

    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def checkIsExistIscsiRisk(cli):
    '''
    检查每个控制器的iscsi复制链路是否超过8条
    :param cli:
    :return:
    '''
    global ALL_CLI_RET
    isExistIscsiRisk = False
    ctrlAndIscsiLinkDict = {}
    cmd = "show remote_device link link_type=iSCSI"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return (False, isExistIscsiRisk, errMsg)
    iscsiLinkInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
    for iscsiLinkInfoDict in iscsiLinkInfoDictList:
        ctrlId = iscsiLinkInfoDict.get("Local Controller")
        if ctrlId not in ctrlAndIscsiLinkDict:
            ctrlAndIscsiLinkDict[ctrlId] = []
        ctrlAndIscsiLinkDict[ctrlId].append(iscsiLinkInfoDict)
    # 判断每个控制器的iscsi链路是否超过8条
    for ctrlId in ctrlAndIscsiLinkDict:
        if len(ctrlAndIscsiLinkDict.get(ctrlId)) > 8:
            LOGGER.logInfo("The number of iscsi replication links for controllers with ID %s exceeds 8" % ctrlId)
            isExistIscsiRisk = True
    return (True, isExistIscsiRisk, "")
