# -*- coding: UTF-8 -*-
import cliUtil
import common
import common_cache
import cli_util_cache as cache_util
from common import get_all_lun_detail_info_with_cache
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env

def execute(cli):
    """
    LUN归属检查:
    检查标准
        1 如果步骤3中存在LUN的Work Controller或Owner Controller的值为"--"，
        或存在LUN的Work Controller和Owner Controller的值不相等，
        则检查不通过，否则检查通过。
    检查步骤
        步骤1 以admin用户登录设备；
        步骤2 执行命令：show lun general，获取ID值；
        步骤3 执行命令：show lun general lun_id=LUNID
        获取Work Controller和Owner Controller的值（LUNID为步骤2中查询出的
        LUN的ID）。

    :param cli:
    :return:
    """

    all_cli_ret_list = []
    invalid_msg_list = []
    err_msg_list = []
    err_msg_total = ""
    try:
        common.refreshProcess(PY_JAVA_ENV, 2, LOGGER)
        dev_info = PY_JAVA_ENV.get("devInfo")
        sn = common.get_sn_from_env(PY_JAVA_ENV)
        obj_py = PY_JAVA_ENV.get("objectForPy")
        # 如果是使用config则不提前查询

        lun_info_dict_list = cache_util.get_lun_info_from_config(obj_py,
                                                                 LOGGER,
                                                                 sn)
        LOGGER.logInfo("config lun:{0}".format(len(lun_info_dict_list)))
        if lun_info_dict_list:
            all_lun_info, cli_ret = common.get_all_lun_info_with_cache(
                PY_JAVA_ENV, cli, LOGGER)
            if not all_lun_info:
                return True, cli_ret, ""

            all_cli_ret_list.append(cli_ret)
            lun_id_list = [lun_info.get("ID") for lun_info in
                           all_lun_info]

            for lun_info in lun_info_dict_list:
                lun_id = lun_info.get("ID")
                # V500R007C6x config中没有新增字段Is ROW LUN Child。
                if lun_id_list and lun_id not in lun_id_list:
                    continue

                is_row_lun_child = lun_info.get("Is ROW LUN Child", "No")
                # row lun 的子LUN不检查
                if is_row_lun_child == 'Yes':
                    continue

                tmp_list = []
                work_ctrl = lun_info.get("Work Controller")
                owner_ctrl = lun_info.get("Owner Controller")
                lun_id = lun_info.get("ID")
                tmp_list.append("\nID:{0}".format(lun_id))
                tmp_list.append("Work Controller:{0}".format(work_ctrl))
                tmp_list.append("Owner Controller:{0}\n".format(owner_ctrl))
                all_cli_ret_list.append("\n".join(tmp_list))

                if work_ctrl == "--" or owner_ctrl == "--":
                    invalid_msg_list.append(lun_id)
                    continue

                if work_ctrl != owner_ctrl:
                    err_msg_list.append(lun_id)
        else:
            # 获取show lun general信息
            all_lun_info, cli_ret = common.get_all_lun_info_with_cache(
                PY_JAVA_ENV, cli, LOGGER)
            if not all_lun_info:
                return True, cli_ret, ""

            all_cli_ret_list.append(cli_ret)
            lun_id_list = [lun_info.get("ID") for lun_info in all_lun_info]
            step_process = 97.0/len(lun_id_list)
            LOGGER.logInfo("lun_id_list is :%s" % str(lun_id_list))
            # 获取lun详情
            tmp_list, cli_list = get_all_lun_detail_info_with_cache(
                cli, lun_id_list, PY_JAVA_ENV, LOGGER, step_process, 2)
            LOGGER.logInfo("tmp_list len is :%s" % len(tmp_list))
            all_cli_ret_list.extend(cli_list)
            for lun_info in tmp_list:
                work_ctrl = lun_info.get("Work Controller")
                owner_ctrl = lun_info.get("Owner Controller")
                lun_id = lun_info.get("ID")

                if work_ctrl == "--" or owner_ctrl == "--":
                    invalid_msg_list.append(lun_id)
                    continue

                if work_ctrl != owner_ctrl:
                    err_msg_list.append(lun_id)

        if err_msg_list:
            key = "lun.controller.owner.inconsistent"
            err_msg_total += common.getMsg(LANG,
                                           key,
                                           ",".join(err_msg_list))

        if invalid_msg_list:
            key = "lun.controller.owner.invalid"
            err_msg_total += common.getMsg(LANG,
                                           key,
                                           ",".join(invalid_msg_list))

        ret = common_cache.save_cli_ret_to_file(all_cli_ret_list,
                                                "software_lun_ownership",
                                                PY_JAVA_ENV, LOGGER)

        if err_msg_total:
            return cliUtil.RESULT_WARNING, ret, err_msg_total

        return True, ret, ''

    except common.UnCheckException, un_check_e:
        ret = common_cache.save_cli_ret_to_file(all_cli_ret_list,
                                                "software_lun_ownership",
                                                PY_JAVA_ENV, LOGGER)
        return cliUtil.RESULT_NOCHECK, ret, un_check_e.errorMsg

    except Exception, exception:
        LOGGER.logException(exception)
        ret = common_cache.save_cli_ret_to_file(all_cli_ret_list,
                                                "software_lun_ownership",
                                                PY_JAVA_ENV, LOGGER)
        return (cliUtil.RESULT_NOCHECK, ret,
                common.getMsg(LANG, "query.result.abnormal"))
    finally:
        common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)
