# -*- coding: UTF-8 -*-

from com.huawei.ism.tool.obase.exception import ToolException

import cliUtil
import common
import traceback
import config
from common import UnCheckException

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ''

# Debug模式下TYPE 型号显示
TYPE_SSD = "TYPE_SSD"
TYPE_SATA = "TYPE_SATA"
TYPE_SAS = "TYPE_SAS"

# 查询tier时对应的盘类型
TIER_TYPE_SSD = "Extreme Performance"
TIER_TYPE_SATA = "Capacity"
TIER_TYPE_SAS = "Performance"
# 开始检查版本，主要用于截取版本信息
START_CHECK_VERSION = "V300R003C20"

CURRENT_PROGRESS = 1

def execute(cli):
    """
        步骤1 以admin用户登录设备。
        步骤2 执行命令show storage_pool general 查询存储池ID和硬盘域Disk Domain ID。
        步骤3 执行命令show storage_pool tier pool_id=ID 查询存储池各tier层Name成员盘个数RAID Disk Number。
        步骤4 执行命令show upgrade package，所有控制器Name和对应的IP地址。
        步骤5 执行命令change user_mode current_mode user_mode=developer命令，执行debug命令进入debug模式。
        步骤6 执行命令sys showcls，查询本节点的local node id 和引擎engine和引擎内节点数量。
        步骤7 执行命令pmgr showdisk -p <Disk Domain ID>，查询指定存储池的硬盘域中的成员盘列表，计算三种不同类型硬盘的数量。
        步骤8 执行数量检查，如果不通过，检查不通过。
        步骤9 minisystem视图下执行sshtoremoteExt x(x = 节点id % 引擎下节点数量) 命令，实现同引擎内控制器间跳转登录。
        步骤10 登录当前引擎内所有控制器执行步骤5、6、7、8。
        步骤11 连接集群中所有引擎执行步骤5至步骤10。
        check_item_software_storagepool_disk_num
    """
    global CURRENT_PROGRESS
    try:
        common.refreshProcess(PY_JAVA_ENV, CURRENT_PROGRESS, LOGGER)
        # 过滤版本信息
        isRisk = isRiskProductVersion(cli)
        #刷新进度条
        common.refreshProcess(PY_JAVA_ENV, 5, LOGGER)
        if not isRisk:
            #刷新进度条
            common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)
            return (cliUtil.RESULT_NOSUPPORT, ALL_CLI_RET, "")
        
        # 查询存储池信息
        poolInfoDict, domainIdList = getStoragePoolInfo(cli)
        LOGGER.logInfo("poolInfoDict is: %s, domainIdList:%s" % (poolInfoDict, domainIdList))
        #刷新进度条
        common.refreshProcess(PY_JAVA_ENV, 10, LOGGER)
        
        if not poolInfoDict:
            #刷新进度条
            common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)
            return (True, ALL_CLI_RET, "")

        # 更新存储池tier信息
        updatePoolInfo(cli, poolInfoDict)
        LOGGER.logInfo("poolInfoDict is: %s" % poolInfoDict)
        #刷新进度条
        CURRENT_PROGRESS = 20
        common.refreshProcess(PY_JAVA_ENV, CURRENT_PROGRESS, LOGGER)
        
        # 获取每个引擎下的IP。
        flag, errMsg, ipListDict = getContrIpListOfEngine(cli, LANG)
        LOGGER.logInfo("ipListDict:[%s]" % ipListDict)
        CURRENT_PROGRESS = 25
        common.refreshProcess(PY_JAVA_ENV, CURRENT_PROGRESS, LOGGER)
        if flag != True:
            common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)
            raise UnCheckException(errMsg, ALL_CLI_RET)
        
        
        
        # 检查所有框下的控制器。
        errPoolIdList = checkAllEnclosure(cli, ipListDict, poolInfoDict, domainIdList)
        errPoolIdList = list(set(errPoolIdList))
        LOGGER.logInfo("errPoolIdList:[%s]" % errPoolIdList)

        if errPoolIdList:
            LOGGER.logInfo("poolInfoDict is: %s" % poolInfoDict)
            errMsg = common.getMsg(LANG, "storage.pool.disk.num.check.suggestion", ",".join(errPoolIdList))
            common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)
            return (cliUtil.RESULT_WARNING, ALL_CLI_RET, errMsg)
        
        common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)
        
        CURRENT_PROGRESS = 1
        return (True, ALL_CLI_RET, "")

    except UnCheckException, unCheckException:
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)

    except (ToolException, Exception) as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))

    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))

        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def checkAllEnclosure(cli, ipListDict, poolInfoDict, domainIdList):
    """
    检查当前框下的控制器信息：
    1.SVP 获取IP依次检查每个框。
    2.非SVP，则使用当前连接检查当前已连接的框，然后获取IP建立其他框的连接，再检查每个框。
    :param cli:
    :return:
    """
    global CURRENT_PROGRESS, ALL_CLI_RET
    total_progress = 70.0
    part_progress = total_progress/len(ipListDict)
    err_pool_list = []
    current_ctrl_ip = py_java_env.get("devInfo").getIp()
    # 设置默认值为0号引擎，下面根据实际值更新
    current_engine = u'0'
    for engine_id in ipListDict:
        ip_list = ipListDict[engine_id]
        if current_ctrl_ip in ip_list:
            current_engine = engine_id
            LOGGER.logInfo("check currentIp is in ipList: True")
            break

    if common.is18000(PY_JAVA_ENV, cli):
        # 依次检查所有引擎
        flag, msg, tmp_cli, conn_ip = common.getConnectionByContrIpWithConnIp(
            PY_JAVA_ENV, cli, ipListDict, current_engine, LOGGER, LANG)
        
        if flag is not True:
            raise UnCheckException(msg, ALL_CLI_RET)

        if not tmp_cli:
            raise UnCheckException(msg, ALL_CLI_RET)

        try:
            err_pool_temp = check_all_node_in_engine(tmp_cli, domainIdList,
                                                     poolInfoDict,
                                                     part_progress)

            err_pool_list.extend(err_pool_temp)
            ipListDict.pop(current_engine)
            LOGGER.logInfo("ipListDict is：%s" % ipListDict)
            info_tuple = common.getEngineCtrlNodeInfo(tmp_cli, LOGGER, LANG)
            LOGGER.logInfo("info tuple is：%s" % str(info_tuple))
            for engineId in ipListDict:
                flag, ret, msg, conn, exits = common.enginesJump(tmp_cli,
                                                                 engineId,
                                                                 info_tuple[5],
                                                                 info_tuple[3],
                                                                 info_tuple[6],
                                                                 PY_JAVA_ENV,
                                                                 LOGGER,
                                                                 LANG,
                                                                 info_tuple[4])
                ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
                if flag is not True:
                    raise UnCheckException(msg, ALL_CLI_RET)

                err_pool_temp = check_all_node_in_engine(conn, domainIdList,
                                                         poolInfoDict,
                                                         part_progress)
                if not err_pool_temp:
                    continue

                err_pool_list.extend(err_pool_temp)
                common.enginesBack(conn, PY_JAVA_ENV, LOGGER, LANG, exits)
                LOGGER.logInfo("exit heart beat success.")

        except UnCheckException, unCheckException:
            raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
        finally:
            if current_ctrl_ip != conn_ip:
                common.closeSSH(tmp_cli)

        return err_pool_list
    else:
        # 检查当前引擎下的全部控制器
        pool_tmp = check_all_node_in_engine(cli, domainIdList, poolInfoDict,
                                            part_progress)
        if pool_tmp:
            err_pool_list.extend(pool_tmp)

        if current_engine in ipListDict:
            # 当前引擎使用默认cli连接查询。
            ipListDict.pop(current_engine)

        # 检查其他引擎，如果没有其他引擎就直接返回检查结果。
        if not ipListDict:
            return err_pool_list

        # 继续检查其他引擎，先建CLI连接，再心跳检查该引擎下的全部控制器。
        for engineId in ipListDict:
            info_tuple = common.getEngineCtrlNodeInfo(
                cli, LOGGER, LANG)
            flag, ret, msg, new_cli, exits = common.enginesJump(cli,
                                                                engineId,
                                                                info_tuple[5],
                                                                info_tuple[3],
                                                                info_tuple[6],
                                                                PY_JAVA_ENV,
                                                                LOGGER,
                                                                LANG,
                                                                info_tuple[4])

            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
            if flag is not True:
                raise UnCheckException(msg, ALL_CLI_RET)

            try:
                pool_tmp = check_all_node_in_engine(new_cli,
                                                    domainIdList,
                                                    poolInfoDict,
                                                    part_progress)
                if not pool_tmp:
                    continue

                err_pool_list.extend(pool_tmp)
            except UnCheckException, unCheckException:
                raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
            finally:
                common.enginesBack(new_cli, PY_JAVA_ENV, LOGGER, LANG,
                                   exits)
                LOGGER.logInfo("exit heart beat success.")

        return err_pool_list


def check_all_node_in_engine(cli, domainIdList, poolInfoDict,
                             partEngineProgress):
    """
    检查当前连接引擎是否存在成员盘数量问题。
    :param cli:
    :param domainIdList:
    :param poolInfoDict:
    :return errPoolIdList: 返回有问题的存储池
    """
    global ALL_CLI_RET, CURRENT_PROGRESS
    
    _, currentEngineOtherCtrlIdList = getCurrentEngineCtrlNodeInfo(cli)
    
    # 检查当前节点, 错误的poolId列表
    errPoolIdList = checkCurrentNodePoolDiskNum(cli, domainIdList, poolInfoDict)
    CURRENT_PROGRESS += partEngineProgress
    common.refreshProcess(PY_JAVA_ENV, CURRENT_PROGRESS, LOGGER)
    return errPoolIdList


def checkCurrentNodePoolDiskNum(cli, domainIdList, poolInfoDict):
    """
    检查Domain
    :param cli:
    :param domainIdList:
    :param poolInfoDict:
    :return:
    """
    errPoolIdList = []
    for domainId in domainIdList:
        diskTypeNum = getDiskInDebug(cli, domainId)
        LOGGER.logInfo("diskTypeNum:[%s]" % diskTypeNum)

        for poolId in poolInfoDict:
            poolDomainId = poolInfoDict[poolId].get("diskDomainId", "")
            if poolDomainId != domainId:
                continue

            tierDict = poolInfoDict[poolId].get("tierDict", {})
            if not tierDict:
                continue
            for tierName in tierDict:
                if diskTypeNum.get(tierName, 0) == 0:
                    continue

                if tierDict[tierName] >= diskTypeNum.get(tierName, 0):
                    errPoolIdList.append(poolId)
                    break
    return errPoolIdList


def getDiskInDebug(cli, domainId):
    """
    进入debug模式，查询硬盘域下的各硬盘类型的数量。
    :param cli:
    :param domainId:
    :return:
    """
    global ALL_CLI_RET

    cmd = "pmgr showdisk -p %s" % domainId
    flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    lineList = cliRet.splitlines()
    for line in lineList:
        checkRet = cliUtil.checkLineInBlackList(line, LANG)
        if checkRet[0]:
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "domain"),
                               ALL_CLI_RET)
        
    if flag != True:
        LOGGER.logInfo("Failed to get pmgr showdisk -p errMsg is:%s" % errMsg)
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "domain"),
                               ALL_CLI_RET)

    diskTypeNum = {}
    cliRetList = cliRet.splitlines()
    title = ""
    for line in cliRetList:
        if "tier_type" in line and "|" in line:
            title = line
            continue

        if title:
            if TYPE_SAS in line:
                diskNum = diskTypeNum.get(TIER_TYPE_SAS, 0)
                diskNum += 1
                diskTypeNum[TIER_TYPE_SAS] = diskNum
            elif TYPE_SATA in line:
                diskNum = diskTypeNum.get(TIER_TYPE_SATA, 0)
                diskNum += 1
                diskTypeNum[TIER_TYPE_SATA] = diskNum
            elif TYPE_SSD in line:
                diskNum = diskTypeNum.get(TIER_TYPE_SSD, 0)
                diskNum += 1
                diskTypeNum[TIER_TYPE_SSD] = diskNum
            else:
                LOGGER.logInfo("Failed to disk type info in line:[%s]" % line)
                continue

    return diskTypeNum


def getStoragePoolInfo(cli):
    """
    查询存储池信息
    :param cli:
    :return:
    """
    global ALL_CLI_RET

    poolInfoDict = {}
    domainIdList = []
    cmd = "show storage_pool general"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        LOGGER.logInfo("Failed to get pool errMsg:%s" % errMsg)
        raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "storage pool"),
                               ALL_CLI_RET)
    enclosureInfoList = cliUtil.getHorizontalCliRet(cliRet)
    for enclosureInfo in enclosureInfoList:
        diskDomainId = enclosureInfo.get("Disk Domain ID", "")
        id = enclosureInfo.get("ID", "")
        poolInfoDict[id] = {
            "diskDomainId": diskDomainId
        }

        if diskDomainId in domainIdList:
            continue

        domainIdList.append(diskDomainId)

    return poolInfoDict, domainIdList


def updatePoolInfo(cli, poolInfoDict):
    """
    更新POOL信息
    :param cli:
    :param poolInfoDict:更新POOL TIER 各层关系
    """
    global ALL_CLI_RET
    totalProgress = 10.0
    poolLen = len(poolInfoDict)
    partPoolProgress = 10
    currentProgress = 10
    if poolLen != 0:
        partPoolProgress = totalProgress/poolLen
        
    for poolId in poolInfoDict:
        cmd = "show storage_pool tier pool_id=%s" % poolId
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        if flag != True:
            LOGGER.logInfo("Failed to get storage pool tier errMsg:%s" % errMsg)
            raise UnCheckException(common.getMsg(LANG, "cannot.get.info", "storage pool"),
                                   ALL_CLI_RET)
        poolInfoList = cliUtil.getVerticalCliRet(cliRet)

        for poolInfo in poolInfoList:
            name = poolInfo.get("Name", "")
            raidDiskNum = poolInfo.get("RAID Disk Number", 0)
            tempDict = poolInfoDict.get(poolId, {})
            tierDict = tempDict.get("tierDict", {})
            tierDict[name] = int(raidDiskNum)
            tempDict["tierDict"] = tierDict
            poolInfoDict[poolId] = tempDict
        currentProgress += partPoolProgress
        common.refreshProcess(PY_JAVA_ENV, currentProgress, LOGGER)
        
def getConnectionByContrIp(PY_JAVA_ENV, cli, ip):
    """
    建立到阵列控制器的SSH连接，只有登录控制器的连接才能进入debug，minisystem模式
    :param PY_JAVA_ENV:
    :param cli:
    :param ip:
    :return cliConnection:返回连接
    """
    # 连接进度条总数5
    cilConnection = common.getCilConnectionByIp(ip, PY_JAVA_ENV, LOGGER)
    if cilConnection:
        LOGGER.logInfo('Success to connect to controller(IP:%s)' % ip)
        return (True, cilConnection)
    else:
        LOGGER.logInfo('Failed to connect to controller(IP:%s)' % ip)
        return (False, None)


def getContrIpListOfEngine(cli, lang):
    """
    获取引擎对应下的控制器IP
    :param cli:
    :param lang:
    :return ipListDict: 引擎和引擎下控制器的IP。
    """
    global ALL_CLI_RET

    ipListDict = {}

    cmd = "show upgrade package"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return (flag, errMsg, ipListDict)

    beginIndex = cliRet.find("Software Version")
    endIndex = cliRet.find("HotPatch Version")
    infoDictList = cliUtil.getHorizontalCliRet(cliRet[beginIndex: endIndex])

    for infoDict in infoDictList:
        ip = infoDict.get("IP", "")
        contrName = infoDict.get("Name", "")
        if ip != "" and ip != "--" and contrName != "":
            engine = contrName[:1]
            ipList = ipListDict.get(engine, [])
            ipList.append(ip)
            ipListDict.update({engine: ipList})

    # 控制器未配置管理IP，无法连接控制器。请参考预警公告手动检查。
    if len(ipListDict) == 0:
        errMsg = common.getMsg(LANG, "contr.not.config.ip")
        return (False, errMsg, ipListDict)

    return (True, errMsg, ipListDict)


def getCurrentEngineCtrlNodeInfo(cli):
    """
    @summary: 获取除当前节点外的引擎其他健康节点信息，当前节点信息。
    @param cli: cli连接
    @return: (currentCtrlNodeId, currentEngineCtrlIdList)
        currentNodeId: 当前节点ID
        currentEngineOtherCtrlIdList: 除当前节点外的引擎其他健康节点信息
    """
    global ALL_CLI_RET
    flag, cliRet, errMsg = cliUtil.enterDebugModeFromCliMode(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        LOGGER.logInfo("Failed to enterDebugModeFromCliMode errMsg:%s" % errMsg)
        raise UnCheckException(errMsg, ALL_CLI_RET)
    
    cmd = 'sys showcls'
    # 当前节点
    currentCtrlNodeId = None
    currentEngine = None
    engineCtrlNodeMappingDict = {}

    flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        LOGGER.logInfo("get node info Failed. errMsg: %s" % errMsg)
        raise UnCheckException(common.getMsg(LANG, "chunk.check.get.controller.node.failed"), ALL_CLI_RET)

    ctrlInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)

    for ctrlInfo in ctrlInfoDictList:
        if ctrlInfo.get("local node id", "") != "":
            currentCtrlNodeId = ctrlInfo.get("local node id", "")
            break

    for engineInfo in engineInfoDictList:
        engine = engineInfo.get("engine", "")
        if engine == "":
            continue

        status = engineInfo.get("status", "")
        if status == "" or status != "normal":
            continue

        ctrlNodeId = engineInfo.get("id", "")
        if ctrlNodeId == "":
            continue

        tmpList = engineCtrlNodeMappingDict.get(engine, [])
        tmpList.append(ctrlNodeId)
        engineCtrlNodeMappingDict[engine] = tmpList

        if ctrlNodeId == currentCtrlNodeId:
            currentEngine = engine

    # 当前引擎包含的控制器节点
    currentEngineOtherCtrlIdList = engineCtrlNodeMappingDict.get(currentEngine, [])
    currentEngineOtherCtrlIdList.remove(currentCtrlNodeId)
    return (currentCtrlNodeId, currentEngineOtherCtrlIdList)


def isRiskProductVersion(cli):
    """
    判断是否是风险型号
    :param cli:
    :return: True, 有风险
              False, 无风险
    """
    global ALL_CLI_RET
    # 获取软件型号
    flag, productVersion, _, cliRet, errMsg = common.getProductVersionAndHotPatchVersion(cli, LOGGER, LANG)
    LOGGER.logInfo("productVersion is :%s" % productVersion)
    if flag != True:
        LOGGER.logInfo("Failed to get productVersion errMsg:%s" % errMsg)
        raise UnCheckException(errMsg, ALL_CLI_RET)

    if productVersion[0: len(START_CHECK_VERSION)] >= START_CHECK_VERSION:
        return True

    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    return False
