# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    BMC版本检查: 
                所有控制器的BMC Version一致表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    cliRet = ""
    errMsg = ""
    versionName = "BMC"
    
    try:
        cmd = "show version all"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        controllerRet = cliUtil.getSplitedCliRet(cliRet, "Controller:")
        cliRetLinesList = cliUtil.getVerticalCliRet(controllerRet)
        
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.version.of.controller")
            LOGGER.logNoPass("Cannot get information about version of controllers")
            return (False, cliRet, errMsg)
        
        bmcVersionSet = set()
        for retDict in cliRetLinesList:
            controllerId = retDict.get("Controller")
            bmcVersion = retDict.get("BMC Version")
                
            if len(bmcVersion) > 0:
                bmcVersionSet.add(bmcVersion)
            else:
                flag = False
                errMsg += common.getMsg(LANG, "cannot.get.bmc.version.of.controller", controllerId)
                LOGGER.logNoPass("Cannot get information about BMC version of controller [%s]" % controllerId)
        
        if len(bmcVersionSet) > 1:
            flag = False
            errMsg += common.getMsg(LANG, "version.of.controller.inconsistent", (versionName, ", ".join(bmcVersionSet)))
            LOGGER.logNoPass("The BMC versions of all controllers are inconsistent")
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
