# -*- coding:utf-8 -*-
import traceback

import cliUtil
import common
from common_utils import get_err_msg
from common import UnCheckException
from com.huawei.ism.tool.obase.exception import ToolException
from cbb.business.checkitems.check_zombie_process import (
    CheckZombieProcess,
)
from cbb.business.checkitems.check_zombie_process import (
    is_risk_version,
)


LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
PROCESS_LAB = 10


def execute(cli):
    """
    僵尸进程检查
    :param cli:
    :return:
    """
    all_ret_list = []
    error_message_list = []
    try:
        flag = True
        if not is_risk_version(cli, LANG, all_ret_list):
            return True, "\n".join(all_ret_list), ""
        node_id_and_controller_map = build_controller_name(
            cli, PY_JAVA_ENV, LOGGER, LANG
        )
        common.refreshProcess(PY_JAVA_ENV, PROCESS_LAB, LOGGER)
        process_step = 80//len(node_id_and_controller_map)
        check_all_engine_zombie(
            cli, PY_JAVA_ENV, LOGGER,
            LANG, "", all_ret_list,
            node_id_and_controller_map,
            error_message_list,
            process_step
        )
        if error_message_list:
            flag = False
        return (
            flag,
            "\n".join(all_ret_list),
            "".join(error_message_list),
        )
    except UnCheckException as e:
        LOGGER.logError(str(e))
        return cliUtil.RESULT_NOCHECK, "\n".join(all_ret_list), e.errorMsg
    except (Exception, ToolException):
        LOGGER.logError(str(traceback.format_exc()))
        return (
            cliUtil.RESULT_NOCHECK,
            "\n".join(all_ret_list),
            common.getMsg(LANG, "query.result.abnormal"),
        )
    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo(
            "enter cli mode from some model ret is {}".format(str(ret))
        )
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
        common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)


@common.checkAllEngineInClusterWarp
def check_all_engine_zombie(
    cli,
    env,
    logger,
    lang,
    heart_beat_cli_ret,
    all_ret_list,
    node_id_and_controller_map,
    error_message_list,
    process_step
):
    """
    遍历各个控制器，检查其包含的僵尸进程是否大于20个，大于20个则判断有风险
    :param cli:
    :param env:
    :param logger:
    :param lang:
    :param heart_beat_cli_ret:
    :param all_ret_list:
    :param node_id_and_controller_map:
    :param error_message_list:
    :param process_step
    :return:
    """
    global PROCESS_LAB
    all_ret_list.append(heart_beat_cli_ret)
    (
        _,
        err_msg,
        cli_ret,
        current_ctrl_id,
        engine_ctrl_mapping_dict,
        current_engine,
        node_num,
    ) = common.getEngineCtrlNodeInfo(cli, logger, lang)
    current_controller = node_id_and_controller_map.get(current_ctrl_id, "--")
    check_zombie_process_object = CheckZombieProcess(
        cli, lang, env, logger, all_ret_list
    )
    flag = check_zombie_process_object.execute_check()
    if not flag:
        err_key = "zombie.process.error_message"
        error_message_list.append(
            get_err_msg(lang, err_key, current_controller)
        )
    PROCESS_LAB = PROCESS_LAB + process_step
    common.refreshProcess(PY_JAVA_ENV, PROCESS_LAB, LOGGER)


def build_controller_name(cli, env, logger, lang):
    """
    控制器名称为
    构建controller名称
    :return:
    """
    flag, present_node_id_list = common.get_engine_node_id_list(
        cli, env, logger
    )
    flag, control_list, error_message = cliUtil.getControllerIdList(cli, lang)
    if flag is not True:
        raise common.UnCheckException(error_message, control_list)
    node_id_and_controller_map = dict(zip(present_node_id_list, control_list))
    return node_id_and_controller_map
