#!/usr/bin/python
# -*- coding: UTF-8 -*-

import datetime
from cbb.frame.base.product import isDigitalVer, isKunpeng
from memory_inspect.utils.device_info_table import MACHINE_CONFIG_MAP


def to_hex_str(num):
    return hex(num).strip('L')


def to_int(num_str):
    return int(num_str, 0)


def get_time_by_delta_process(time, **delta):
    """
    对时间进行增量处理
    :param time: 初始时间
    :param delta: 增量
    :return: 新的时间
    """
    old_time = datetime.datetime.strptime(time, "%Y-%m-%d %H:%M:%S")
    new_time = (old_time + datetime.timedelta(**delta)).strftime("%Y-%m-%d %H:%M:%S")
    return new_time


def is_support_memory_check(dev_type, version):
    if "v3" in version.lower() and "dorado" not in dev_type.lower():
        return False
    return True


def is_bom_not_in_white_list(sn, chip_type):
    bom_code = sn[2:10]
    if chip_type == "purely" and bom_code not in MACHINE_CONFIG_MAP:
        return True
    return False


def get_chip_type(product_version):
    if isKunpeng(product_version) or isDigitalVer(product_version):
        return "kunpeng"
    return "purely"
