# coding:utf-8
import re

import cliUtil
import common
from cbb.frame.cli import cli_helper
from common_utils import get_err_msg

PS_EF = "ps -ef"
DIAGNOSE_REG_STR = "/bin/bash /OSM/script/diagnose_cli.sh"
CLI_PROCESS_REG_STR = "/ISM/cli/cli_connect"
MAX_DIAGNOSE_CLI_PROCESS_NUM = 7

RISK_P_VERSION = "6.1.0"


class CheckDiagnoseCliProcess:
    """
    dorado 6.1.0 diagnose进程残留导致CLI连接超规格问题检查
    """
    def __init__(self, cli, lang, logger, env):
        self.cli = cli
        self.lang = lang
        self.logger = logger
        self.env = env
        dev_info = env.get("devInfo")
        self.product_model = str(dev_info.getDeviceType())
        self.product_version = str(dev_info.getProductVersion())

    def is_risk_version(self):
        return RISK_P_VERSION in self.product_version

    def check_diagnose_cli_process_error(self):
        try:
            if not self.is_risk_version():
                return True, ""

            cli_helper.enter_target_mode(self.cli, cli_helper.CliMode.MINI_SYSTEM, self.lang)
            flag, ret, msg = cliUtil.excuteCmdInMinisystemModel(self.cli, PS_EF, self.lang)
            if flag is not True:
                return True, ""

            # 明确检查出问题再提示，其他场景不考虑
            if (
                max(len(re.compile(DIAGNOSE_REG_STR).findall(ret)), len(re.compile(CLI_PROCESS_REG_STR).findall(ret)))
                >= MAX_DIAGNOSE_CLI_PROCESS_NUM
            ):
                return False, get_err_msg(self.lang, "diagnose.cli.process.max.not.pass")
            return True, ""
        finally:
            flag, ret, msg = cliUtil.enterCliModeFromSomeModel(self.cli, self.lang)
            if flag is not True:
                common.reConnectionCli(self.cli, self.logger)
