# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {}
                
res_desc_en = {}
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
    rawInfo = ""
    
    try:
        desc = res_desc[py_java_env.get("lang")]
        sysCont = cli.execCmdWithTimout("showsys", 600) 
        sysadminCont = cli.execCmdWithTimout("sysadmin", 600)     
        heartModeCont = cli.execCmdWithTimout("showheartmode", 600)    
        encosureCont = cli.execCmdWithTimout("showenclosure", 600)
        
        rawInfo = "%s\n%s\n%s\n%s" %(sysCont, sysadminCont, heartModeCont, encosureCont)
        rawInfo = re.sub(r'Processing....[^\w=]*', '', rawInfo)
         
        return (flag, rawInfo, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")