# -*- coding: UTF-8 -*-
import sys,re
import traceback

sys.prefix = "__pyclasspath__"
from vistoollib import *
init_logger(PY_LOGGER.debug)


#设置异常返回的提示信息，涉及到中英文
res_desc_zh = {'Release': ur'发布版本不一致',
               'BIOS Version': ur'BIOS版本不一致',
               'BMC Version': ur'BMC版本不一致',
               'Operation Software Version': ur'操作系统版本不一致',
               'Master CPLD Version': ur'主CPLD版本不一致',
               'Standby CPLD Version': ur'从CPLD版本不一致'}
                
res_desc_en = {'Release': r'Release version is not consistent',
               'BIOS Version': r'BIOS version is not consistent',
               'BMC Version': r'BMC version is not consistent',
               'Operation Software Version': r'Operation Software version is not consistent',
               'Master CPLD Version': r'Master CPLD version is not consistent',
               'Standby CPLD Version': r'Standby CPLD version is not consistent'}
                                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsysdisk")
    Return             : the checkitem is pass;cli source info
    """

    flag = True    
    errMsg = ""
        
    try:
        desc = res_desc[py_java_env.get("lang")]
        ctrlCont = cli.execCmdWithTimout("showcontroller", 600)
        ctrlCont = re.sub(r'Processing....[^\w=]*', '', ctrlCont)        
        ctrlDict = format_cli_info_col(ctrlCont)   
       
        #处理命令执行异常
        if not ctrlDict :  
            return (False, "%s" % (ctrlCont), errMsg)
            
        for keyIdx in desc:
            if len(set(ctrlDict[keyIdx])) != 1:
                flag = False
                errMsg += "%s\n" % (desc[keyIdx])                        
         
        return (flag, ctrlCont, errMsg)
    except BaseException:
        debug_out(traceback.format_exc())
        return (False, "inspect abnomal", "")         
